/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.component;

import cn.acyou.leo.framework.prop.EmailProperty;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private final EmailProperty emailProperty;

    public EmailUtil(EmailProperty emailProperty) {
        this.emailProperty = emailProperty;
    }

    public boolean sendEmail(String toMail, String title, String content) {
        final String username = this.emailProperty.getUsername();
        final String password = this.emailProperty.getPassword();
        Properties props = new Properties();
        props.put("mail.smtp.auth", this.emailProperty.getSmtpAuth());
        props.put("mail.smtp.host", this.emailProperty.getSmtpHost());
        props.put("mail.smtp.port", this.emailProperty.getSmtpPort());
        if (username.endsWith("@qq.com")) {
            props.put("mail.smtp.ssl.enable", "true");
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(username));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toMail));
            message.setSubject(title);
            message.setText(content);
            Transport.send((Message)message);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

