/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.component;

import cn.acyou.leo.framework.prop.OpenApiProperty;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiUtil {
    private static final Logger log = LoggerFactory.getLogger(OpenApiUtil.class);
    private OpenApiProperty openApiProperty;

    public OpenApiUtil() {
    }

    public OpenApiUtil(OpenApiProperty openApiProperty) {
        this.openApiProperty = openApiProperty;
    }

    public void setOpenApiProperty(OpenApiProperty openApiProperty) {
        this.openApiProperty = openApiProperty;
    }

    public JSONObject lookup(String location) {
        String url = String.format("https://geoapi.qweather.com/v2/city/lookup?key=%s&location=%s", this.openApiProperty.getQweatherKey(), location);
        String s = HttpUtil.get((String)url);
        return JSON.parseObject((String)s);
    }

    public JSONObject weatherNow(String location) {
        String url = String.format("https://devapi.qweather.com/v7/weather/now?key=%s&location=%s", this.openApiProperty.getQweatherKey(), location);
        String s = HttpUtil.get((String)url);
        return JSON.parseObject((String)s);
    }

    public JSONObject weather3d(String location) {
        String url = String.format("https://devapi.qweather.com/v7/weather/3d?key=%s&location=%s", this.openApiProperty.getQweatherKey(), location);
        String s = HttpUtil.get((String)url);
        return JSON.parseObject((String)s);
    }

    public JSONObject weather7d(String location) {
        String url = String.format("https://devapi.qweather.com/v7/weather/7d?key=%s&location=%s", this.openApiProperty.getQweatherKey(), location);
        String s = HttpUtil.get((String)url);
        return JSON.parseObject((String)s);
    }

    public JSONObject getPhoneArea(String phone) {
        String s = HttpUtil.get((String)("https://www.haoshudi.com/" + phone + ".htm"));
        Document document = Jsoup.parse((String)s);
        Elements tables = document.select("table tr");
        JSONObject res = new JSONObject();
        for (Element table : tables) {
            String k = ((Element)table.select("td").get(0)).text();
            String v = ((Element)table.select("td").get(1)).text().split(" ")[0];
            res.put(k, (Object)v);
        }
        return res;
    }
}

