/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.util.component;

import cn.acyou.leo.framework.prop.TranslateProperty;
import cn.acyou.leo.framework.util.Md5Util;
import cn.acyou.leo.framework.util.SHAUtil;
import cn.acyou.leo.framework.util.WorkUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateUtil {
    private static final Logger log = LoggerFactory.getLogger(TranslateUtil.class);
    private final TranslateProperty translateProperty;
    private static final String TRANS_API_HOST = "https://openapi.youdao.com/api";
    private static final String BAIDU_TRANS_API_HOST = "http://api.fanyi.baidu.com/api/trans/vip/translate";
    private static final String BAIDU_LANGUAGE_API_HOST = "https://fanyi-api.baidu.com/api/trans/vip/language";

    public TranslateUtil(TranslateProperty translateProperty) {
        this.translateProperty = translateProperty;
    }

    public String baiduLanguage(String q) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", q);
        params.put("appid", this.translateProperty.getBaiduAppId());
        String salt = String.valueOf(System.currentTimeMillis());
        params.put("salt", salt);
        String src = this.translateProperty.getBaiduAppId() + q + salt + this.translateProperty.getBaiduSecurityKey();
        params.put("sign", Md5Util.md5(src));
        String res = HttpUtil.get((String)BAIDU_LANGUAGE_API_HOST, params);
        log.info("\u767e\u5ea6\u7ffb\u8bd1(\u8bed\u79cd\u8bc6\u522b) \u7ed3\u679c q:{} res:{}", (Object)q, (Object)res);
        JSONObject jsonObject = JSON.parseObject((String)res);
        String error_code = jsonObject.getString("error_code");
        if ("54003".equals(error_code)) {
            WorkUtil.trySleep(1000L);
            return this.baiduLanguage(q);
        }
        return jsonObject.getJSONObject("data").getString("src");
    }

    public String baiduTranslate(String q, String from, String to) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", q);
        params.put("from", from);
        params.put("to", to);
        params.put("appid", this.translateProperty.getBaiduAppId());
        String salt = String.valueOf(System.currentTimeMillis());
        params.put("salt", salt);
        String src = this.translateProperty.getBaiduAppId() + q + salt + this.translateProperty.getBaiduSecurityKey();
        params.put("sign", Md5Util.md5(src));
        String res = HttpUtil.get((String)BAIDU_TRANS_API_HOST, params);
        log.info("\u767e\u5ea6\u7ffb\u8bd1 \u7ed3\u679c q:{} res:{}", (Object)q, (Object)res);
        JSONObject jsonObject = JSON.parseObject((String)res);
        String error_code = jsonObject.getString("error_code");
        if ("54003".equals(error_code)) {
            WorkUtil.trySleep(1000L);
            return this.baiduTranslate(q, from, to);
        }
        return jsonObject.getJSONArray("trans_result").getJSONObject(0).getString("dst");
    }

    public String youdaoTranslate(String q, String from, String to) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", q);
        params.put("from", from);
        params.put("to", to);
        String salt = String.valueOf(System.currentTimeMillis());
        String curtime = String.valueOf(System.currentTimeMillis() / 1000L);
        String sb = this.translateProperty.getYoudaoAppKey() + TranslateUtil.getInput(params.get("q").toString()) + salt + curtime + this.translateProperty.getYoudaoAppSecret();
        String sha256 = SHAUtil.getSHA256(sb);
        params.put("salt", salt);
        params.put("appKey", this.translateProperty.getYoudaoAppKey());
        params.put("curtime", curtime);
        params.put("signType", "v3");
        params.put("sign", sha256);
        String s = HttpUtil.get((String)TRANS_API_HOST, params);
        log.info("\u6709\u9053\u7ffb\u8bd1 \u7ed3\u679c q:{} res:{}", (Object)q, (Object)s);
        JSONObject jsonObject = JSON.parseObject((String)s);
        String errorCode = jsonObject.getString("errorCode");
        if (errorCode != null && errorCode.endsWith("411")) {
            WorkUtil.trySleep(1000L);
            return this.youdaoTranslate(q, from, to);
        }
        return jsonObject.getJSONArray("translation").getString(0);
    }

    private static String getInput(String input) {
        String result;
        if (input == null) {
            return null;
        }
        int len = input.length();
        if (len <= 20) {
            result = input;
        } else {
            String startStr = input.substring(0, 10);
            String endStr = input.substring(len - 10, len);
            result = startStr + len + endStr;
        }
        return result;
    }

    public String baidu_langdetect(String query) {
        String s = HttpUtil.get((String)("https://fanyi.baidu.com/langdetect?query=" + query));
        return JSON.parseObject((String)s).getString("lan");
    }

    public JSONArray baidu_sug(String kw) {
        String s = HttpUtil.get((String)("https://fanyi.baidu.com/sug?kw=" + kw));
        return JSON.parseObject((String)s).getJSONArray("data");
    }

    public String baidu_translate(String query, String from, String to) {
        String[] split;
        String res = HttpUtil.createPost((String)"https://fanyi.baidu.com/ait/text/translate").body("{\n  \"query\": \"" + query + "\",\n  \"from\": \"" + from + "\",\n  \"to\": \"" + to + "\",\n  \"reference\": \"\",\n  \"corpusIds\": [],\n  \"qcSettings\": [],\n  \"needPhonetic\": false,\n  \"domain\": \"common\",\n  \"milliTimestamp\": " + System.currentTimeMillis() + "\n}").execute().body();
        for (String s : split = res.split("\n")) {
            if (!s.contains("\u7ffb\u8bd1\u4e2d")) continue;
            JSONObject jsonObject = JSON.parseObject((String)s.substring(6));
            return jsonObject.getJSONObject("data").getJSONArray("list").getJSONObject(0).getString("dst");
        }
        return "";
    }
}

