/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.xss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private byte[] requestBody;
    private Charset charSet;

    private static String[] filter(String[] values) {
        if (values != null) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                if (values[i] == null || "".equals(values[i])) continue;
                values[i] = XssHttpServletRequestWrapper.filter(values[i]);
            }
        }
        return values;
    }

    private static String filter(String value) {
        if (value != null) {
            value = XssHttpServletRequestWrapper.stripXSS(value);
        }
        return value;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            if (request.getContentType() != null && request.getContentType().contains("application/json")) {
                String requestBodyStr = this.getRequestPostStr(request);
                if (StringUtils.hasText((String)requestBodyStr)) {
                    requestBodyStr = XssHttpServletRequestWrapper.filter(requestBodyStr);
                    this.requestBody = requestBodyStr.getBytes(this.charSet);
                } else {
                    this.requestBody = new byte[0];
                }
            } else {
                this.requestBody = this.getRequestPostStr(request).getBytes(this.charSet);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getRequestPostStr(HttpServletRequest request) throws IOException {
        String charSetStr = request.getCharacterEncoding();
        if (charSetStr == null) {
            charSetStr = "UTF-8";
        }
        this.charSet = Charset.forName(charSetStr);
        return StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)this.charSet);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = XssHttpServletRequestWrapper.filter(values[i]);
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() {
        if (this.requestBody == null) {
            this.requestBody = new byte[0];
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    private static String stripXSS(String value) {
        if (value != null) {
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }
}

