/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.xss;

import cn.acyou.leo.framework.util.html.EscapeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class XssHttpServletRequestWrapperV3
extends HttpServletRequestWrapper {
    private byte[] requestBody;
    private Map<String, String[]> parameterMap;
    private Charset charSet;

    public XssHttpServletRequestWrapperV3(HttpServletRequest request) {
        super(request);
        try {
            String requestBodyStr;
            this.parameterMap = request.getParameterMap();
            this.requestBody = request.getContentType() != null && request.getContentType().contains("application/json") ? (StringUtils.hasText((String)(requestBodyStr = this.getRequestPostStr(request))) ? requestBodyStr.getBytes(this.charSet) : new byte[0]) : this.getRequestPostStr(request).getBytes(this.charSet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getRequestPostStr(HttpServletRequest request) throws IOException {
        String charSetStr = request.getCharacterEncoding();
        if (charSetStr == null) {
            charSetStr = "UTF-8";
        }
        this.charSet = Charset.forName(charSetStr);
        return StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)this.charSet);
    }

    public String[] getParameterValues(String name) {
        String[] values = this.parameterMap.get(name);
        if (values != null) {
            int length = values.length;
            String[] escapesValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapesValues[i] = EscapeUtil.clean(values[i]).trim();
            }
            return escapesValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.isJsonRequest()) {
            return super.getInputStream();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody);
        String json = StreamUtils.copyToString((InputStream)byteArrayInputStream, (Charset)StandardCharsets.UTF_8);
        if (!StringUtils.hasText((String)json)) {
            return super.getInputStream();
        }
        json = EscapeUtil.clean(json).trim();
        final byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream bis = new ByteArrayInputStream(jsonBytes);
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public int available() {
                return jsonBytes.length;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return bis.read();
            }
        };
    }

    public boolean isJsonRequest() {
        String header = super.getHeader("Content-Type");
        return StringUtils.startsWithIgnoreCase((String)header, (String)"application/json");
    }
}

