// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles

(function (modules, entry, mainEntry, parcelRequireName, globalName) {
  /* eslint-disable no-undef */
  var globalObject =
    typeof globalThis !== 'undefined'
      ? globalThis
      : typeof self !== 'undefined'
      ? self
      : typeof window !== 'undefined'
      ? window
      : typeof global !== 'undefined'
      ? global
      : {};
  /* eslint-enable no-undef */

  // Save the require from previous bundle to this closure if any
  var previousRequire =
    typeof globalObject[parcelRequireName] === 'function' &&
    globalObject[parcelRequireName];

  var cache = previousRequire.cache || {};
  // Do not use `require` to prevent Webpack from trying to bundle this call
  var nodeRequire =
    typeof module !== 'undefined' &&
    typeof module.require === 'function' &&
    module.require.bind(module);

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire =
          typeof globalObject[parcelRequireName] === 'function' &&
          globalObject[parcelRequireName];
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error("Cannot find module '" + name + "'");
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = (cache[name] = new newRequire.Module(name));

      modules[name][0].call(
        module.exports,
        localRequire,
        module,
        module.exports,
        this
      );
    }

    return cache[name].exports;

    function localRequire(x) {
      var res = localRequire.resolve(x);
      return res === false ? {} : newRequire(res);
    }

    function resolve(x) {
      var id = modules[name][1][x];
      return id != null ? id : x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [
      function (require, module) {
        module.exports = exports;
      },
      {},
    ];
  };

  Object.defineProperty(newRequire, 'root', {
    get: function () {
      return globalObject[parcelRequireName];
    },
  });

  globalObject[parcelRequireName] = newRequire;

  for (var i = 0; i < entry.length; i++) {
    newRequire(entry[i]);
  }

  if (mainEntry) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(mainEntry);

    // CommonJS
    if (typeof exports === 'object' && typeof module !== 'undefined') {
      module.exports = mainExports;

      // RequireJS
    } else if (typeof define === 'function' && define.amd) {
      define(function () {
        return mainExports;
      });

      // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }
})({"gEVO5":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _indexLess = require("bundle-text:./style/index.less");
var _indexLessDefault = parcelHelpers.interopDefault(_indexLess);
var _optionValidator = require("option-validator");
var _optionValidatorDefault = parcelHelpers.interopDefault(_optionValidator);
var _emitter = require("./utils/emitter");
var _emitterDefault = parcelHelpers.interopDefault(_emitter);
var _utils = require("./utils");
var _scheme = require("./scheme");
var _schemeDefault = parcelHelpers.interopDefault(_scheme);
var _config = require("./config");
var _configDefault = parcelHelpers.interopDefault(_config);
var _template = require("./template");
var _templateDefault = parcelHelpers.interopDefault(_template);
var _i18N = require("./i18n");
var _i18NDefault = parcelHelpers.interopDefault(_i18N);
var _player = require("./player");
var _playerDefault = parcelHelpers.interopDefault(_player);
var _control = require("./control");
var _controlDefault = parcelHelpers.interopDefault(_control);
var _contextmenu = require("./contextmenu");
var _contextmenuDefault = parcelHelpers.interopDefault(_contextmenu);
var _info = require("./info");
var _infoDefault = parcelHelpers.interopDefault(_info);
var _subtitle = require("./subtitle");
var _subtitleDefault = parcelHelpers.interopDefault(_subtitle);
var _events = require("./events");
var _eventsDefault = parcelHelpers.interopDefault(_events);
var _hotkey = require("./hotkey");
var _hotkeyDefault = parcelHelpers.interopDefault(_hotkey);
var _layer = require("./layer");
var _layerDefault = parcelHelpers.interopDefault(_layer);
var _loading = require("./loading");
var _loadingDefault = parcelHelpers.interopDefault(_loading);
var _notice = require("./notice");
var _noticeDefault = parcelHelpers.interopDefault(_notice);
var _mask = require("./mask");
var _maskDefault = parcelHelpers.interopDefault(_mask);
var _icons = require("./icons");
var _iconsDefault = parcelHelpers.interopDefault(_icons);
var _setting = require("./setting");
var _settingDefault = parcelHelpers.interopDefault(_setting);
var _storage = require("./storage");
var _storageDefault = parcelHelpers.interopDefault(_storage);
var _plugins = require("./plugins");
var _pluginsDefault = parcelHelpers.interopDefault(_plugins);
let id = 0;
const instances = [];
class Artplayer extends (0, _emitterDefault.default) {
    constructor(option, readyCallback){
        super();
        this.id = ++id;
        const mergeOption = _utils.mergeDeep(Artplayer.option, option);
        if (mergeOption.url && mergeOption.url.endsWith("m3u8")) {
            mergeOption.customType = {
                m3u8: Artplayer.playM3u8,
                m3u8_cut: Artplayer.playM3u8Cut
            }
        }
        Artplayer.PLAYBACK_RATE = mergeOption.playbackRateList;
        mergeOption.container = option.container;
        this.option = (0, _optionValidatorDefault.default)(mergeOption, (0, _schemeDefault.default));
        this.isLock = false;
        this.isReady = false;
        this.isFocus = false;
        this.isInput = false;
        this.isRotate = false;
        this.isDestroy = false;
        this.template = new (0, _templateDefault.default)(this);
        this.events = new (0, _eventsDefault.default)(this);
        this.storage = new (0, _storageDefault.default)(this);
        this.icons = new (0, _iconsDefault.default)(this);
        this.i18n = new (0, _i18NDefault.default)(this);
        this.notice = new (0, _noticeDefault.default)(this);
        this.player = new (0, _playerDefault.default)(this);
        this.layers = new (0, _layerDefault.default)(this);
        this.controls = new (0, _controlDefault.default)(this);
        this.contextmenu = new (0, _contextmenuDefault.default)(this);
        this.subtitle = new (0, _subtitleDefault.default)(this);
        this.info = new (0, _infoDefault.default)(this);
        this.loading = new (0, _loadingDefault.default)(this);
        this.hotkey = new (0, _hotkeyDefault.default)(this);
        this.mask = new (0, _maskDefault.default)(this);
        this.setting = new (0, _settingDefault.default)(this);
        this.plugins = new (0, _pluginsDefault.default)(this);
        if (typeof readyCallback === "function") this.on("ready", ()=>readyCallback.call(this, this));
        if (Artplayer.DEBUG) {
            const log = (msg)=>console.log(`[ART.${this.id}] -> ${msg}`);
            log("Version@" + Artplayer.version);
            log("Env@" + Artplayer.env);
            log("Build@" + Artplayer.build);
            for(let index = 0; index < (0, _configDefault.default).events.length; index++)this.on("video:" + (0, _configDefault.default).events[index], (event)=>log("Event@" + event.type));
        }
        instances.push(this);
    }
    static get instances() {
        return instances;
    }
    static get version() {
        return "5.1.6";
    }
    static get env() {
        return "development";
    }
    static get build() {
        return "2024-06-08 17:29:16";
    }
    static get config() {
        return 0, _configDefault.default;
    }
    static get utils() {
        return _utils;
    }
    static get scheme() {
        return 0, _schemeDefault.default;
    }
    static get Emitter() {
        return 0, _emitterDefault.default;
    }
    static get validator() {
        return 0, _optionValidatorDefault.default;
    }
    static get kindOf() {
        return (0, _optionValidatorDefault.default).kindOf;
    }
    static get html() {
        return (0, _templateDefault.default).html;
    }
    static get option() {
        return {
            id: "",
            container: "#artplayer",
            url: "",
            poster: "",
            type: "",
            theme: "#f00",
            volume: 0.7,
            isLive: false,
            muted: false,
            autoplay: false,
            autoSize: false,
            autoMini: false,
            loop: false,
            flip: false,
            playbackRate: false,
            aspectRatio: false,
            screenshot: false,
            setting: false,
            hotkey: true,
            pip: false,
            mutex: true,
            backdrop: true,
            fullscreen: false,
            fullscreenWeb: false,
            subtitleOffset: false,
            miniProgressBar: false,
            useSSR: false,
            playsInline: true,
            lock: false,
            fastForward: false,
            autoPlayback: false,
            autoOrientation: false,
            airplay: false,
            speed: true,
            layers: [],
            contextmenu: [],
            controls: [],
            settings: [],
            quality: [],
            highlight: [],
            plugins: [],
            thumbnails: {
                url: "",
                number: 60,
                column: 10,
                width: 0,
                height: 0
            },
            subtitle: {
                url: "",
                type: "",
                style: {},
                name: "",
                escape: true,
                encoding: "utf-8",
                onVttLoad: (vtt)=>vtt
            },
            moreVideoAttr: {
                controls: false,
                preload: _utils.isSafari ? "auto" : "metadata"
            },
            i18n: {},
            icons: {},
            cssVar: {},
            customType: {},
            lang: navigator.language.toLowerCase()
        };
    }
    get proxy() {
        return this.events.proxy;
    }
    get query() {
        return this.template.query;
    }
    get video() {
        return this.template.$video;
    }
    destroy(removeHtml = true) {
        this.events.destroy();
        this.template.destroy(removeHtml);
        instances.splice(instances.indexOf(this), 1);
        this.isDestroy = true;
        this.emit("destroy");
    }
}
exports.default = Artplayer;
Artplayer.DEBUG = false;
Artplayer.CONTEXTMENU = true;
Artplayer.NOTICE_TIME = 2000;
Artplayer.SETTING_WIDTH = 250;
Artplayer.SETTING_ITEM_WIDTH = 200;
Artplayer.SETTING_ITEM_HEIGHT = 35;
Artplayer.RESIZE_TIME = 200;
Artplayer.SCROLL_TIME = 200;
Artplayer.SCROLL_GAP = 50;
Artplayer.AUTO_PLAYBACK_MAX = 20;//自动回放功能的最大记录数
Artplayer.AUTO_PLAYBACK_MIN = 5;//自动回放功能的最小记录时长，单位为秒
Artplayer.AUTO_PLAYBACK_TIMEOUT = 3000;
Artplayer.RECONNECT_TIME_MAX = 5;
Artplayer.RECONNECT_SLEEP_TIME = 1000;
Artplayer.CONTROL_HIDE_TIME = 3000;
Artplayer.DBCLICK_TIME = 300;
Artplayer.DBCLICK_FULLSCREEN = true;
Artplayer.MOBILE_DBCLICK_PLAY = true;
Artplayer.MOBILE_CLICK_PLAY = false;
Artplayer.AUTO_ORIENTATION_TIME = 200;
Artplayer.INFO_LOOP_TIME = 1000;
Artplayer.FAST_FORWARD_VALUE = 3;
Artplayer.FAST_FORWARD_TIME = 1000;
Artplayer.TOUCH_MOVE_RATIO = 0.5;
Artplayer.VOLUME_STEP = 0.1;
Artplayer.SEEK_STEP = 5;
Artplayer.PLAYBACK_RATE = [.5, 1, 1.5, 2, 2.5, 3];
Artplayer.ASPECT_RATIO = [
    "default",
    "4:3",
    "16:9"
];
Artplayer.FLIP = [
    "normal",
    "horizontal",
    "vertical"
];
Artplayer.FULLSCREEN_WEB_IN_BODY = false;
Artplayer.LOG_VERSION = true;
Artplayer.USE_RAF = false;

Artplayer.playM3u8 = function playM3u8(video, url, art) {
    if (Hls.isSupported()) {
        if (art.hls) art.hls.destroy();
        const hls = new Hls();
        hls.loadSource(url);
        hls.attachMedia(video);
        art.hls = hls;
        art.on('destroy', () => hls.destroy());
    } else if (video.canPlayType('application/vnd.apple.mpegurl')) {
        video.src = url;
    } else {
        art.notice.show = 'Unsupported playback format: m3u8';
    }
}
Artplayer.playM3u8Cut = function playM3u8Cut(video, url, art) {
    if (Hls.isSupported()) {
        const hlsCut = new Hls();
        hlsCut.loadSource(url);
        hlsCut.attachMedia(video);
        art.hlsCut = hlsCut;
        art.on('destroy', () => hlsCut.destroy());
    } else if (video.canPlayType('application/vnd.apple.mpegurl')) {
        video.src = url;
    } else {
        art.notice.show = 'Unsupported playback format: m3u8';
    }
}
if (_utils.isBrowser) {
    window["Artplayer"] = Artplayer;
    _utils.setStyleText("artplayer-style", (0, _indexLessDefault.default));
    setTimeout(()=>{
        if (Artplayer.LOG_VERSION) console.log(`%c ArtPlayer %c ${Artplayer.version} %c https://artplayer.org`, "color: #fff; background: #5f5f5f", "color: #fff; background: #4bc729", "");
    }, 100);
}

},{"bundle-text:./style/index.less":"doPnH","option-validator":"1vNkK","./utils/emitter":"8uSwy","./utils":"euhMG","./scheme":"jVxq1","./config":"1hSww","./template":"eG0JW","./i18n":"6Q0In","./player":"kmRM5","./control":"nK2ZQ","./contextmenu":"iygWX","./info":"6tuCt","./subtitle":"1kFyE","./events":"akAUN","./hotkey":"f1oWx","./layer":"bKuSu","./loading":"4AfId","./notice":"aKncc","./mask":"1R5LH","./icons":"bPpva","./setting":"i2oRN","./storage":"9ruid","./plugins":"7Fd4c","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"doPnH":[function(require,module,exports) {
module.exports = ".art-video-player {\n  --art-theme: red;\n  --art-font-color: #fff;\n  --art-background-color: #000;\n  --art-text-shadow-color: #00000080;\n  --art-transition-duration: .2s;\n  --art-padding: 10px;\n  --art-border-radius: 3px;\n  --art-progress-height: 6px;\n  --art-progress-color: #ffffff40;\n  --art-hover-color: #ffffff40;\n  --art-loaded-color: #ffffff40;\n  --art-state-size: 80px;\n  --art-state-opacity: .8;\n  --art-bottom-height: 100px;\n  --art-bottom-offset: 20px;\n  --art-bottom-gap: 5px;\n  --art-highlight-width: 8px;\n  --art-highlight-color: #ffffff80;\n  --art-control-height: 46px;\n  --art-control-opacity: .75;\n  --art-control-icon-size: 36px;\n  --art-control-icon-scale: 1.1;\n  --art-volume-height: 120px;\n  --art-volume-handle-size: 14px;\n  --art-lock-size: 36px;\n  --art-indicator-scale: 0;\n  --art-indicator-size: 16px;\n  --art-fullscreen-web-index: 9999;\n  --art-settings-icon-size: 24px;\n  --art-settings-max-height: 300px;\n  --art-selector-max-height: 300px;\n  --art-contextmenus-min-width: 250px;\n  --art-subtitle-font-size: 20px;\n  --art-subtitle-gap: 5px;\n  --art-subtitle-bottom: 15px;\n  --art-subtitle-border: #000;\n  --art-widget-background: #000000d9;\n  --art-tip-background: #000000b3;\n  --art-scrollbar-size: 4px;\n  --art-scrollbar-background: #ffffff40;\n  --art-scrollbar-background-hover: #ffffff80;\n  --art-mini-progress-height: 2px;\n}\n\n.art-bg-cover {\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n}\n\n.art-bottom-gradient {\n  background-image: linear-gradient(to top, #000, #0006, #0000);\n  background-position: bottom;\n  background-repeat: repeat-x;\n}\n\n.art-backdrop-filter {\n  backdrop-filter: saturate(180%) blur(20px);\n  background-color: #000000bf !important;\n}\n\n.art-truncate {\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  overflow: hidden;\n}\n\n.art-video-player {\n  zoom: 1;\n  text-align: left;\n  user-select: none;\n  box-sizing: border-box;\n  color: var(--art-font-color);\n  background-color: var(--art-background-color);\n  text-shadow: 0 0 2px var(--art-text-shadow-color);\n  -webkit-tap-highlight-color: #0000;\n  -ms-touch-action: manipulation;\n  touch-action: manipulation;\n  -ms-high-contrast-adjust: none;\n  direction: ltr;\n  outline: 0;\n  width: 100%;\n  height: 100%;\n  margin: 0 auto;\n  padding: 0;\n  font-family: PingFang SC, Helvetica Neue, Microsoft YaHei, Roboto, Arial, sans-serif;\n  font-size: 14px;\n  line-height: 1.3;\n  position: relative;\n}\n\n.art-video-player *, .art-video-player :before, .art-video-player :after {\n  box-sizing: border-box;\n}\n\n.art-video-player ::-webkit-scrollbar {\n  width: var(--art-scrollbar-size);\n  height: var(--art-scrollbar-size);\n}\n\n.art-video-player ::-webkit-scrollbar-thumb {\n  background-color: var(--art-scrollbar-background);\n}\n\n.art-video-player ::-webkit-scrollbar-thumb:hover {\n  background-color: var(--art-scrollbar-background-hover);\n}\n\n.art-video-player img {\n  vertical-align: top;\n  max-width: 100%;\n}\n\n.art-video-player svg {\n  fill: var(--art-font-color);\n}\n\n.art-video-player a {\n  color: var(--art-font-color);\n  text-decoration: none;\n}\n\n.art-icon {\n  justify-content: center;\n  align-items: center;\n  line-height: 1;\n  display: flex;\n}\n\n.art-video-player.art-backdrop .art-contextmenus, .art-video-player.art-backdrop .art-info, .art-video-player.art-backdrop .art-settings, .art-video-player.art-backdrop .art-layer-auto-playback, .art-video-player.art-backdrop .art-selector-list, .art-video-player.art-backdrop .art-volume-inner {\n  backdrop-filter: saturate(180%) blur(20px);\n  background-color: #000000bf !important;\n}\n\n.art-video {\n  z-index: 10;\n  cursor: pointer;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-poster {\n  z-index: 11;\n  pointer-events: none;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-video-player .art-subtitle {\n  z-index: 20;\n  text-align: center;\n  pointer-events: none;\n  justify-content: center;\n  align-items: center;\n  gap: var(--art-subtitle-gap);\n  bottom: var(--art-subtitle-bottom);\n  font-size: var(--art-subtitle-font-size);\n  transition: bottom var(--art-transition-duration) ease;\n  text-shadow: var(--art-subtitle-border) 1px 0 1px, var(--art-subtitle-border) 0 1px 1px, var(--art-subtitle-border) -1px 0 1px, var(--art-subtitle-border) 0 -1px 1px, var(--art-subtitle-border) 1px 1px 1px, var(--art-subtitle-border) -1px -1px 1px, var(--art-subtitle-border) 1px -1px 1px, var(--art-subtitle-border) -1px 1px 1px;\n  flex-direction: column;\n  width: 100%;\n  padding: 0 5%;\n  display: none;\n  position: absolute;\n}\n\n.art-video-player.art-subtitle-show .art-subtitle {\n  display: flex;\n}\n\n.art-video-player.art-control-show .art-subtitle {\n  bottom: calc(var(--art-control-height)  + var(--art-subtitle-bottom));\n}\n\n.art-danmuku {\n  z-index: 30;\n  pointer-events: none;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n  overflow: hidden;\n}\n\n.art-video-player .art-layers {\n  z-index: 40;\n  pointer-events: none;\n  width: 100%;\n  height: 100%;\n  display: none;\n  position: absolute;\n  inset: 0;\n}\n\n.art-video-player .art-layers .art-layer {\n  pointer-events: auto;\n}\n\n.art-video-player.art-layer-show .art-layers {\n  display: flex;\n}\n\n.art-video-player .art-mask {\n  z-index: 50;\n  pointer-events: none;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  position: absolute;\n  inset: 0;\n}\n\n.art-video-player .art-mask .art-state {\n  opacity: 0;\n  width: var(--art-state-size);\n  height: var(--art-state-size);\n  transition: all var(--art-transition-duration) ease;\n  justify-content: center;\n  align-items: center;\n  display: flex;\n  transform: scale(2);\n}\n\n.art-video-player.art-mask-show .art-state {\n  cursor: pointer;\n  pointer-events: auto;\n  opacity: var(--art-state-opacity);\n  transform: scale(1);\n}\n\n.art-video-player.art-loading-show .art-state {\n  display: none;\n}\n\n.art-video-player .art-loading {\n  z-index: 70;\n  pointer-events: none;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  display: none;\n  position: absolute;\n  inset: 0;\n}\n\n.art-video-player.art-loading-show .art-loading {\n  display: flex;\n}\n\n.art-video-player .art-bottom {\n  z-index: 60;\n  opacity: 0;\n  pointer-events: none;\n  padding: 0 var(--art-padding);\n  transition: all var(--art-transition-duration) ease;\n  background-size: 100% var(--art-bottom-height);\n  background-image: linear-gradient(to top, #000, #0006, #0000);\n  background-position: bottom;\n  background-repeat: repeat-x;\n  flex-direction: column;\n  justify-content: flex-end;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  position: absolute;\n  inset: 0;\n  overflow: hidden;\n}\n\n.art-video-player .art-bottom .art-controls, .art-video-player .art-bottom .art-progress {\n  transform: translateY(var(--art-bottom-offset));\n  transition: transform var(--art-transition-duration) ease;\n}\n\n.art-video-player.art-control-show .art-bottom, .art-video-player.art-hover .art-bottom {\n  opacity: 1;\n}\n\n.art-video-player.art-control-show .art-bottom .art-controls, .art-video-player.art-hover .art-bottom .art-controls, .art-video-player.art-control-show .art-bottom .art-progress, .art-video-player.art-hover .art-bottom .art-progress {\n  transform: translateY(0);\n}\n\n.art-bottom .art-progress {\n  z-index: 0;\n  pointer-events: auto;\n  padding-bottom: var(--art-bottom-gap);\n padding-top: 30px;\n position: relative;\n}\n\n.art-bottom .art-progress .art-control-progress {\n  cursor: pointer;\n  height: var(--art-progress-height);\n  justify-content: center;\n  align-items: center;\n  display: flex;\n  position: relative;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner {\n  transition: height var(--art-transition-duration) ease;\n  background-color: var(--art-progress-color);\n  align-items: center;\n  width: 100%;\n  height: 50%;\n  display: flex;\n  position: relative;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-hover {\n  z-index: 0;\n  background-color: var(--art-hover-color);\n  width: 0%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-loaded {\n  z-index: 10;\n  background-color: var(--art-loaded-color);\n  width: 0%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-played {\n  z-index: 20;\n  background-color: var(--art-theme);\n  width: 0%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-highlight {\n  z-index: 30;\n  pointer-events: none;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-highlight span {\n  z-index: 0;\n  pointer-events: auto;\n  transform: translateX(calc(var(--art-highlight-width) / -2));\n  background-color: var(--art-highlight-color);\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0 auto 0 0;\n  width: var(--art-highlight-width) !important;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-indicator {\n  z-index: 40;\n  width: var(--art-indicator-size);\n  height: var(--art-indicator-size);\n  transform: scale(var(--art-indicator-scale));\n  margin-left: calc(var(--art-indicator-size) / -2);\n  transition: transform var(--art-transition-duration) ease;\n  border-radius: 50%;\n  justify-content: center;\n  align-items: center;\n  display: flex;\n  position: absolute;\n  left: 0;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-indicator .art-icon {\n  pointer-events: none;\n  width: 100%;\n  height: 100%;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-indicator:hover {\n  transform: scale(1.2) !important;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-indicator:active {\n  transform: scale(1) !important;\n}\n\n.art-bottom .art-progress .art-control-progress .art-control-progress-inner .art-progress-tip {\n  z-index: 50;\n  border-radius: var(--art-border-radius);\n  white-space: nowrap;\n  background-color: var(--art-tip-background);\n  padding: 3px 5px;\n  font-size: 12px;\n  line-height: 1;\n  display: none;\n  position: absolute;\n  top: -25px;\n  left: 0;\n}\n\n.art-bottom .art-progress .art-control-progress:hover .art-control-progress-inner {\n  height: 100%;\n}\n\n.art-bottom .art-progress .art-control-thumbnails {\n  bottom: calc(var(--art-bottom-gap)  + 10px);\n  border-radius: var(--art-border-radius);\n  background-position: center;\nbackground-size: cover;\npointer-events: none;\n  background-color: var(--art-widget-background);\n  display: none;\n  position: absolute;\n  left: 0;\n  box-shadow: 0 1px 3px #0003, 0 1px 2px -1px #0003;\n}\n\n.art-bottom:hover .art-progress .art-control-progress .art-control-progress-inner .art-progress-indicator {\n  transform: scale(1);\n}\n\n.art-controls {\n  z-index: 10;\n  pointer-events: auto;\n  height: var(--art-control-height);\n  justify-content: space-between;\n  align-items: center;\n  display: flex;\n  position: relative;\n}\n\n.art-controls .art-controls-left, .art-controls .art-controls-right {\n  height: 100%;\n  display: flex;\n}\n\n.art-controls .art-controls-center {\n  flex: 1;\n  justify-content: center;\n  align-items: center;\n  height: 100%;\n  padding: 0 10px;\n  display: none;\n}\n\n.art-controls .art-controls-right {\n  justify-content: flex-end;\n}\n\n.art-controls .art-control {\n  cursor: pointer;\n  white-space: nowrap;\n  opacity: var(--art-control-opacity);\n  min-height: var(--art-control-height);\n  min-width: var(--art-control-height);\n  transition: opacity var(--art-transition-duration) ease;\n  flex-shrink: 0;\n  justify-content: center;\n  align-items: center;\n  display: flex;\n}\n\n.art-controls .art-control .art-icon {\n  height: var(--art-control-icon-size);\n  width: var(--art-control-icon-size);\n  transform: scale(var(--art-control-icon-scale));\n  transition: transform var(--art-transition-duration) ease;\n}\n\n.art-controls .art-control .art-icon:active {\n  transform: scale(calc(var(--art-control-icon-scale) * .8));\n}\n\n.art-controls .art-control:hover {\n  opacity: 1;\n}\n\n.art-control-volume {\n  position: relative;\n}\n\n.art-control-volume .art-volume-panel {\n  text-align: center;\n  cursor: default;\n  opacity: 0;\n  pointer-events: none;\n  left: 0;\n  right: 0;\n  bottom: var(--art-control-height);\n  width: var(--art-control-height);\n  height: var(--art-volume-height);\n  transition: all var(--art-transition-duration) ease;\n  justify-content: center;\n  align-items: center;\n  padding: 0 5px;\n  font-size: 12px;\n  display: flex;\n  position: absolute;\n  transform: translateY(10px);\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner {\n  border-radius: var(--art-border-radius);\n  background-color: var(--art-widget-background);\n  flex-direction: column;\n  align-items: center;\n  gap: 10px;\n  width: 100%;\n  height: 100%;\n  padding: 10px 0 12px;\n  display: flex;\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner .art-volume-slider {\n  cursor: pointer;\n  flex: 1;\n  justify-content: center;\n  width: 100%;\n  display: flex;\n  position: relative;\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner .art-volume-slider .art-volume-handle {\n  border-radius: var(--art-border-radius);\n  background-color: #ffffff40;\n  justify-content: center;\n  width: 2px;\n  display: flex;\n  position: relative;\n  overflow: hidden;\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner .art-volume-slider .art-volume-handle .art-volume-loaded {\n  z-index: 0;\n  background-color: var(--art-theme);\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  inset: 0;\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner .art-volume-slider .art-volume-indicator {\n  width: var(--art-volume-handle-size);\n  height: var(--art-volume-handle-size);\n  margin-top: calc(var(--art-volume-handle-size) / -2);\n  background-color: var(--art-theme);\n  transition: transform var(--art-transition-duration) ease;\n  border-radius: 100%;\n  flex-shrink: 0;\n  position: absolute;\n  transform: scale(1);\n}\n\n.art-control-volume .art-volume-panel .art-volume-inner .art-volume-slider:active .art-volume-indicator {\n  transform: scale(.9);\n}\n\n.art-control-volume:hover .art-volume-panel {\n  opacity: 1;\n  pointer-events: auto;\n  transform: translateY(0);\n}\n\n.art-video-player .art-notice {\n  z-index: 80;\n  padding: var(--art-padding);\n  pointer-events: none;\n  width: 100%;\n  height: auto;\n  display: none;\n  position: absolute;\n  inset: 0 0 auto;\n}\n\n.art-video-player .art-notice .art-notice-inner {\n  border-radius: var(--art-border-radius);\n  background-color: var(--art-tip-background);\n  padding: 5px;\n  line-height: 1;\n  display: inline-flex;\n}\n\n.art-video-player.art-notice-show .art-notice {\n  display: flex;\n}\n\n.art-video-player .art-contextmenus {\n  z-index: 120;\n  border-radius: var(--art-border-radius);\n  background-color: var(--art-widget-background);\n  min-width: var(--art-contextmenus-min-width);\n  flex-direction: column;\n  padding: 5px 0;\n  font-size: 12px;\n  display: none;\n  position: absolute;\n}\n\n.art-video-player .art-contextmenus .art-contextmenu {\n  cursor: pointer;\n  border-bottom: 1px solid #ffffff1a;\n  padding: 10px 15px;\n  display: flex;\n}\n\n.art-video-player .art-contextmenus .art-contextmenu span {\n  padding: 0 8px;\n}\n\n.art-video-player .art-contextmenus .art-contextmenu span:hover, .art-video-player .art-contextmenus .art-contextmenu span.art-current {\n  color: var(--art-theme);\n}\n\n.art-video-player .art-contextmenus .art-contextmenu:hover {\n  background-color: #ffffff1a;\n}\n\n.art-video-player .art-contextmenus .art-contextmenu:last-child {\n  border-bottom: none;\n}\n\n.art-video-player.art-contextmenu-show .art-contextmenus {\n  display: flex;\n}\n\n.art-video-player .art-settings {\n  z-index: 90;\n  border-radius: var(--art-border-radius);\n  transform-origin: 100% 100%;\n  max-height: var(--art-settings-max-height);\n  left: auto;\n  right: var(--art-padding);\n  bottom: var(--art-control-height);\n  transform: scale(var(--art-settings-scale));\n  transition: all var(--art-transition-duration) ease;\n  background-color: var(--art-widget-background);\n  flex-direction: column;\n  display: none;\n  position: absolute;\n  overflow: hidden auto;\n}\n\n.art-video-player .art-settings .art-setting-panel {\n  flex-direction: column;\n  display: none;\n}\n\n.art-video-player .art-settings .art-setting-panel.art-current {\n  display: flex;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item {\n  cursor: pointer;\n  transition: background-color var(--art-transition-duration) ease;\n  justify-content: space-between;\n  align-items: center;\n  padding: 0 5px;\n  display: flex;\n  overflow: hidden;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item:hover {\n  background-color: #ffffff1a;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item.art-current {\n  color: var(--art-theme);\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-icon-check {\n  visibility: hidden;\n  height: 15px;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item.art-current .art-icon-check {\n  visibility: visible;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-left {\n  justify-content: center;\n  align-items: center;\n  gap: 5px;\n  display: flex;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-left .art-setting-item-left-icon {\n  height: var(--art-settings-icon-size);\n  width: var(--art-settings-icon-size);\n  justify-content: center;\n  align-items: center;\n  display: flex;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-right {\n  justify-content: center;\n  align-items: center;\n  gap: 5px;\n  font-size: 12px;\n  display: flex;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-right .art-setting-item-right-tooltip {\n  white-space: nowrap;\n  color: #ffffff80;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-right .art-setting-item-right-icon {\n  justify-content: center;\n  align-items: center;\n  min-width: 32px;\n  height: 24px;\n  display: flex;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item .art-setting-item-right .art-setting-range {\n  appearance: none;\n  background-color: #fff3;\n  outline: none;\n  width: 80px;\n  height: 3px;\n}\n\n.art-video-player .art-settings .art-setting-panel .art-setting-item-back {\n  border-bottom: 1px solid #ffffff1a;\n}\n\n.art-video-player.art-setting-show .art-settings {\n  display: flex;\n}\n\n.art-video-player .art-info {\n  left: var(--art-padding);\n  top: var(--art-padding);\n  z-index: 100;\n  border-radius: var(--art-border-radius);\n  background-color: var(--art-widget-background);\n  padding: 10px;\n  font-size: 12px;\n  display: none;\n  position: absolute;\n}\n\n.art-video-player .art-info .art-info-panel {\n  flex-direction: column;\n  gap: 5px;\n  display: flex;\n}\n\n.art-video-player .art-info .art-info-panel .art-info-item {\n  align-items: center;\n  gap: 5px;\n  display: flex;\n}\n\n.art-video-player .art-info .art-info-panel .art-info-item .art-info-title {\n  text-align: right;\n  width: 100px;\n}\n\n.art-video-player .art-info .art-info-panel .art-info-item .art-info-content {\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  user-select: all;\n  width: 250px;\n  overflow: hidden;\n}\n\n.art-video-player .art-info .art-info-close {\n  cursor: pointer;\n  position: absolute;\n  top: 5px;\n  right: 5px;\n}\n\n.art-video-player.art-info-show .art-info {\n  display: flex;\n}\n\n.art-hide-cursor * {\n  cursor: none !important;\n}\n\n.art-video-player[data-aspect-ratio] {\n  overflow: hidden;\n}\n\n.art-video-player[data-aspect-ratio] .art-video {\n  object-fit: fill;\n  box-sizing: content-box;\n}\n\n.art-fullscreen {\n  --art-progress-height: 8px;\n  --art-indicator-size: 20px;\n  --art-control-height: 60px;\n  --art-control-icon-scale: 1.3;\n}\n\n.art-fullscreen-web {\n  --art-progress-height: 8px;\n  --art-indicator-size: 20px;\n  --art-control-height: 60px;\n  --art-control-icon-scale: 1.3;\n  z-index: var(--art-fullscreen-web-index);\n  width: 100%;\n  height: 100%;\n  position: fixed;\n  inset: 0;\n}\n\n.art-mini-popup {\n  z-index: 9999;\n  border-radius: var(--art-border-radius);\n  cursor: move;\n  user-select: none;\n  background: #000;\n  width: 320px;\n  height: 180px;\n  transition: opacity .2s;\n  position: fixed;\n  overflow: hidden;\n  box-shadow: 0 0 5px #00000080;\n}\n\n.art-mini-popup svg {\n  fill: #fff;\n}\n\n.art-mini-popup .art-video {\n  pointer-events: none;\n}\n\n.art-mini-popup .art-mini-close {\n  z-index: 20;\n  cursor: pointer;\n  opacity: 0;\n  transition: opacity .2s;\n  position: absolute;\n  top: 10px;\n  right: 10px;\n}\n\n.art-mini-popup .art-mini-state {\n  z-index: 30;\n  pointer-events: none;\n  opacity: 0;\n  background-color: #00000040;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  transition: opacity .2s;\n  display: flex;\n  position: absolute;\n  inset: 0;\n}\n\n.art-mini-popup .art-mini-state .art-icon {\n  opacity: .75;\n  cursor: pointer;\n  pointer-events: auto;\n  transition: transform .2s;\n  transform: scale(3);\n}\n\n.art-mini-popup .art-mini-state .art-icon:active {\n  transform: scale(2.5);\n}\n\n.art-mini-popup.art-mini-droging {\n  opacity: .9;\n}\n\n.art-mini-popup:hover .art-mini-close, .art-mini-popup:hover .art-mini-state {\n  opacity: 1;\n}\n\n.art-video-player[data-flip=\"horizontal\"] .art-video {\n  transform: scaleX(-1);\n}\n\n.art-video-player[data-flip=\"vertical\"] .art-video {\n  transform: scaleY(-1);\n}\n\n.art-video-player .art-layer-lock {\n  height: var(--art-lock-size);\n  width: var(--art-lock-size);\n  top: 50%;\n  left: var(--art-padding);\n  background-color: var(--art-tip-background);\n  border-radius: 50%;\n  justify-content: center;\n  align-items: center;\n  display: none;\n  position: absolute;\n  transform: translateY(-50%);\n}\n\n.art-video-player .art-layer-auto-playback {\n  border-radius: var(--art-border-radius);\n  left: var(--art-padding);\n  bottom: calc(var(--art-control-height)  + var(--art-bottom-gap)  + 10px);\n  background-color: var(--art-widget-background);\n  align-items: center;\n  gap: 10px;\n  padding: 10px;\n  line-height: 1;\n  display: none;\n  position: absolute;\n}\n\n.art-video-player .art-layer-auto-playback .art-auto-playback-close {\n  cursor: pointer;\n  justify-content: center;\n  align-items: center;\n  display: flex;\n}\n\n.art-video-player .art-layer-auto-playback .art-auto-playback-close svg {\n  fill: var(--art-theme);\n  width: 15px;\n  height: 15px;\n}\n\n.art-video-player .art-layer-auto-playback .art-auto-playback-jump {\n  color: var(--art-theme);\n  cursor: pointer;\n}\n\n.art-video-player.art-lock .art-subtitle {\n  bottom: var(--art-subtitle-bottom) !important;\n}\n\n.art-video-player.art-mini-progress-bar .art-bottom, .art-video-player.art-lock .art-bottom {\n  opacity: 1;\n  background-image: none;\n  padding: 0;\n}\n\n.art-video-player.art-mini-progress-bar .art-bottom .art-controls, .art-video-player.art-lock .art-bottom .art-controls, .art-video-player.art-mini-progress-bar .art-bottom .art-progress, .art-video-player.art-lock .art-bottom .art-progress {\n  transform: translateY(calc(var(--art-control-height)  + var(--art-bottom-gap)  + var(--art-progress-height) / 4));\n}\n\n.art-video-player.art-mini-progress-bar .art-bottom .art-progress-indicator, .art-video-player.art-lock .art-bottom .art-progress-indicator {\n  display: none !important;\n}\n\n.art-video-player.art-control-show .art-layer-lock {\n  display: flex;\n}\n\n.art-control-selector {\n  position: relative;\n}\n\n.art-control-selector .art-selector-list {\n  text-align: center;\n  border-radius: var(--art-border-radius);\n  opacity: 0;\n  pointer-events: none;\n  bottom: var(--art-control-height);\n  max-height: var(--art-selector-max-height);\n  background-color: var(--art-widget-background);\n  transition: all var(--art-transition-duration) ease;\n  flex-direction: column;\n  align-items: center;\n  display: flex;\n  position: absolute;\n  overflow: hidden auto;\n  transform: translateY(10px);\n}\n\n.art-control-selector .art-selector-list .art-selector-item {\n  flex-shrink: 0;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  padding: 10px 15px;\n  line-height: 1;\n  display: flex;\n}\n\n.art-control-selector .art-selector-list .art-selector-item:hover {\n  background-color: #ffffff1a;\n}\n\n.art-control-selector .art-selector-list .art-selector-item:hover, .art-control-selector .art-selector-list .art-selector-item.art-current {\n  color: var(--art-theme);\n}\n\n.art-control-selector:hover .art-selector-list {\n  opacity: 1;\n  pointer-events: auto;\n  transform: translateY(0);\n}\n\n[class*=\"hint--\"] {\n  font-style: normal;\n  display: inline-block;\n  position: relative;\n}\n\n[class*=\"hint--\"]:before, [class*=\"hint--\"]:after {\n  visibility: hidden;\n  opacity: 0;\n  z-index: 1000000;\n  pointer-events: none;\n  transition: all .3s;\n  position: absolute;\n  transform: translate3d(0, 0, 0);\n}\n\n[class*=\"hint--\"]:hover:before, [class*=\"hint--\"]:hover:after {\n  visibility: visible;\n  opacity: 1;\n  transition-delay: .1s;\n}\n\n[class*=\"hint--\"]:before {\n  content: \"\";\n  z-index: 1000001;\n  background: none;\n  border: 6px solid #0000;\n  position: absolute;\n}\n\n[class*=\"hint--\"]:after {\n  color: #fff;\n  white-space: nowrap;\n  background: #000;\n  padding: 8px 10px;\n  font-family: Helvetica Neue, Helvetica, Arial, sans-serif;\n  font-size: 12px;\n  line-height: 12px;\n}\n\n[class*=\"hint--\"][aria-label]:after {\n  content: attr(aria-label);\n}\n\n[class*=\"hint--\"][data-hint]:after {\n  content: attr(data-hint);\n}\n\n[aria-label=\"\"]:before, [aria-label=\"\"]:after, [data-hint=\"\"]:before, [data-hint=\"\"]:after {\n  display: none !important;\n}\n\n.hint--top-left:before, .hint--top-right:before, .hint--top:before {\n  border-top-color: #000;\n}\n\n.hint--bottom-left:before, .hint--bottom-right:before, .hint--bottom:before {\n  border-bottom-color: #000;\n}\n\n.hint--left:before {\n  border-left-color: #000;\n}\n\n.hint--right:before {\n  border-right-color: #000;\n}\n\n.hint--top:before {\n  margin-bottom: -11px;\n}\n\n.hint--top:before, .hint--top:after {\n  bottom: 100%;\n  left: 50%;\n}\n\n.hint--top:before {\n  left: calc(50% - 6px);\n}\n\n.hint--top:after {\n  transform: translateX(-50%);\n}\n\n.hint--top:hover:before {\n  transform: translateY(-8px);\n}\n\n.hint--top:hover:after {\n  transform: translateX(-50%)translateY(-8px);\n}\n\n.hint--bottom:before {\n  margin-top: -11px;\n}\n\n.hint--bottom:before, .hint--bottom:after {\n  top: 100%;\n  left: 50%;\n}\n\n.hint--bottom:before {\n  left: calc(50% - 6px);\n}\n\n.hint--bottom:after {\n  transform: translateX(-50%);\n}\n\n.hint--bottom:hover:before {\n  transform: translateY(8px);\n}\n\n.hint--bottom:hover:after {\n  transform: translateX(-50%)translateY(8px);\n}\n\n.hint--right:before {\n  margin-bottom: -6px;\n  margin-left: -11px;\n}\n\n.hint--right:after {\n  margin-bottom: -14px;\n}\n\n.hint--right:before, .hint--right:after {\n  bottom: 50%;\n  left: 100%;\n}\n\n.hint--right:hover:before, .hint--right:hover:after {\n  transform: translateX(8px);\n}\n\n.hint--left:before {\n  margin-bottom: -6px;\n  margin-right: -11px;\n}\n\n.hint--left:after {\n  margin-bottom: -14px;\n}\n\n.hint--left:before, .hint--left:after {\n  bottom: 50%;\n  right: 100%;\n}\n\n.hint--left:hover:before, .hint--left:hover:after {\n  transform: translateX(-8px);\n}\n\n.hint--top-left:before {\n  margin-bottom: -11px;\n}\n\n.hint--top-left:before, .hint--top-left:after {\n  bottom: 100%;\n  left: 50%;\n}\n\n.hint--top-left:before {\n  left: calc(50% - 6px);\n}\n\n.hint--top-left:after {\n  margin-left: 12px;\n  transform: translateX(-100%);\n}\n\n.hint--top-left:hover:before {\n  transform: translateY(-8px);\n}\n\n.hint--top-left:hover:after {\n  transform: translateX(-100%)translateY(-8px);\n}\n\n.hint--top-right:before {\n  margin-bottom: -11px;\n}\n\n.hint--top-right:before, .hint--top-right:after {\n  bottom: 100%;\n  left: 50%;\n}\n\n.hint--top-right:before {\n  left: calc(50% - 6px);\n}\n\n.hint--top-right:after {\n  margin-left: -12px;\n  transform: translateX(0);\n}\n\n.hint--top-right:hover:before, .hint--top-right:hover:after {\n  transform: translateY(-8px);\n}\n\n.hint--bottom-left:before {\n  margin-top: -11px;\n}\n\n.hint--bottom-left:before, .hint--bottom-left:after {\n  top: 100%;\n  left: 50%;\n}\n\n.hint--bottom-left:before {\n  left: calc(50% - 6px);\n}\n\n.hint--bottom-left:after {\n  margin-left: 12px;\n  transform: translateX(-100%);\n}\n\n.hint--bottom-left:hover:before {\n  transform: translateY(8px);\n}\n\n.hint--bottom-left:hover:after {\n  transform: translateX(-100%)translateY(8px);\n}\n\n.hint--bottom-right:before {\n  margin-top: -11px;\n}\n\n.hint--bottom-right:before, .hint--bottom-right:after {\n  top: 100%;\n  left: 50%;\n}\n\n.hint--bottom-right:before {\n  left: calc(50% - 6px);\n}\n\n.hint--bottom-right:after {\n  margin-left: -12px;\n  transform: translateX(0);\n}\n\n.hint--bottom-right:hover:before, .hint--bottom-right:hover:after {\n  transform: translateY(8px);\n}\n\n.hint--small:after, .hint--medium:after, .hint--large:after {\n  white-space: normal;\n  word-wrap: break-word;\n  line-height: 1.4em;\n}\n\n.hint--small:after {\n  width: 80px;\n}\n\n.hint--medium:after {\n  width: 150px;\n}\n\n.hint--large:after {\n  width: 300px;\n}\n\n[class*=\"hint--\"]:after {\n  text-shadow: 0 -1px #000;\n  box-shadow: 4px 4px 8px #0000004d;\n}\n\n.hint--error:after {\n  text-shadow: 0 -1px #592726;\n  background-color: #b34e4d;\n}\n\n.hint--error.hint--top-left:before, .hint--error.hint--top-right:before, .hint--error.hint--top:before {\n  border-top-color: #b34e4d;\n}\n\n.hint--error.hint--bottom-left:before, .hint--error.hint--bottom-right:before, .hint--error.hint--bottom:before {\n  border-bottom-color: #b34e4d;\n}\n\n.hint--error.hint--left:before {\n  border-left-color: #b34e4d;\n}\n\n.hint--error.hint--right:before {\n  border-right-color: #b34e4d;\n}\n\n.hint--warning:after {\n  text-shadow: 0 -1px #6c5328;\n  background-color: #c09854;\n}\n\n.hint--warning.hint--top-left:before, .hint--warning.hint--top-right:before, .hint--warning.hint--top:before {\n  border-top-color: #c09854;\n}\n\n.hint--warning.hint--bottom-left:before, .hint--warning.hint--bottom-right:before, .hint--warning.hint--bottom:before {\n  border-bottom-color: #c09854;\n}\n\n.hint--warning.hint--left:before {\n  border-left-color: #c09854;\n}\n\n.hint--warning.hint--right:before {\n  border-right-color: #c09854;\n}\n\n.hint--info:after {\n  text-shadow: 0 -1px #1a3c4d;\n  background-color: #3986ac;\n}\n\n.hint--info.hint--top-left:before, .hint--info.hint--top-right:before, .hint--info.hint--top:before {\n  border-top-color: #3986ac;\n}\n\n.hint--info.hint--bottom-left:before, .hint--info.hint--bottom-right:before, .hint--info.hint--bottom:before {\n  border-bottom-color: #3986ac;\n}\n\n.hint--info.hint--left:before {\n  border-left-color: #3986ac;\n}\n\n.hint--info.hint--right:before {\n  border-right-color: #3986ac;\n}\n\n.hint--success:after {\n  text-shadow: 0 -1px #1a321a;\n  background-color: #458746;\n}\n\n.hint--success.hint--top-left:before, .hint--success.hint--top-right:before, .hint--success.hint--top:before {\n  border-top-color: #458746;\n}\n\n.hint--success.hint--bottom-left:before, .hint--success.hint--bottom-right:before, .hint--success.hint--bottom:before {\n  border-bottom-color: #458746;\n}\n\n.hint--success.hint--left:before {\n  border-left-color: #458746;\n}\n\n.hint--success.hint--right:before {\n  border-right-color: #458746;\n}\n\n.hint--always:after, .hint--always:before {\n  opacity: 1;\n  visibility: visible;\n}\n\n.hint--always.hint--top:before {\n  transform: translateY(-8px);\n}\n\n.hint--always.hint--top:after {\n  transform: translateX(-50%)translateY(-8px);\n}\n\n.hint--always.hint--top-left:before {\n  transform: translateY(-8px);\n}\n\n.hint--always.hint--top-left:after {\n  transform: translateX(-100%)translateY(-8px);\n}\n\n.hint--always.hint--top-right:before, .hint--always.hint--top-right:after {\n  transform: translateY(-8px);\n}\n\n.hint--always.hint--bottom:before {\n  transform: translateY(8px);\n}\n\n.hint--always.hint--bottom:after {\n  transform: translateX(-50%)translateY(8px);\n}\n\n.hint--always.hint--bottom-left:before {\n  transform: translateY(8px);\n}\n\n.hint--always.hint--bottom-left:after {\n  transform: translateX(-100%)translateY(8px);\n}\n\n.hint--always.hint--bottom-right:before, .hint--always.hint--bottom-right:after {\n  transform: translateY(8px);\n}\n\n.hint--always.hint--left:before, .hint--always.hint--left:after {\n  transform: translateX(-8px);\n}\n\n.hint--always.hint--right:before, .hint--always.hint--right:after {\n  transform: translateX(8px);\n}\n\n.hint--rounded:after {\n  border-radius: 4px;\n}\n\n.hint--no-animate:before, .hint--no-animate:after {\n  transition-duration: 0s;\n}\n\n.hint--bounce:before, .hint--bounce:after {\n  -webkit-transition: opacity .3s, visibility .3s, -webkit-transform .3s cubic-bezier(.71, 1.7, .77, 1.24);\n  -moz-transition: opacity .3s, visibility .3s, -moz-transform .3s cubic-bezier(.71, 1.7, .77, 1.24);\n  transition: opacity .3s, visibility .3s, transform .3s cubic-bezier(.71, 1.7, .77, 1.24);\n}\n\n.hint--no-shadow:before, .hint--no-shadow:after {\n  text-shadow: initial;\n  box-shadow: initial;\n}\n\n.hint--no-arrow:before {\n  display: none;\n}\n\n.art-video-player.art-mobile {\n  --art-bottom-gap: 10px;\n  --art-control-height: 38px;\n  --art-control-icon-scale: 1;\n  --art-state-size: 60px;\n  --art-settings-max-height: 180px;\n  --art-selector-max-height: 180px;\n  --art-indicator-scale: 1;\n  --art-control-opacity: 1;\n}\n\n.art-video-player.art-mobile .art-controls-left {\n  margin-left: calc(var(--art-padding) / -1);\n}\n\n.art-video-player.art-mobile .art-controls-right {\n  margin-right: calc(var(--art-padding) / -1);\n}\n"
+   "        .video-title {\n" +
    "            overflow: hidden;\n" +
    "            position: absolute;\n" +
    "            text-overflow: ellipsis;\n" +
    "            top: 30px;\n" +
    "            left: 30px;\n" +
    "            font-size: xx-large;\n" +
    "        }" +
    "        .notice-speed .speed-icon {\n" +
    "            width: 30px;\n" +
    "            display: flex;\n" +
    "            align-items: center;\n" +
    "            fill: #fff;\n" +
    "            margin-right: 5px;\n" +
    "        }\n" +
    "        .notice-speed {\n" +
    "            position: absolute;\n" +
    "            top: 10%;\n" +
    "            left: 50%;\n" +
    "            transform: translate(-50%) translateY(-50%);\n" +
    "            display: flex;\n" +
    "            flex-direction: row;\n" +
    "            align-items: center;\n" +
    "            color: #fff;\n" +
    "            background: rgba(0, 0, 0, .6509803922);\n" +
    "            border-radius: 5px;\n" +
    "            padding: 5px 10px;\n" +
    "            transition: opacity .2s;\n" +
    "            font-size: 13px;\n" +
    "        }" +
    "" +
    "" +
    "        .yxq-listbox {\n" +
    "            -webkit-transform: scale(1);\n" +
    "            transform: scale(0);\n" +
    "            transition: all 0.3s ease-in-out;\n" +
    "            position: fixed;\n" +
    "            right: 0;\n" +
    "            top: 0;\n" +
    "            z-index: 10001;\n" +
    "            float: right;\n" +
    "            height: 100%;\n" +
    "            margin-left: -336px;\n" +
    "            width: 336px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .anthology-wrap {\n" +
    "            height: 100%;\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .normal-title-wrap {\n" +
    "            padding: 15px 20px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .thesis-wrap {\n" +
    "            width: 100%;\n" +
    "            height: 26px;\n" +
    "            line-height: 26px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .title-link {\n" +
    "            display: block;\n" +
    "            float: left;\n" +
    "            width: 180px;\n" +
    "            font-size: 16px;\n" +
    "            color: hsla(0,0%,100%,0.87)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .title-info {\n" +
    "            max-height: 64px;\n" +
    "            width: 100%;\n" +
    "            font-size: 12px;\n" +
    "            line-height: 17px;\n" +
    "            overflow: auto;\n" +
    "            margin-top: 10px;\n" +
    "            text-align: left;\n" +
    "            color: hsla(0,0%,100%,0.6)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .scroll-area {\n" +
    "            padding: 0 20px;\n" +
    "            font-size: 14px;\n" +
    "            text-align: left;\n" +
    "            height: calc(100% - 272px);\n" +
    "            overflow: auto;\n" +
    "            position: relative;\n" +
    "            scrollbar-track-color:#1f1f1f;scrollbar-arrow-color:#1f1f1f;scrollbar-base-color:#1f1f1f;scrollbar-face-color:#979797;scrollbar-3dlight-color: #979797;\n" +
    "            scrollbar-highlight-color:#979797;scrollbar-shadow-color:#979797}\n" +
    "\n" +
    "        .yxq-listbox .anthology-content {\n" +
    "            margin-top: 15px;\n" +
    "            width: 100%;\n" +
    "            font-size: 0\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .box-item {\n" +
    "            font-size: 14px;\n" +
    "            background: #45504fc7;\n" +
    "            width: 48%;\n" +
    "            height: 40px;\n" +
    "            line-height: 40px;\n" +
    "            border-radius: 4px;\n" +
    "            text-align: center;\n" +
    "            color: #fff;\n" +
    "            display: inline-block;\n" +
    "            box-sizing: border-box;\n" +
    "            margin: 1%;\n" +
    "            padding: 0 10px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .box-item-line {\n" +
    "            font-size: 14px;\n" +
    "            background: #45504fc7;\n" +
    "            width: 96%;\n" +
    "            height: 40px;\n" +
    "            line-height: 40px;\n" +
    "            border-radius: 4px;\n" +
    "            text-align: center;\n" +
    "            color: #fff;\n" +
    "            display: inline-block;\n" +
    "            box-sizing: border-box;\n" +
    "            margin: 1%;\n" +
    "            white-space: nowrap;\n" +
    "            overflow: hidden;\n" +
    "            text-overflow: ellipsis;\n" +
    "            padding: 0 10px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .box-item-localfile {\n" +
    "            font-size: 14px;\n" +
    "            background: #45504fc7;\n" +
    "            width: 96%;\n" +
    "            height: 40px;\n" +
    "            line-height: 40px;\n" +
    "            border-radius: 4px;\n" +
    "            text-align: center;\n" +
    "            color: #fff;\n" +
    "            display: inline-block;\n" +
    "            box-sizing: border-box;\n" +
    "            margin: 1%;\n" +
    "            white-space: nowrap;\n" +
    "            overflow: hidden;\n" +
    "            text-overflow: ellipsis;\n" +
    "            padding: 0 10px\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .yxq-from-select {\n" +
    "            z-index: 1;\n" +
    "            position: absolute;\n" +
    "            top: 12px;\n" +
    "            right: 10%\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .yxq-from-select a {\n" +
    "            color: hsla(0,0%,100%,0.6)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .yxq-from-select .yxq-list a {\n" +
    "            display: block;\n" +
    "            height: 36px;\n" +
    "            line-height: 36px;\n" +
    "            white-space: nowrap;\n" +
    "            text-align: center\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .yxq-from-select .yxq-list {\n" +
    "            display: none;\n" +
    "            position: absolute;\n" +
    "            background: #25252b;\n" +
    "            border-radius: 4px;\n" +
    "            padding: 10px 15px;\n" +
    "            right: 0;\n" +
    "            top: 18px;\n" +
    "            text-align: center;\n" +
    "            box-shadow: 0 2px 10px 0 rgb(0 0 0 / 30%)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .component-title {\n" +
    "            position: relative;\n" +
    "            height: 20px;\n" +
    "            line-height: 20px;\n" +
    "            display: block;\n" +
    "            margin: 12px 0 16px;\n" +
    "            text-align: left;\n" +
    "            color: hsla(0,0%,100%,0.6)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .pic-text-item a {\n" +
    "            position: relative;\n" +
    "            display: block;\n" +
    "            margin-bottom: 12px;\n" +
    "            overflow: hidden;\n" +
    "            height: 166px;\n" +
    "            color: hsla(0,0%,100%,0.6)\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .cover {\n" +
    "            position: relative;\n" +
    "            float: left;\n" +
    "            margin-right: 10px;\n" +
    "            font-size: 12px;\n" +
    "            height: 100%;\n" +
    "            overflow: hidden\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .anthology-title-wrap {\n" +
    "            position: absolute;\n" +
    "            top: 50%;\n" +
    "            -webkit-transform: translateY(-50%);\n" +
    "            -ms-transform: translateY(-50%);\n" +
    "            transform: translateY(-50%);\n" +
    "            left: 130px;\n" +
    "            width: 168px;\n" +
    "            overflow: hidden\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .anthology-title-wrap .title {\n" +
    "            margin-left: auto;\n" +
    "            margin-right: auto;\n" +
    "            margin-bottom: 18px;\n" +
    "            font-size: 17px;\n" +
    "            line-height: 20px;\n" +
    "            max-height: 58px;\n" +
    "            overflow: hidden;\n" +
    "            -o-text-overflow: ellipsis;\n" +
    "            text-overflow: ellipsis;\n" +
    "            word-break: break-all;\n" +
    "            display: -webkit-box;\n" +
    "            -webkit-box-orient: vertical;\n" +
    "            color: hsla(0,0%,100%,0.87);\n" +
    "            text-align: left\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .anthology-title-wrap .subtitle {\n" +
    "            overflow: auto;\n" +
    "            max-height: 66px;\n" +
    "            font-size: 14px;\n" +
    "            bottom: 0;\n" +
    "            width: 168px;\n" +
    "            line-height: 17px;\n" +
    "            margin-bottom: 3px;\n" +
    "            text-align: left\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .bj {\n" +
    "            height: 166px;\n" +
    "            width: 122px;\n" +
    "            border-radius: 7px;\n" +
    "            background-color: #25252b;\n" +
    "            object-fit: cover\n" +
    "        }\n" +
    "\n" +
    "        .yxq-listbox .yxq-selset-list {\n" +
    "            display: none\n" +
    "        }\n" +
    "\n" +
    "        .yxq-stting {\n" +
    "            -webkit-transform: scale(1) !important;\n" +
    "            transform: scale(1) !important;\n" +
    "            background-color: rgb(0 0 0 / 50%);\n" +
    "            padding: 10px 10px 60px 10px;\n"+
    "            font: 14px Helvetica Neue,Helvetica,PingFang SC,Tahoma,Arial,sans-serif\n" +
    "        }\n" +
    "\n" +
    "        .vodlist-of,.yxqplayer-mask {\n" +
    "            position: absolute;\n" +
    "            top: 0;\n" +
    "            bottom: 0;\n" +
    "            left: 0;\n" +
    "            right: 0;\n" +
    "            z-index: 1001;\n" +
    "            display: none\n" +
    "        }\n" +
    "\n" +
    "        .yxq-show {\n" +
    "            display: block !important\n" +
    "        }\n" +
    "\n" +
    "        .fixed_right_bar {\n" +
    "            position: fixed;\n" +
    "            bottom: 33px;\n" +
    "            right: 1%;\n" +
    "            z-index: 10001\n" +
    "        }\n" +
    "\n" +
    "        .fixed_right_bar a {\n" +
    "            font-size: 16px;\n" +
    "            margin: 10px auto;\n" +
    "            position: relative;\n" +
    "            color: #fff\n" +
    "        }\n" +
    "\n" +
    "        .ant-back-top {\n" +
    "            display: none\n" +
    "        }\n" +
    "\n" +
    "        .video-list-cl {\n" +
    "            text-align: right;\n" +
    "            right: 10px;\n" +
    "            font-size: 16px;\n" +
    "            position: relative;\n" +
    "            height: 0px;\n" +
    "            line-height: 33px;\n" +
    "            z-index: 99\n" +
    "        }\n" +
    "\n" +
    "        .yxq-this,.scroll-area a:hover {\n" +
    "            color: #CC6633 !important\n" +
    "        }\n" +
    "\n" +
    "        #listShow .active {\n" +
    "            color: var(--art-theme) !important\n" +
    "        }\n" +
    "\n" +
    "        #searchTvList .active {\n" +
    "            color: var(--art-theme) !important\n" +
    "        }\n" +

    "        .searchTvInput {\n" +
    "            padding: 10px;\n" +
    "            border-radius: 8px;\n" +
    "            width: 70%;\n" +
    "            resize: none;\n" +
    "            flex: 1;\n" +
    "            border: 5px red;\n" +
    "            outline: 0;\n" +
    "            font-size: 0.875rem;\n" +
    "            line-height: normal;\n" +
    "            height: 2rem;\n" +
    "        }"+

    "        .searchTvButton {\n" +
    "            width: 25%;\n" +
    "            background-color: var(--art-theme) !important;\n" +
    "            color: white;\n" +
    "            padding: 0px 0px;\n" +
    "            border: none;\n" +
    "            border-radius: 4px;\n" +
    "            height: 2rem;\n" +
    "        }"+
    "\n" +
    "        .yxq-listbox ::-webkit-scrollbar,#danmu-show ::-webkit-scrollbar {\n" +
    "            width: 5px;\n" +
    "            height: 5px\n" +
    "        }\n" +
    "\n" +
    "        .art-setting-custom {" +
    "           width: 80px;\n" +
    "        }"+
    "        .yxq-listbox ::-webkit-scrollbar-thumb,#danmu-show ::-webkit-scrollbar-thumb {\n" +
    "            background-color: #666\n" +
    "        }";

},{}],"1vNkK":[function(require,module,exports) {
!function(r, t) {
    module.exports = t();
}(this, function() {
    "use strict";
    function e(r) {
        return (e = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(r) {
            return typeof r;
        } : function(r) {
            return r && "function" == typeof Symbol && r.constructor === Symbol && r !== Symbol.prototype ? "symbol" : typeof r;
        })(r);
    }
    var n = Object.prototype.toString, c = function(r) {
        if (void 0 === r) return "undefined";
        if (null === r) return "null";
        var t = e(r);
        if ("boolean" === t) return "boolean";
        if ("string" === t) return "string";
        if ("number" === t) return "number";
        if ("symbol" === t) return "symbol";
        if ("function" === t) return function(r) {
            return "GeneratorFunction" === o(r);
        }(r) ? "generatorfunction" : "function";
        if (function(r) {
            return Array.isArray ? Array.isArray(r) : r instanceof Array;
        }(r)) return "array";
        if (function(r) {
            if (r.constructor && "function" == typeof r.constructor.isBuffer) return r.constructor.isBuffer(r);
            return !1;
        }(r)) return "buffer";
        if (function(r) {
            try {
                if ("number" == typeof r.length && "function" == typeof r.callee) return !0;
            } catch (r) {
                if (-1 !== r.message.indexOf("callee")) return !0;
            }
            return !1;
        }(r)) return "arguments";
        if (function(r) {
            return r instanceof Date || "function" == typeof r.toDateString && "function" == typeof r.getDate && "function" == typeof r.setDate;
        }(r)) return "date";
        if (function(r) {
            return r instanceof Error || "string" == typeof r.message && r.constructor && "number" == typeof r.constructor.stackTraceLimit;
        }(r)) return "error";
        if (function(r) {
            return r instanceof RegExp || "string" == typeof r.flags && "boolean" == typeof r.ignoreCase && "boolean" == typeof r.multiline && "boolean" == typeof r.global;
        }(r)) return "regexp";
        switch(o(r)){
            case "Symbol":
                return "symbol";
            case "Promise":
                return "promise";
            case "WeakMap":
                return "weakmap";
            case "WeakSet":
                return "weakset";
            case "Map":
                return "map";
            case "Set":
                return "set";
            case "Int8Array":
                return "int8array";
            case "Uint8Array":
                return "uint8array";
            case "Uint8ClampedArray":
                return "uint8clampedarray";
            case "Int16Array":
                return "int16array";
            case "Uint16Array":
                return "uint16array";
            case "Int32Array":
                return "int32array";
            case "Uint32Array":
                return "uint32array";
            case "Float32Array":
                return "float32array";
            case "Float64Array":
                return "float64array";
        }
        if (function(r) {
            return "function" == typeof r.throw && "function" == typeof r.return && "function" == typeof r.next;
        }(r)) return "generator";
        switch(t = n.call(r)){
            case "[object Object]":
                return "object";
            case "[object Map Iterator]":
                return "mapiterator";
            case "[object Set Iterator]":
                return "setiterator";
            case "[object String Iterator]":
                return "stringiterator";
            case "[object Array Iterator]":
                return "arrayiterator";
        }
        return t.slice(8, -1).toLowerCase().replace(/\s/g, "");
    };
    function o(r) {
        return r.constructor ? r.constructor.name : null;
    }
    function f(r, t) {
        var e = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : [
            "option"
        ];
        return s(r, t, e), y(r, t, e), function(a, i, u) {
            var r = c(i), t = c(a);
            if ("object" === r) {
                if ("object" !== t) throw new Error("[Type Error]: '".concat(u.join("."), "' require 'object' type, but got '").concat(t, "'"));
                Object.keys(i).forEach(function(r) {
                    var t = a[r], e = i[r], n = u.slice();
                    n.push(r), s(t, e, n), y(t, e, n), f(t, e, n);
                });
            }
            if ("array" === r) {
                if ("array" !== t) throw new Error("[Type Error]: '".concat(u.join("."), "' require 'array' type, but got '").concat(t, "'"));
                a.forEach(function(r, t) {
                    var e = a[t], n = i[t] || i[0], o = u.slice();
                    o.push(t), s(e, n, o), y(e, n, o), f(e, n, o);
                });
            }
        }(r, t, e), r;
    }
    function s(r, t, e) {
        if ("string" === c(t)) {
            var n = c(r);
            if ("?" === t[0] && (t = t.slice(1) + "|undefined"), !(-1 < t.indexOf("|") ? t.split("|").map(function(r) {
                return r.toLowerCase().trim();
            }).filter(Boolean).some(function(r) {
                return n === r;
            }) : t.toLowerCase().trim() === n)) throw new Error("[Type Error]: '".concat(e.join("."), "' require '").concat(t, "' type, but got '").concat(n, "'"));
        }
    }
    function y(r, t, e) {
        if ("function" === c(t)) {
            var n = t(r, c(r), e);
            if (!0 !== n) {
                var o = c(n);
                throw "string" === o ? new Error(n) : "error" === o ? n : new Error("[Validator Error]: The scheme for '".concat(e.join("."), "' validator require return true, but got '").concat(n, "'"));
            }
        }
    }
    return f.kindOf = c, f;
});

},{}],"8uSwy":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
class Emitter {
    on(name, fn, ctx) {
        const e = this.e || (this.e = {});
        (e[name] || (e[name] = [])).push({
            fn,
            ctx
        });
        return this;
    }
    once(name, fn, ctx) {
        const self = this;
        function listener(...args) {
            self.off(name, listener);
            fn.apply(ctx, args);
        }
        listener._ = fn;
        return this.on(name, listener, ctx);
    }
    emit(name, ...data) {
        const evtArr = ((this.e || (this.e = {}))[name] || []).slice();
        for(let i = 0; i < evtArr.length; i += 1)evtArr[i].fn.apply(evtArr[i].ctx, data);
        return this;
    }
    off(name, callback) {
        const e = this.e || (this.e = {});
        const evts = e[name];
        const liveEvents = [];
        if (evts && callback) {
            for(let i = 0, len = evts.length; i < len; i += 1)if (evts[i].fn !== callback && evts[i].fn._ !== callback) liveEvents.push(evts[i]);
        }
        if (liveEvents.length) e[name] = liveEvents;
        else delete e[name];
        return this;
    }
}
exports.default = Emitter;

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6SDkN":[function(require,module,exports) {
exports.interopDefault = function(a) {
    return a && a.__esModule ? a : {
        default: a
    };
};
exports.defineInteropFlag = function(a) {
    Object.defineProperty(a, "__esModule", {
        value: true
    });
};
exports.exportAll = function(source, dest) {
    Object.keys(source).forEach(function(key) {
        if (key === "default" || key === "__esModule" || Object.prototype.hasOwnProperty.call(dest, key)) return;
        Object.defineProperty(dest, key, {
            enumerable: true,
            get: function() {
                return source[key];
            }
        });
    });
    return dest;
};
exports.export = function(dest, destName, get) {
    Object.defineProperty(dest, destName, {
        enumerable: true,
        get: get
    });
};

},{}],"euhMG":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _dom = require("./dom");
parcelHelpers.exportAll(_dom, exports);
var _error = require("./error");
parcelHelpers.exportAll(_error, exports);
var _subtitle = require("./subtitle");
parcelHelpers.exportAll(_subtitle, exports);
var _file = require("./file");
parcelHelpers.exportAll(_file, exports);
var _property = require("./property");
parcelHelpers.exportAll(_property, exports);
var _time = require("./time");
parcelHelpers.exportAll(_time, exports);
var _format = require("./format");
parcelHelpers.exportAll(_format, exports);
var _compatibility = require("./compatibility");
parcelHelpers.exportAll(_compatibility, exports);

},{"./dom":"iWXW0","./error":"kCmly","./subtitle":"2bAfM","./file":"jIGsL","./property":"amiWs","./time":"4movt","./format":"9vUua","./compatibility":"bRDYJ","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"iWXW0":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "query", ()=>query);
parcelHelpers.export(exports, "queryAll", ()=>queryAll);
parcelHelpers.export(exports, "addClass", ()=>addClass);
parcelHelpers.export(exports, "removeClass", ()=>removeClass);
parcelHelpers.export(exports, "hasClass", ()=>hasClass);
parcelHelpers.export(exports, "append", ()=>append);
parcelHelpers.export(exports, "remove", ()=>remove);
parcelHelpers.export(exports, "setStyle", ()=>setStyle);
parcelHelpers.export(exports, "setStyles", ()=>setStyles);
parcelHelpers.export(exports, "getStyle", ()=>getStyle);
parcelHelpers.export(exports, "sublings", ()=>sublings);
parcelHelpers.export(exports, "inverseClass", ()=>inverseClass);
parcelHelpers.export(exports, "tooltip", ()=>tooltip);
parcelHelpers.export(exports, "isInViewport", ()=>isInViewport);
parcelHelpers.export(exports, "includeFromEvent", ()=>includeFromEvent);
parcelHelpers.export(exports, "replaceElement", ()=>replaceElement);
parcelHelpers.export(exports, "createElement", ()=>createElement);
parcelHelpers.export(exports, "getIcon", ()=>getIcon);
parcelHelpers.export(exports, "setStyleText", ()=>setStyleText);
parcelHelpers.export(exports, "supportsFlex", ()=>supportsFlex);
parcelHelpers.export(exports, "getRect", ()=>getRect);
var _compatibility = require("./compatibility");
function query(selector, parent = document) {
    return parent.querySelector(selector);
}
function queryAll(selector, parent = document) {
    return Array.from(parent.querySelectorAll(selector));
}
function addClass(target, className) {
    return target.classList.add(className);
}
function removeClass(target, className) {
    return target.classList.remove(className);
}
function hasClass(target, className) {
    return target.classList.contains(className);
}
function append(parent, child) {
    if (child instanceof Element) parent.appendChild(child);
    else parent.insertAdjacentHTML("beforeend", String(child));
    return parent.lastElementChild || parent.lastChild;
}
function remove(child) {
    return child.parentNode.removeChild(child);
}
function setStyle(element, key, value) {
    element.style[key] = value;
    return element;
}
function setStyles(element, styles) {
    for(const key in styles)setStyle(element, key, styles[key]);
    return element;
}
function getStyle(element, key, numberType = true) {
    const value = window.getComputedStyle(element, null).getPropertyValue(key);
    return numberType ? parseFloat(value) : value;
}
function sublings(target) {
    return Array.from(target.parentElement.children).filter((item)=>item !== target);
}
function inverseClass(target, className) {
    sublings(target).forEach((item)=>removeClass(item, className));
    addClass(target, className);
}
function tooltip(target, msg, pos = "top") {
    if (0, _compatibility.isMobile) return;
    target.setAttribute("aria-label", msg);
    addClass(target, "hint--rounded");
    addClass(target, `hint--${pos}`);
}
function isInViewport(el, offset = 0) {
    const rect = el.getBoundingClientRect();
    const windowHeight = window.innerHeight || document.documentElement.clientHeight;
    const windowWidth = window.innerWidth || document.documentElement.clientWidth;
    const vertInView = rect.top - offset <= windowHeight && rect.top + rect.height + offset >= 0;
    const horInView = rect.left - offset <= windowWidth + offset && rect.left + rect.width + offset >= 0;
    return vertInView && horInView;
}
function includeFromEvent(event, target) {
    return event.composedPath && event.composedPath().indexOf(target) > -1;
}
function replaceElement(newChild, oldChild) {
    oldChild.parentNode.replaceChild(newChild, oldChild);
    return newChild;
}
function createElement(tag) {
    return document.createElement(tag);
}
function getIcon(key = "", html = "") {
    const icon = createElement("i");
    addClass(icon, "art-icon");
    addClass(icon, `art-icon-${key}`);
    append(icon, html);
    return icon;
}
function setStyleText(id, style) {
    const $style = document.getElementById(id);
    if ($style) $style.textContent = style;
    else {
        const $style = createElement("style");
        $style.id = id;
        $style.textContent = style;
        document.head.appendChild($style);
    }
}
function supportsFlex() {
    const div = document.createElement("div");
    div.style.display = "flex";
    return div.style.display === "flex";
}
function getRect(el) {
    return el.getBoundingClientRect();
}

},{"./compatibility":"bRDYJ","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"bRDYJ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "userAgent", ()=>userAgent);
parcelHelpers.export(exports, "isSafari", ()=>isSafari);
parcelHelpers.export(exports, "isWechat", ()=>isWechat);
parcelHelpers.export(exports, "isIE", ()=>isIE);
parcelHelpers.export(exports, "isAndroid", ()=>isAndroid);
parcelHelpers.export(exports, "isIOS", ()=>isIOS);
parcelHelpers.export(exports, "isIOS13", ()=>isIOS13);
parcelHelpers.export(exports, "isMobile", ()=>isMobile);
parcelHelpers.export(exports, "isBrowser", ()=>isBrowser);
const userAgent = typeof navigator !== "undefined" ? navigator.userAgent : "";
const isSafari = /^((?!chrome|android).)*safari/i.test(userAgent);
const isWechat = /MicroMessenger/i.test(userAgent);
const isIE = /MSIE|Trident/i.test(userAgent);
const isAndroid = /android/i.test(userAgent);
const isIOS = /iPad|iPhone|iPod/i.test(userAgent) && !window.MSStream;
const isIOS13 = isIOS || userAgent.includes("Macintosh") && navigator.maxTouchPoints >= 1;
const isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(userAgent) || isIOS13;
const isBrowser = typeof window !== "undefined";

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"kCmly":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "ArtPlayerError", ()=>ArtPlayerError);
parcelHelpers.export(exports, "errorHandle", ()=>errorHandle);
class ArtPlayerError extends Error {
    constructor(message, context){
        super(message);
        if (typeof Error.captureStackTrace === "function") Error.captureStackTrace(this, context || this.constructor);
        this.name = "ArtPlayerError";
    }
}
function errorHandle(condition, msg) {
    if (!condition) throw new ArtPlayerError(msg);
    return condition;
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"2bAfM":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "srtToVtt", ()=>srtToVtt);
parcelHelpers.export(exports, "vttToBlob", ()=>vttToBlob);
parcelHelpers.export(exports, "assToVtt", ()=>assToVtt);
function fixSrt(srt) {
    return srt.replace(/(\d\d:\d\d:\d\d)[,.](\d+)/g, (_, $1, $2)=>{
        let ms = $2.slice(0, 3);
        if ($2.length === 1) ms = $2 + "00";
        if ($2.length === 2) ms = $2 + "0";
        return `${$1},${ms}`;
    });
}
function srtToVtt(srtText) {
    return "WEBVTT \r\n\r\n".concat(fixSrt(srtText).replace(/\{\\([ibu])\}/g, "</$1>").replace(/\{\\([ibu])1\}/g, "<$1>").replace(/\{([ibu])\}/g, "<$1>").replace(/\{\/([ibu])\}/g, "</$1>").replace(/(\d\d:\d\d:\d\d),(\d\d\d)/g, "$1.$2").replace(/{[\s\S]*?}/g, "").concat("\r\n\r\n"));
}
function vttToBlob(vttText) {
    return URL.createObjectURL(new Blob([
        vttText
    ], {
        type: "text/vtt"
    }));
}
function assToVtt(ass) {
    const reAss = new RegExp("Dialogue:\\s\\d,(\\d+:\\d\\d:\\d\\d.\\d\\d),(\\d+:\\d\\d:\\d\\d.\\d\\d),([^,]*),([^,]*),(?:[^,]*,){4}([\\s\\S]*)$", "i");
    function fixTime(time = "") {
        return time.split(/[:.]/).map((item, index, arr)=>{
            if (index === arr.length - 1) {
                if (item.length === 1) return `.${item}00`;
                if (item.length === 2) return `.${item}0`;
            } else if (item.length === 1) return (index === 0 ? "0" : ":0") + item;
            return index === 0 ? item : index === arr.length - 1 ? `.${item}` : `:${item}`;
        }).join("");
    }
    return "WEBVTT\n\n" + ass.split(/\r?\n/).map((line)=>{
        const m = line.match(reAss);
        if (!m) return null;
        return {
            start: fixTime(m[1].trim()),
            end: fixTime(m[2].trim()),
            text: m[5].replace(/{[\s\S]*?}/g, "").replace(/(\\N)/g, "\n").trim().split(/\r?\n/).map((item)=>item.trim()).join("\n")
        };
    }).filter((line)=>line).map((line, index)=>{
        if (line) return index + 1 + "\n" + `${line.start} --> ${line.end}` + "\n" + `${line.text}`;
        return "";
    }).filter((line)=>line.trim()).join("\n\n");
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jIGsL":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "getExt", ()=>getExt);
parcelHelpers.export(exports, "download", ()=>download);
function getExt(url) {
    if (url.includes("?")) return getExt(url.split("?")[0]);
    if (url.includes("#")) return getExt(url.split("#")[0]);
    return url.trim().toLowerCase().split(".").pop();
}
function download(url, name) {
    const elink = document.createElement("a");
    elink.style.display = "none";
    elink.href = url;
    elink.download = name;
    document.body.appendChild(elink);
    elink.click();
    document.body.removeChild(elink);
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"amiWs":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "def", ()=>def);
parcelHelpers.export(exports, "has", ()=>has);
parcelHelpers.export(exports, "get", ()=>get);
parcelHelpers.export(exports, "mergeDeep", ()=>mergeDeep);
const def = Object.defineProperty;
const { hasOwnProperty } = Object.prototype;
function has(obj, name) {
    return hasOwnProperty.call(obj, name);
}
function get(obj, name) {
    return Object.getOwnPropertyDescriptor(obj, name);
}
function mergeDeep(...objects) {
    const isObject = (item)=>item && typeof item === "object" && !Array.isArray(item);
    return objects.reduce((prev, obj)=>{
        Object.keys(obj).forEach((key)=>{
            const pVal = prev[key];
            const oVal = obj[key];
            if (Array.isArray(pVal) && Array.isArray(oVal)) prev[key] = pVal.concat(...oVal);
            else if (isObject(pVal) && isObject(oVal)) prev[key] = mergeDeep(pVal, oVal);
            else prev[key] = oVal;
        });
        return prev;
    }, {});
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4movt":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "sleep", ()=>sleep);
parcelHelpers.export(exports, "debounce", ()=>debounce);
parcelHelpers.export(exports, "throttle", ()=>throttle);
function sleep(ms = 0) {
    return new Promise((resolve)=>setTimeout(resolve, ms));
}
function debounce(func, duration) {
    let timeout;
    return function(...args) {
        const effect = ()=>{
            timeout = null;
            return func.apply(this, args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(effect, duration);
    };
}
function throttle(func, duration) {
    let shouldWait = false;
    return function(...args) {
        if (!shouldWait) {
            func.apply(this, args);
            shouldWait = true;
            setTimeout(function() {
                shouldWait = false;
            }, duration);
        }
    };
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"9vUua":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "clamp", ()=>clamp);
parcelHelpers.export(exports, "capitalize", ()=>capitalize);
parcelHelpers.export(exports, "isStringOrNumber", ()=>isStringOrNumber);
parcelHelpers.export(exports, "secondToTime", ()=>secondToTime);
parcelHelpers.export(exports, "escape", ()=>escape);
parcelHelpers.export(exports, "unescape", ()=>unescape);
function clamp(num, a, b) {
    return Math.max(Math.min(num, Math.max(a, b)), Math.min(a, b));
}
function capitalize(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
}
function isStringOrNumber(val) {
    return [
        "string",
        "number"
    ].includes(typeof val);
}
function secondToTime(second) {
    if (!second) return "00:00";
    const add0 = (num)=>num < 10 ? `0${num}` : String(num);
    const hour = Math.floor(second / 3600);
    const min = Math.floor((second - hour * 3600) / 60);
    const sec = Math.floor(second - hour * 3600 - min * 60);
    return (hour > 0 ? [
        hour,
        min,
        sec
    ] : [
        min,
        sec
    ]).map(add0).join(":");
}
function escape(str) {
    return str.replace(/[&<>'"]/g, (tag)=>({
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            "'": "&#39;",
            '"': "&quot;"
        })[tag] || tag);
}
function unescape(str) {
    const map = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&#39;": "'",
        "&quot;": '"'
    };
    const reg = new RegExp(`(${Object.keys(map).join("|")})`, "g");
    return str.replace(reg, (tag)=>map[tag] || tag);
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jVxq1":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "ComponentOption", ()=>ComponentOption);
var _utils = require("../utils");
const a = "array";
const b = "boolean";
const s = "string";
const n = "number";
const o = "object";
const f = "function";
function validElement(value, type, paths) {
    return (0, _utils.errorHandle)(type === s || type === n || value instanceof Element, `${paths.join(".")} require '${s}' or 'Element' type`);
}
const ComponentOption = {
    html: validElement,
    disable: `?${b}`,
    name: `?${s}`,
    index: `?${n}`,
    style: `?${o}`,
    click: `?${f}`,
    mounted: `?${f}`,
    tooltip: `?${s}|${n}`,
    width: `?${n}`,
    selector: `?${a}`,
    onSelect: `?${f}`,
    switch: `?${b}`,
    onSwitch: `?${f}`,
    range: `?${a}`,
    onRange: `?${f}`,
    onChange: `?${f}`
};
exports.default = {
    id: s,
    container: validElement,
    url: s,
    poster: s,
    type: s,
    theme: s,
    lang: s,
    volume: n,
    isLive: b,
    muted: b,
    autoplay: b,
    autoSize: b,
    autoMini: b,
    loop: b,
    flip: b,
    playbackRate: b,
    aspectRatio: b,
    screenshot: b,
    setting: b,
    hotkey: b,
    pip: b,
    mutex: b,
    backdrop: b,
    fullscreen: b,
    fullscreenWeb: b,
    subtitleOffset: b,
    miniProgressBar: b,
    useSSR: b,
    playsInline: b,
    lock: b,
    fastForward: b,
    autoPlayback: b,
    autoOrientation: b,
    airplay: b,
    speed: b,
    plugins: [
        f
    ],
    layers: [
        ComponentOption
    ],
    contextmenu: [
        ComponentOption
    ],
    settings: [
        ComponentOption
    ],
    controls: [
        {
            ...ComponentOption,
            position: (value, _, paths)=>{
                const position = [
                    "top",
                    "left",
                    "right"
                ];
                return (0, _utils.errorHandle)(position.includes(value), `${paths.join(".")} only accept ${position.toString()} as parameters`);
            }
        }
    ],
    quality: [
        {
            default: `?${b}`,
            html: s,
            url: s
        }
    ],
    highlight: [
        {
            time: n,
            text: s
        }
    ],
    thumbnails: {
        url: s,
        number: n,
        column: n,
        width: n,
        height: n
    },
    subtitle: {
        url: s,
        name: s,
        type: s,
        style: o,
        escape: b,
        encoding: s,
        onVttLoad: f
    },
    moreVideoAttr: o,
    i18n: o,
    icons: o,
    cssVar: o,
    customType: o
};

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1hSww":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
exports.default = {
    propertys: [
        "audioTracks",
        "autoplay",
        "buffered",
        "controller",
        "controls",
        "crossOrigin",
        "currentSrc",
        "currentTime",
        "defaultMuted",
        "defaultPlaybackRate",
        "duration",
        "ended",
        "error",
        "loop",
        "mediaGroup",
        "muted",
        "networkState",
        "paused",
        "playbackRate",
        "played",
        "preload",
        "readyState",
        "seekable",
        "seeking",
        "src",
        "startDate",
        "textTracks",
        "videoTracks",
        "volume"
    ],
    methods: [
        "addTextTrack",
        "canPlayType",
        "load",
        "play",
        "pause"
    ],
    events: [
        "abort",
        "canplay",
        "canplaythrough",
        "durationchange",
        "emptied",
        "ended",
        "error",
        "loadeddata",
        "loadedmetadata",
        "loadstart",
        "pause",
        "play",
        "playing",
        "progress",
        "ratechange",
        "seeked",
        "seeking",
        "stalled",
        "suspend",
        "timeupdate",
        "volumechange",
        "waiting"
    ],
    prototypes: [
        "width",
        "height",
        "videoWidth",
        "videoHeight",
        "poster",
        "webkitDecodedFrameCount",
        "webkitDroppedFrameCount",
        "playsInline",
        "webkitSupportsFullscreen",
        "webkitDisplayingFullscreen",
        "onenterpictureinpicture",
        "onleavepictureinpicture",
        "disablePictureInPicture",
        "cancelVideoFrameCallback",
        "requestVideoFrameCallback",
        "getVideoPlaybackQuality",
        "requestPictureInPicture",
        "webkitEnterFullScreen",
        "webkitEnterFullscreen",
        "webkitExitFullScreen",
        "webkitExitFullscreen"
    ]
};

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"eG0JW":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
class Template {
    constructor(art){
        this.art = art;
        const { option, constructor } = art;
        if (option.container instanceof Element) this.$container = option.container;
        else {
            this.$container = (0, _utils.query)(option.container);
            (0, _utils.errorHandle)(this.$container, `No container element found by ${option.container}`);
        }
        (0, _utils.errorHandle)((0, _utils.supportsFlex)(), "The current browser does not support flex layout");
        const type = this.$container.tagName.toLowerCase();
        (0, _utils.errorHandle)(type === "div", `Unsupported container element type, only support 'div' but got '${type}'`);
        (0, _utils.errorHandle)(constructor.instances.every((ins)=>ins.template.$container !== this.$container), "Cannot mount multiple instances on the same dom element");
        this.query = this.query.bind(this);
        this.$container.dataset.artId = art.id;
        this.init();
    }
    static get html() {
        return `
          <div class="art-video-player art-subtitle-show art-layer-show art-control-show art-mask-show">
            <video class="art-video">
              <track default kind="metadata" src=""></track>
            </video>
            <video class="art-video-cut" id="art-video-cut" crossorigin="Anonymous" style="width: 0px;" muted="true">
              <track default kind="metadata" src=""></track>
            </video>
            <div class="art-poster"></div>
            <div class="art-subtitle"></div>
            <div class="art-danmuku"></div>
            <div class="art-layers">
            <div class="art-layer art-layer-notice-apeed" data-index="1" style="display: none;">
                  <div class="notice-speed" style="">
                    <i class="speed-icon" style="">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 111 66" width="111" height="66"
                             preserveAspectRatio="xMidYMid meet"
                             style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);">
                            <defs>
                                <clipPath id="__lottie_element_19">
                                    <rect width="111" height="66" x="0" y="0"></rect>
                                </clipPath>
                            </defs>
                            <g clip-path="url(#__lottie_element_19)">
                                <g transform="matrix(1,0,0,1,94.5,32.5)" opacity="0.8" style="display: block;">
                                    <g opacity="1" transform="matrix(0,3,-3,0,0,0)">
                                        <path fill="rgb(255,255,255)" fill-opacity="1"
                                              d=" M6.138000011444092,3.5460000038146973 C6.4679999351501465,4.105999946594238 6.2779998779296875,4.826000213623047 5.7179999351501465,5.156000137329102 C5.538000106811523,5.265999794006348 5.3379998207092285,5.326000213623047 5.118000030517578,5.326000213623047 C5.118000030517578,5.326000213623047 -5.122000217437744,5.326000213623047 -5.122000217437744,5.326000213623047 C-5.771999835968018,5.326000213623047 -6.302000045776367,4.796000003814697 -6.302000045776367,4.145999908447266 C-6.302000045776367,3.936000108718872 -6.242000102996826,3.7260000705718994 -6.142000198364258,3.5460000038146973 C-6.142000198364258,3.5460000038146973 -1.3519999980926514,-4.553999900817871 -1.3519999980926514,-4.553999900817871 C-0.9120000004768372,-5.294000148773193 0.04800000041723251,-5.544000148773193 0.7979999780654907,-5.104000091552734 C1.027999997138977,-4.973999977111816 1.218000054359436,-4.783999919891357 1.3480000495910645,-4.553999900817871 C1.3480000495910645,-4.553999900817871 6.138000011444092,3.5460000038146973 6.138000011444092,3.5460000038146973z"></path>
                                       <animate attributeName="opacity" from="0.5" to="1" dur="1s" repeatCount="indefinite"/>
                                    </g>
                                </g>
                                <g transform="matrix(1,0,0,1,55.5,32.5)" opacity="0.5" style="display: block;">
                                    <g opacity="1" transform="matrix(0,3,-3,0,0,0)">
                                        <path fill="rgb(255,255,255)" fill-opacity="1"
                                              d=" M6.138000011444092,3.5460000038146973 C6.4679999351501465,4.105999946594238 6.2779998779296875,4.826000213623047 5.7179999351501465,5.156000137329102 C5.538000106811523,5.265999794006348 5.3379998207092285,5.326000213623047 5.118000030517578,5.326000213623047 C5.118000030517578,5.326000213623047 -5.122000217437744,5.326000213623047 -5.122000217437744,5.326000213623047 C-5.771999835968018,5.326000213623047 -6.302000045776367,4.796000003814697 -6.302000045776367,4.145999908447266 C-6.302000045776367,3.936000108718872 -6.242000102996826,3.7260000705718994 -6.142000198364258,3.5460000038146973 C-6.142000198364258,3.5460000038146973 -1.3519999980926514,-4.553999900817871 -1.3519999980926514,-4.553999900817871 C-0.9120000004768372,-5.294000148773193 0.04800000041723251,-5.544000148773193 0.7979999780654907,-5.104000091552734 C1.027999997138977,-4.973999977111816 1.218000054359436,-4.783999919891357 1.3480000495910645,-4.553999900817871 C1.3480000495910645,-4.553999900817871 6.138000011444092,3.5460000038146973 6.138000011444092,3.5460000038146973z"></path>
                                        <animate attributeName="opacity" from="0.5" to="1" dur="0.8s" repeatCount="indefinite"/>
                                    </g>
                                </g>
                                <g transform="matrix(1,0,0,1,16.5,32.5)" opacity="0.2" style="display: block;">
                                    <g opacity="1" transform="matrix(0,3,-3,0,0,0)">
                                        <path fill="rgb(255,255,255)" fill-opacity="0.8"
                                              d=" M6.138000011444092,3.5460000038146973 C6.4679999351501465,4.105999946594238 6.2779998779296875,4.826000213623047 5.7179999351501465,5.156000137329102 C5.538000106811523,5.265999794006348 5.3379998207092285,5.326000213623047 5.118000030517578,5.326000213623047 C5.118000030517578,5.326000213623047 -5.122000217437744,5.326000213623047 -5.122000217437744,5.326000213623047 C-5.771999835968018,5.326000213623047 -6.302000045776367,4.796000003814697 -6.302000045776367,4.145999908447266 C-6.302000045776367,3.936000108718872 -6.242000102996826,3.7260000705718994 -6.142000198364258,3.5460000038146973 C-6.142000198364258,3.5460000038146973 -1.3519999980926514,-4.553999900817871 -1.3519999980926514,-4.553999900817871 C-0.9120000004768372,-5.294000148773193 0.04800000041723251,-5.544000148773193 0.7979999780654907,-5.104000091552734 C1.027999997138977,-4.973999977111816 1.218000054359436,-4.783999919891357 1.3480000495910645,-4.553999900817871 C1.3480000495910645,-4.553999900817871 6.138000011444092,3.5460000038146973 6.138000011444092,3.5460000038146973z"></path>
                                       <animate attributeName="opacity" from="0.2" to="1" dur="0.8s" repeatCount="indefinite"/>
                                    </g>
                                </g>
                            </g>
                        </svg>                    
                    </i>
                    倍速播放中
                  </div>
                </div>
            </div>
            <div class="art-mask">
              <div class="art-state"></div>
            </div>
            <div class="art-bottom">
              <div class="art-progress"></div>
              <div class="art-controls">
                <div class="art-controls-left"></div>
                <div class="art-controls-center"></div>
                <div class="art-controls-right"></div>
              </div>
            </div>
            <div class="art-loading"></div>
            <div class="art-notice">
              <div class="art-notice-inner"></div>
            </div>
            <div class="art-settings"></div>
            <div class="art-info">
              <div class="art-info-panel">
                <div class="art-info-item">
                  <div class="art-info-title">播放器版本:</div>
                  <div class="art-info-content">${"5.1.6"}</div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">播放器帧率:</div>
                  <div class="art-info-content" id="playerFrameRate"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">视频地址:</div>
                  <div class="art-info-content" data-video="src"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">当前播放时间:</div>
                  <div class="art-info-content" data-video="currentTime"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">视频时长:</div>
                  <div class="art-info-content" data-video="duration"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">播放速度:</div>
                  <div class="art-info-content" data-video="playbackRate"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">静音:</div>
                  <div class="art-info-content" data-video="muted"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">视频音量:</div>
                  <div class="art-info-content" data-video="volume"></div>
                </div>
                <div class="art-info-item">
                  <div class="art-info-title">视频分辨率:</div>
                  <div class="art-info-content">
                    <span data-video="videoWidth"></span> x <span data-video="videoHeight"></span>
                  </div>
                </div>
              </div>
              <div class="art-info-close">[x]</div>
            </div>
            <div class="art-contextmenus"></div>
          </div>
        `;
    }
    query(className) {
        return (0, _utils.query)(className, this.$container);
    }
    init() {
        const { option } = this.art;
        if (!option.useSSR) this.$container.innerHTML = Template.html;
        this.$player = this.query(".art-video-player");
        this.$video = this.query(".art-video");
        this.$videoCut = this.query(".art-video-cut");
        this.$track = this.query("track");
        this.$poster = this.query(".art-poster");
        this.$subtitle = this.query(".art-subtitle");
        this.$danmuku = this.query(".art-danmuku");
        this.$bottom = this.query(".art-bottom");
        this.$progress = this.query(".art-progress");
        this.$controls = this.query(".art-controls");
        this.$controlsLeft = this.query(".art-controls-left");
        this.$controlsCenter = this.query(".art-controls-center");
        this.$controlsRight = this.query(".art-controls-right");
        this.$layer = this.query(".art-layers");
        this.$loading = this.query(".art-loading");
        this.$notice = this.query(".art-notice");
        this.$noticeInner = this.query(".art-notice-inner");
        this.$mask = this.query(".art-mask");
        this.$state = this.query(".art-state");
        this.$setting = this.query(".art-settings");
        this.$info = this.query(".art-info");
        this.$infoPanel = this.query(".art-info-panel");
        this.$infoClose = this.query(".art-info-close");
        this.$contextmenu = this.query(".art-contextmenus");
        if (option.backdrop) (0, _utils.addClass)(this.$player, "art-backdrop");
        if (0, _utils.isMobile) (0, _utils.addClass)(this.$player, "art-mobile");
    }
    destroy(removeHtml) {
        if (removeHtml) this.$container.innerHTML = "";
        else (0, _utils.addClass)(this.$player, "art-destroy");
    }
}
exports.default = Template;

},{"./utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6Q0In":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("../utils");
var _zhCn = require("./zh-cn");
var _zhCnDefault = parcelHelpers.interopDefault(_zhCn);
class I18n {
    constructor(art){
        this.art = art;
        this.languages = {
            "zh-cn": (0, _zhCnDefault.default)
        };
        this.language = {};
        this.update(art.option.i18n);
    }
    init() {
        const lang = this.art.option.lang.toLowerCase();
        this.language = this.languages[lang] || {};
    }
    get(key) {
        return this.language[key] || key;
    }
    update(value) {
        this.languages = (0, _utils.mergeDeep)(this.languages, value);
        this.init();
    }
}
exports.default = I18n;

},{"../utils":"euhMG","./zh-cn":"iSymG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"iSymG":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
const zhCn = {
    "Video Info": "\u7EDF\u8BA1\u4FE1\u606F",
    Close: "\u5173\u95ED",
    "Video Load Failed": "\u52A0\u8F7D\u5931\u8D25",
    Volume: "\u97F3\u91CF",
    Play: "\u64AD\u653E",
    Pause: "\u6682\u505C",
    Rate: "\u901F\u5EA6",
    Mute: "\u9759\u97F3",
    "Video Flip": "\u753B\u9762\u7FFB\u8F6C",
    Horizontal: "\u6C34\u5E73",
    Vertical: "\u5782\u76F4",
    Reconnect: "\u91CD\u65B0\u8FDE\u63A5",
    "Show Setting": "\u663E\u793A\u8BBE\u7F6E",
    "Hide Setting": "\u9690\u85CF\u8BBE\u7F6E",
    Screenshot: "\u622A\u56FE",
    "Play Speed": "\u64AD\u653E\u901F\u5EA6",
    "Aspect Ratio": "\u753B\u9762\u6BD4\u4F8B",
    Default: "\u9ED8\u8BA4",
    Normal: "\u6B63\u5E38",
    Open: "\u6253\u5F00",
    "Switch Video": "\u5207\u6362",
    "Switch Subtitle": "\u5207\u6362\u5B57\u5E55",
    Fullscreen: "\u5168\u5C4F",
    "Exit Fullscreen": "\u9000\u51FA\u5168\u5C4F",
    "Web Fullscreen": "\u7F51\u9875\u5168\u5C4F",
    "Exit Web Fullscreen": "\u9000\u51FA\u7F51\u9875\u5168\u5C4F",
    "Mini Player": "\u8FF7\u4F60\u64AD\u653E\u5668",
    "PIP Mode": "\u5F00\u542F\u753B\u4E2D\u753B",
    "Exit PIP Mode": "\u9000\u51FA\u753B\u4E2D\u753B",
    "PIP Not Supported": "\u4E0D\u652F\u6301\u753B\u4E2D\u753B",
    "Fullscreen Not Supported": "\u4E0D\u652F\u6301\u5168\u5C4F",
    "Subtitle Offset": "\u5B57\u5E55\u504F\u79FB",
    "Last Seen": "\u4E0A\u6B21\u770B\u5230",
    "Jump Play": "\u81ea\u52a8\u8DF3\u8F6C\u64AD\u653E...",
    AirPlay: "\u9694\u7A7A\u64AD\u653E",
    "AirPlay Not Available": "\u9694\u7A7A\u64AD\u653E\u4E0D\u53EF\u7528"
};
exports.default = zhCn;
if (typeof window !== "undefined") window["artplayer-i18n-zh-cn"] = zhCn;

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"kmRM5":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _urlMix = require("./urlMix");
var _urlMixDefault = parcelHelpers.interopDefault(_urlMix);
var _attrMix = require("./attrMix");
var _attrMixDefault = parcelHelpers.interopDefault(_attrMix);
var _playMix = require("./playMix");
var _playMixDefault = parcelHelpers.interopDefault(_playMix);
var _pauseMix = require("./pauseMix");
var _pauseMixDefault = parcelHelpers.interopDefault(_pauseMix);
var _toggleMix = require("./toggleMix");
var _toggleMixDefault = parcelHelpers.interopDefault(_toggleMix);
var _seekMix = require("./seekMix");
var _seekMixDefault = parcelHelpers.interopDefault(_seekMix);
var _volumeMix = require("./volumeMix");
var _volumeMixDefault = parcelHelpers.interopDefault(_volumeMix);
var _currentTimeMix = require("./currentTimeMix");
var _currentTimeMixDefault = parcelHelpers.interopDefault(_currentTimeMix);
var _durationMix = require("./durationMix");
var _durationMixDefault = parcelHelpers.interopDefault(_durationMix);
var _switchMix = require("./switchMix");
var _switchMixDefault = parcelHelpers.interopDefault(_switchMix);
var _playbackRateMix = require("./playbackRateMix");
var _playbackRateMixDefault = parcelHelpers.interopDefault(_playbackRateMix);
var _aspectRatioMix = require("./aspectRatioMix");
var _aspectRatioMixDefault = parcelHelpers.interopDefault(_aspectRatioMix);
var _screenshotMix = require("./screenshotMix");
var _screenshotMixDefault = parcelHelpers.interopDefault(_screenshotMix);
var _fullscreenMix = require("./fullscreenMix");
var _fullscreenMixDefault = parcelHelpers.interopDefault(_fullscreenMix);
var _fullscreenWebMix = require("./fullscreenWebMix");
var _fullscreenWebMixDefault = parcelHelpers.interopDefault(_fullscreenWebMix);
var _pipMix = require("./pipMix");
var _pipMixDefault = parcelHelpers.interopDefault(_pipMix);
var _loadedMix = require("./loadedMix");
var _loadedMixDefault = parcelHelpers.interopDefault(_loadedMix);
var _playedMix = require("./playedMix");
var _playedMixDefault = parcelHelpers.interopDefault(_playedMix);
var _playingMix = require("./playingMix");
var _playingMixDefault = parcelHelpers.interopDefault(_playingMix);
var _autoSizeMix = require("./autoSizeMix");
var _autoSizeMixDefault = parcelHelpers.interopDefault(_autoSizeMix);
var _rectMix = require("./rectMix");
var _rectMixDefault = parcelHelpers.interopDefault(_rectMix);
var _flipMix = require("./flipMix");
var _flipMixDefault = parcelHelpers.interopDefault(_flipMix);
var _miniMix = require("./miniMix");
var _miniMixDefault = parcelHelpers.interopDefault(_miniMix);
var _posterMix = require("./posterMix");
var _posterMixDefault = parcelHelpers.interopDefault(_posterMix);
var _autoHeightMix = require("./autoHeightMix");
var _autoHeightMixDefault = parcelHelpers.interopDefault(_autoHeightMix);
var _cssVarMix = require("./cssVarMix");
var _cssVarMixDefault = parcelHelpers.interopDefault(_cssVarMix);
var _themeMix = require("./themeMix");
var _themeMixDefault = parcelHelpers.interopDefault(_themeMix);
var _typeMix = require("./typeMix");
var _typeMixDefault = parcelHelpers.interopDefault(_typeMix);
var _stateMix = require("./stateMix");
var _stateMixDefault = parcelHelpers.interopDefault(_stateMix);
var _subtitleOffsetMix = require("./subtitleOffsetMix");
var _subtitleOffsetMixDefault = parcelHelpers.interopDefault(_subtitleOffsetMix);
var _airplayMix = require("./airplayMix");
var _airplayMixDefault = parcelHelpers.interopDefault(_airplayMix);
var _qualityMix = require("./qualityMix");
var _qualityMixDefault = parcelHelpers.interopDefault(_qualityMix);
var _optionInit = require("./optionInit");
var _optionInitDefault = parcelHelpers.interopDefault(_optionInit);
var _eventInit = require("./eventInit");
var _eventInitDefault = parcelHelpers.interopDefault(_eventInit);
class Player {
    constructor(art){
        (0, _urlMixDefault.default)(art);
        (0, _attrMixDefault.default)(art);
        (0, _playMixDefault.default)(art);
        (0, _pauseMixDefault.default)(art);
        (0, _toggleMixDefault.default)(art);
        (0, _seekMixDefault.default)(art);
        (0, _volumeMixDefault.default)(art);
        (0, _currentTimeMixDefault.default)(art);
        (0, _durationMixDefault.default)(art);
        (0, _switchMixDefault.default)(art);
        (0, _playbackRateMixDefault.default)(art);
        (0, _aspectRatioMixDefault.default)(art);
        (0, _screenshotMixDefault.default)(art);
        (0, _fullscreenMixDefault.default)(art);
        (0, _fullscreenWebMixDefault.default)(art);
        (0, _pipMixDefault.default)(art);
        (0, _loadedMixDefault.default)(art);
        (0, _playedMixDefault.default)(art);
        (0, _playingMixDefault.default)(art);
        (0, _autoSizeMixDefault.default)(art);
        (0, _rectMixDefault.default)(art);
        (0, _flipMixDefault.default)(art);
        (0, _miniMixDefault.default)(art);
        (0, _posterMixDefault.default)(art);
        (0, _autoHeightMixDefault.default)(art);
        (0, _cssVarMixDefault.default)(art);
        (0, _themeMixDefault.default)(art);
        (0, _typeMixDefault.default)(art);
        (0, _stateMixDefault.default)(art);
        (0, _subtitleOffsetMixDefault.default)(art);
        (0, _airplayMixDefault.default)(art);
        (0, _qualityMixDefault.default)(art);
        (0, _eventInitDefault.default)(art);
        (0, _optionInitDefault.default)(art);
    }
}
exports.default = Player;

},{"./urlMix":"haOhz","./attrMix":"cSnpy","./playMix":"ftnB3","./pauseMix":"kDy9r","./toggleMix":"12BL6","./seekMix":"8x3vZ","./volumeMix":"lsF5V","./currentTimeMix":"75HaL","./durationMix":"5Ud6d","./switchMix":"emcjh","./playbackRateMix":"78DYM","./aspectRatioMix":"chjHL","./screenshotMix":"jDAYl","./fullscreenMix":"juJAD","./fullscreenWebMix":"5f725","./pipMix":"jWhCt","./loadedMix":"jhDPX","./playedMix":"3bU8P","./playingMix":"5Ctiw","./autoSizeMix":"6fRkJ","./rectMix":"lOJRK","./flipMix":"fSa7B","./miniMix":"fy4qC","./posterMix":"lglHp","./autoHeightMix":"58Y02","./cssVarMix":"fPbnY","./themeMix":"lga3g","./typeMix":"dnAFx","./stateMix":"8mwXw","./subtitleOffsetMix":"4Ny6z","./airplayMix":"gcYqJ","./qualityMix":"1L7ST","./optionInit":"vGIPW","./eventInit":"5D1O8","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"haOhz":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>urlMix);
var _utils = require("../utils");
function urlMix(art) {
    const { option, template: { $video, $videoCut } } = art;
    (0, _utils.def)(art, "url", {
        get () {
            return $video.src;
        },
        async set (newUrl) {
            if (newUrl) {
                const oldUrl = art.url;
                const typeName = option.type || (0, _utils.getExt)(newUrl);
                const typeCallback = option.customType[typeName];
                const typeCallbackCut = option.customType[typeName + "_cut"];
                if (typeName && typeCallback) {
                    await (0, _utils.sleep)();
                    art.loading.show = true;
                    typeCallback.call(art, $video, newUrl, art);
                    typeCallbackCut.call(art, $videoCut, newUrl, art);
                } else {
                    URL.revokeObjectURL(oldUrl);
                    $video.src = newUrl;
                    $videoCut.src = newUrl;
                }
                if (oldUrl !== art.url) {
                    art.option.url = newUrl;
                    if (art.isReady && oldUrl) art.once("video:canplay", ()=>{
                        art.emit("restart", newUrl);
                    });
                }
            } else {
                await (0, _utils.sleep)();
                art.loading.show = true;
            }
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"cSnpy":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>attrMix);
var _utils = require("../utils");
function attrMix(art) {
    const { template: { $video } } = art;
    (0, _utils.def)(art, "attr", {
        value (key, value) {
            if (value === undefined) return $video[key];
            $video[key] = value;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"ftnB3":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playMix);
var _utils = require("../utils");
function playMix(art) {
    const { i18n, notice, option, constructor: { instances }, template: { $video } } = art;
    (0, _utils.def)(art, "play", {
        value: async function() {
            const result = await $video.play();
            notice.show = i18n.get("Play");
            art.emit("play");
            if (option.mutex) for(let index = 0; index < instances.length; index++){
                const instance = instances[index];
                if (instance !== art) instance.pause();
            }
            return result;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"kDy9r":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>pauseMix);
var _utils = require("../utils");
function pauseMix(art) {
    const { template: { $video }, i18n, notice } = art;
    (0, _utils.def)(art, "pause", {
        value () {
            const result = $video.pause();
            notice.show = i18n.get("Pause");
            art.emit("pause");
            return result;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"12BL6":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>toggleMix);
var _utils = require("../utils");
function toggleMix(art) {
    (0, _utils.def)(art, "toggle", {
        value () {
            if (art.playing) return art.pause();
            else return art.play();
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"8x3vZ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>seekMix);
var _utils = require("../utils");
function seekMix(art) {
    const { notice } = art;
    (0, _utils.def)(art, "seek", {
        set (time) {
            art.currentTime = time;
            art.emit("seek", art.currentTime);
            if (art.duration) notice.show = `${(0, _utils.secondToTime)(art.currentTime)} / ${(0, _utils.secondToTime)(art.duration)}`;
        }
    });
    (0, _utils.def)(art, "forward", {
        set (time) {
            art.seek = art.currentTime + time;
        }
    });
    (0, _utils.def)(art, "backward", {
        set (time) {
            art.seek = art.currentTime - time;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lsF5V":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>volumeMix);
var _utils = require("../utils");
function volumeMix(art) {
    const { template: { $video }, i18n, notice, storage } = art;
    (0, _utils.def)(art, "volume", {
        get: ()=>$video.volume || 0,
        set: (percentage)=>{
            $video.volume = (0, _utils.clamp)(percentage, 0, 1);
            notice.show = `${i18n.get("Volume")}: ${parseInt($video.volume * 100, 10)}`;
            if ($video.volume !== 0) storage.set("volume", $video.volume);
        }
    });
    (0, _utils.def)(art, "muted", {
        get: ()=>$video.muted,
        set: (muted)=>{
            $video.muted = muted;
            art.emit("muted", muted);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"75HaL":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>currentTimeMix);
var _utils = require("../utils");
function currentTimeMix(art) {
    const { $video } = art.template;
    (0, _utils.def)(art, "currentTime", {
        get: ()=>$video.currentTime || 0,
        set: (time)=>{
            time = parseFloat(time);
            if (Number.isNaN(time)) return;
            $video.currentTime = (0, _utils.clamp)(time, 0, art.duration);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"5Ud6d":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>durationMix);
var _utils = require("../utils");
function durationMix(art) {
    (0, _utils.def)(art, "duration", {
        get: ()=>{
            const { duration } = art.template.$video;
            if (duration === Infinity) return 0;
            return duration || 0;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"emcjh":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>switchMix);
var _utils = require("../utils");
function switchMix(art) {
    function switchUrl(url, currentTime) {
        return new Promise((resolve, reject)=>{
            if (url === art.url) return;
            const { playing, aspectRatio,storage } = art;
            art.pause();
            if (url && url.endsWith("m3u8")) {
                art.option.customType = {
                    m3u8: Artplayer.playM3u8,
                    m3u8_cut: Artplayer.playM3u8Cut
                }
            }
            art.url = url;
            var playbackRate = storage.getDefault("playbackRate", 1);
            art.notice.show = "";
            art.once("video:error", reject);
            art.once("video:loadedmetadata", ()=>{
                art.currentTime = currentTime;
            });
            art.once("video:canplay", async ()=>{
                art.playbackRate = playbackRate;
                art.aspectRatio = aspectRatio;
                if (playing) await art.play();
                art.notice.show = "";
                resolve();
            });
        });
    }
    (0, _utils.def)(art, "switchQuality", {
        value: (url)=>{
            return switchUrl(url, art.currentTime);
        }
    });
    (0, _utils.def)(art, "switchUrl", {
        value: (url)=>{
            return switchUrl(url, 0);
        }
    });
    (0, _utils.def)(art, "switch", {
        set: art.switchUrl
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"78DYM":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playbackRateMix);
var _utils = require("../utils");
function playbackRateMix(art) {
    const { template: { $video }, i18n, notice } = art;
    (0, _utils.def)(art, "playbackRate", {
        get () {
            return $video.playbackRate;
        },
        set (rate) {
            if (rate) {
                if (rate === $video.playbackRate) return;
                $video.playbackRate = rate;
                notice.show = `${i18n.get("Rate")}: ${rate === 1.0 ? i18n.get("Normal") : `${rate}x`}`;
            } else {
                art.playbackRate = 1;
            }
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"chjHL":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>aspectRatioMix);
var _utils = require("../utils");
function aspectRatioMix(art) {
    const { i18n, notice, template: { $video, $player } } = art;
    (0, _utils.def)(art, "aspectRatio", {
        get () {
            return $player.dataset.aspectRatio || "default";
        },
        set (ratio) {
            if (!ratio) ratio = "default";
            if (ratio === "default") {
                (0, _utils.setStyle)($video, "width", null);
                (0, _utils.setStyle)($video, "height", null);
                (0, _utils.setStyle)($video, "margin", null);
                delete $player.dataset.aspectRatio;
            } else {
                const ratioArray = ratio.split(":").map(Number);
                const { clientWidth, clientHeight } = $player;
                const playerRatio = clientWidth / clientHeight;
                const setupRatio = ratioArray[0] / ratioArray[1];
                if (playerRatio > setupRatio) {
                    (0, _utils.setStyle)($video, "width", `${setupRatio * clientHeight}px`);
                    (0, _utils.setStyle)($video, "height", "100%");
                    (0, _utils.setStyle)($video, "margin", "0 auto");
                } else {
                    (0, _utils.setStyle)($video, "width", "100%");
                    (0, _utils.setStyle)($video, "height", `${clientWidth / setupRatio}px`);
                    (0, _utils.setStyle)($video, "margin", "auto 0");
                }
                $player.dataset.aspectRatio = ratio;
            }
            notice.show = `${i18n.get("Aspect Ratio")}: ${ratio === "default" ? i18n.get("Default") : ratio}`;
            art.emit("aspectRatio", ratio);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jDAYl":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>screenshotMix);
var _utils = require("../utils");
function screenshotMix(art) {
    const { notice, template: { $video } } = art;
    const $canvas = (0, _utils.createElement)("canvas");
    (0, _utils.def)(art, "getDataURL", {
        value: ()=>new Promise((resolve, reject)=>{
                try {
                    $canvas.width = $video.videoWidth;
                    $canvas.height = $video.videoHeight;
                    $canvas.getContext("2d").drawImage($video, 0, 0);
                    resolve($canvas.toDataURL("image/png"));
                } catch (err) {
                    notice.show = err;
                    reject(err);
                }
            })
    });
    (0, _utils.def)(art, "getBlobUrl", {
        value: ()=>new Promise((resolve, reject)=>{
                try {
                    $canvas.width = $video.videoWidth;
                    $canvas.height = $video.videoHeight;
                    $canvas.getContext("2d").drawImage($video, 0, 0);
                    $canvas.toBlob((blob)=>{
                        resolve(URL.createObjectURL(blob));
                    });
                } catch (err) {
                    notice.show = err;
                    reject(err);
                }
            })
    });
    (0, _utils.def)(art, "screenshot", {
        value: async ()=>{
            const dataUri = await art.getDataURL();
            (0, _utils.download)(dataUri, `artplayer_${(0, _utils.secondToTime)($video.currentTime)}.png`);
            art.emit("screenshot", dataUri);
            return dataUri;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"juJAD":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>fullscreenMix);
var _screenfull = require("../libs/screenfull");
var _screenfullDefault = parcelHelpers.interopDefault(_screenfull);
var _utils = require("../utils");
function fullscreenMix(art) {
    const { i18n, notice, template: { $video, $player } } = art;
    const nativeScreenfull = (art)=>{
        (0, _screenfullDefault.default).on("change", ()=>{
            art.emit("fullscreen", (0, _screenfullDefault.default).isFullscreen);
        });
        (0, _screenfullDefault.default).on("error", (event)=>{
            art.emit("fullscreenError", event);
        });
        (0, _utils.def)(art, "fullscreen", {
            get () {
                return (0, _screenfullDefault.default).isFullscreen;
            },
            async set (value) {
                if (value) {
                    art.state = "fullscreen";
                    await (0, _screenfullDefault.default).request($player);
                    (0, _utils.addClass)($player, "art-fullscreen");
                } else {
                    await (0, _screenfullDefault.default).exit();
                    (0, _utils.removeClass)($player, "art-fullscreen");
                }
                art.emit("resize");
            }
        });
    };
    const webkitScreenfull = (art)=>{
        art.proxy(document, "webkitfullscreenchange", ()=>{
            art.emit("fullscreen", art.fullscreen);
            art.emit("resize");
        });
        (0, _utils.def)(art, "fullscreen", {
            get () {
                return document.fullscreenElement === $video;
            },
            set (value) {
                if (value) {
                    art.state = "fullscreen";
                    $video.webkitEnterFullscreen();
                } else $video.webkitExitFullscreen();
            }
        });
    };
    art.once("video:loadedmetadata", ()=>{
        if ((0, _screenfullDefault.default).isEnabled) nativeScreenfull(art);
        else if ($video.webkitSupportsFullscreen) webkitScreenfull(art);
        else (0, _utils.def)(art, "fullscreen", {
            get () {
                return false;
            },
            set () {
                notice.show = i18n.get("Fullscreen Not Supported");
            }
        });
        // Asynchronous setting
        (0, _utils.def)(art, "fullscreen", (0, _utils.get)(art, "fullscreen"));
    });
}

},{"../libs/screenfull":"4XLC7","../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4XLC7":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
const methodMap = [
    [
        "requestFullscreen",
        "exitFullscreen",
        "fullscreenElement",
        "fullscreenEnabled",
        "fullscreenchange",
        "fullscreenerror"
    ],
    // New WebKit
    [
        "webkitRequestFullscreen",
        "webkitExitFullscreen",
        "webkitFullscreenElement",
        "webkitFullscreenEnabled",
        "webkitfullscreenchange",
        "webkitfullscreenerror"
    ],
    // Old WebKit
    [
        "webkitRequestFullScreen",
        "webkitCancelFullScreen",
        "webkitCurrentFullScreenElement",
        "webkitCancelFullScreen",
        "webkitfullscreenchange",
        "webkitfullscreenerror"
    ],
    [
        "mozRequestFullScreen",
        "mozCancelFullScreen",
        "mozFullScreenElement",
        "mozFullScreenEnabled",
        "mozfullscreenchange",
        "mozfullscreenerror"
    ],
    [
        "msRequestFullscreen",
        "msExitFullscreen",
        "msFullscreenElement",
        "msFullscreenEnabled",
        "MSFullscreenChange",
        "MSFullscreenError"
    ]
];
const nativeAPI = (()=>{
    if (typeof document === "undefined") return false;
    const unprefixedMethods = methodMap[0];
    const returnValue = {};
    for (const methodList of methodMap){
        const exitFullscreenMethod = methodList[1];
        if (exitFullscreenMethod in document) {
            for (const [index, method] of methodList.entries())returnValue[unprefixedMethods[index]] = method;
            return returnValue;
        }
    }
    return false;
})();
const eventNameMap = {
    change: nativeAPI.fullscreenchange,
    error: nativeAPI.fullscreenerror
};
let screenfull = {
    request (element = document.documentElement, options) {
        return new Promise((resolve, reject)=>{
            const onFullScreenEntered = ()=>{
                screenfull.off("change", onFullScreenEntered);
                resolve();
            };
            screenfull.on("change", onFullScreenEntered);
            const returnPromise = element[nativeAPI.requestFullscreen](options);
            if (returnPromise instanceof Promise) returnPromise.then(onFullScreenEntered).catch(reject);
        });
    },
    exit () {
        return new Promise((resolve, reject)=>{
            if (!screenfull.isFullscreen) {
                resolve();
                return;
            }
            const onFullScreenExit = ()=>{
                screenfull.off("change", onFullScreenExit);
                resolve();
            };
            screenfull.on("change", onFullScreenExit);
            const returnPromise = document[nativeAPI.exitFullscreen]();
            if (returnPromise instanceof Promise) returnPromise.then(onFullScreenExit).catch(reject);
        });
    },
    toggle (element, options) {
        return screenfull.isFullscreen ? screenfull.exit() : screenfull.request(element, options);
    },
    onchange (callback) {
        screenfull.on("change", callback);
    },
    onerror (callback) {
        screenfull.on("error", callback);
    },
    on (event, callback) {
        const eventName = eventNameMap[event];
        if (eventName) document.addEventListener(eventName, callback, false);
    },
    off (event, callback) {
        const eventName = eventNameMap[event];
        if (eventName) document.removeEventListener(eventName, callback, false);
    },
    raw: nativeAPI
};
Object.defineProperties(screenfull, {
    isFullscreen: {
        get: ()=>Boolean(document[nativeAPI.fullscreenElement])
    },
    element: {
        enumerable: true,
        get: ()=>document[nativeAPI.fullscreenElement]
    },
    isEnabled: {
        enumerable: true,
        get: ()=>Boolean(document[nativeAPI.fullscreenEnabled])
    }
});
if (!nativeAPI) screenfull = {
    isEnabled: false
};
exports.default = screenfull;

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"5f725":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>fullscreenWebMix);
var _utils = require("../utils");
function fullscreenWebMix(art) {
    const { constructor, template: { $container, $player } } = art;
    let cssText = "";
    (0, _utils.def)(art, "fullscreenWeb", {
        get () {
            return (0, _utils.hasClass)($player, "art-fullscreen-web");
        },
        set (value) {
            if (value) {
                cssText = $player.style.cssText;
                if (constructor.FULLSCREEN_WEB_IN_BODY) (0, _utils.append)(document.body, $player);
                art.state = "fullscreenWeb";
                (0, _utils.setStyle)($player, "width", "100%");
                (0, _utils.setStyle)($player, "height", "100%");
                (0, _utils.addClass)($player, "art-fullscreen-web");
                art.emit("fullscreenWeb", true);
            } else {
                if (constructor.FULLSCREEN_WEB_IN_BODY) (0, _utils.append)($container, $player);
                if (cssText) {
                    $player.style.cssText = cssText;
                    cssText = "";
                }
                (0, _utils.removeClass)($player, "art-fullscreen-web");
                art.emit("fullscreenWeb", false);
            }
            art.emit("resize");
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jWhCt":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>pipMix);
var _utils = require("../utils");
function nativePip(art) {
    const { template: { $video }, proxy, notice } = art;
    $video.disablePictureInPicture = false;
    (0, _utils.def)(art, "pip", {
        get () {
            return document.pictureInPictureElement;
        },
        set (value) {
            if (value) {
                art.state = "pip";
                $video.requestPictureInPicture().catch((err)=>{
                    notice.show = err;
                    throw err;
                });
            } else document.exitPictureInPicture().catch((err)=>{
                notice.show = err;
                throw err;
            });
        }
    });
    proxy($video, "enterpictureinpicture", ()=>{
        art.emit("pip", true);
    });
    proxy($video, "leavepictureinpicture", ()=>{
        art.emit("pip", false);
    });
}
function webkitPip(art) {
    const { $video } = art.template;
    $video.webkitSetPresentationMode("inline");
    (0, _utils.def)(art, "pip", {
        get () {
            return $video.webkitPresentationMode === "picture-in-picture";
        },
        set (value) {
            if (value) {
                art.state = "pip";
                $video.webkitSetPresentationMode("picture-in-picture");
                art.emit("pip", true);
            } else {
                $video.webkitSetPresentationMode("inline");
                art.emit("pip", false);
            }
        }
    });
}
function pipMix(art) {
    const { i18n, notice, template: { $video } } = art;
    if (document.pictureInPictureEnabled) nativePip(art);
    else if ($video.webkitSupportsPresentationMode) webkitPip(art);
    else (0, _utils.def)(art, "pip", {
        get () {
            return false;
        },
        set () {
            notice.show = i18n.get("PIP Not Supported");
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jhDPX":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>seekMix);
var _utils = require("../utils");
function seekMix(art) {
    const { $video } = art.template;
    (0, _utils.def)(art, "loaded", {
        get: ()=>art.loadedTime / $video.duration
    });
    (0, _utils.def)(art, "loadedTime", {
        get: ()=>$video.buffered.length ? $video.buffered.end($video.buffered.length - 1) : 0
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"3bU8P":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playedMix);
var _utils = require("../utils");
function playedMix(art) {
    (0, _utils.def)(art, "played", {
        get: ()=>art.currentTime / art.duration
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"5Ctiw":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playingMix);
var _utils = require("../utils");
function playingMix(art) {
    const { $video } = art.template;
    (0, _utils.def)(art, "playing", {
        get: ()=>!!($video.currentTime > 0 && !$video.paused && !$video.ended && $video.readyState > 2)
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6fRkJ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>resizeMix);
var _utils = require("../utils");
function resizeMix(art) {
    const { $container, $player, $video } = art.template;
    (0, _utils.def)(art, "autoSize", {
        value () {
            const { videoWidth, videoHeight } = $video;
            const { width, height } = (0, _utils.getRect)($container);
            const videoRatio = videoWidth / videoHeight;
            const containerRatio = width / height;
            if (containerRatio > videoRatio) {
                const percentage = height * videoRatio / width * 100;
                (0, _utils.setStyle)($player, "width", `${percentage}%`);
                (0, _utils.setStyle)($player, "height", "100%");
            } else {
                const percentage = width / videoRatio / height * 100;
                (0, _utils.setStyle)($player, "width", "100%");
                (0, _utils.setStyle)($player, "height", `${percentage}%`);
            }
            art.emit("autoSize", {
                width: art.width,
                height: art.height
            });
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lOJRK":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>rectMix);
var _utils = require("../utils");
function rectMix(art) {
    (0, _utils.def)(art, "rect", {
        get: ()=>{
            return (0, _utils.getRect)(art.template.$player);
        }
    });
    const keys = [
        "bottom",
        "height",
        "left",
        "right",
        "top",
        "width"
    ];
    for(let index = 0; index < keys.length; index++){
        const key = keys[index];
        (0, _utils.def)(art, key, {
            get: ()=>{
                return art.rect[key];
            }
        });
    }
    (0, _utils.def)(art, "x", {
        get: ()=>{
            return art.left + window.pageXOffset;
        }
    });
    (0, _utils.def)(art, "y", {
        get: ()=>{
            return art.top + window.pageYOffset;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"fSa7B":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>flipMix);
var _utils = require("../utils");
function flipMix(art) {
    const { template: { $player }, i18n, notice } = art;
    (0, _utils.def)(art, "flip", {
        get () {
            return $player.dataset.flip || "normal";
        },
        set (flip) {
            if (!flip) flip = "normal";
            if (flip === "normal") delete $player.dataset.flip;
            else $player.dataset.flip = flip;
            notice.show = `${i18n.get("Video Flip")}: ${i18n.get((0, _utils.capitalize)(flip))}`;
            art.emit("flip", flip);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"fy4qC":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>miniMix);
var _utils = require("../utils");
function miniMix(art) {
    const { icons, proxy, storage, template: { $player, $video } } = art;
    let isDroging = false;
    let lastPageX = 0;
    let lastPageY = 0;
    function hideMini() {
        const { $mini } = art.template;
        if ($mini) {
            (0, _utils.removeClass)($player, "art-mini");
            (0, _utils.setStyle)($mini, "display", "none");
            $player.prepend($video);
            art.emit("mini", false);
        }
    }
    function initState($play, $pause) {
        if (art.playing) {
            (0, _utils.setStyle)($play, "display", `none`);
            (0, _utils.setStyle)($pause, "display", `flex`);
        } else {
            (0, _utils.setStyle)($play, "display", `flex`);
            (0, _utils.setStyle)($pause, "display", `none`);
        }
    }
    function createMini() {
        const { $mini } = art.template;
        if ($mini) {
            (0, _utils.append)($mini, $video);
            return (0, _utils.setStyle)($mini, "display", "flex");
        } else {
            const $mini = (0, _utils.createElement)("div");
            (0, _utils.addClass)($mini, "art-mini-popup");
            (0, _utils.append)(document.body, $mini);
            art.template.$mini = $mini;
            (0, _utils.append)($mini, $video);
            const $close = (0, _utils.append)($mini, `<div class="art-mini-close"></div>`);
            (0, _utils.append)($close, icons.close);
            proxy($close, "click", hideMini);
            const $state = (0, _utils.append)($mini, `<div class="art-mini-state"></div>`);
            const $play = (0, _utils.append)($state, icons.play);
            const $pause = (0, _utils.append)($state, icons.pause);
            proxy($play, "click", ()=>art.play());
            proxy($pause, "click", ()=>art.pause());
            initState($play, $pause);
            art.on("video:playing", ()=>initState($play, $pause));
            art.on("video:pause", ()=>initState($play, $pause));
            art.on("video:timeupdate", ()=>initState($play, $pause));
            proxy($mini, "mousedown", (event)=>{
                isDroging = event.button === 0;
                lastPageX = event.pageX;
                lastPageY = event.pageY;
            });
            art.on("document:mousemove", (event)=>{
                if (isDroging) {
                    (0, _utils.addClass)($mini, "art-mini-droging");
                    const x = event.pageX - lastPageX;
                    const y = event.pageY - lastPageY;
                    (0, _utils.setStyle)($mini, "transform", `translate(${x}px, ${y}px)`);
                }
            });
            art.on("document:mouseup", ()=>{
                if (isDroging) {
                    isDroging = false;
                    (0, _utils.removeClass)($mini, "art-mini-droging");
                    const rect = (0, _utils.getRect)($mini);
                    storage.set("left", rect.left);
                    storage.set("top", rect.top);
                    (0, _utils.setStyle)($mini, "left", `${rect.left}px`);
                    (0, _utils.setStyle)($mini, "top", `${rect.top}px`);
                    (0, _utils.setStyle)($mini, "transform", null);
                }
            });
            return $mini;
        }
    }
    function initMini() {
        const { $mini } = art.template;
        const rect = (0, _utils.getRect)($mini);
        const top = window.innerHeight - rect.height - 50;
        const left = window.innerWidth - rect.width - 50;
        storage.set("top", top);
        storage.set("left", left);
        (0, _utils.setStyle)($mini, "top", `${top}px`);
        (0, _utils.setStyle)($mini, "left", `${left}px`);
    }
    (0, _utils.def)(art, "mini", {
        get () {
            return (0, _utils.hasClass)($player, "art-mini");
        },
        set (value) {
            if (value) {
                art.state = "mini";
                (0, _utils.addClass)($player, "art-mini");
                const $mini = createMini();
                const top = storage.get("top");
                const left = storage.get("left");
                if (top && left) {
                    (0, _utils.setStyle)($mini, "top", `${top}px`);
                    (0, _utils.setStyle)($mini, "left", `${left}px`);
                    if (!(0, _utils.isInViewport)($mini)) initMini();
                } else initMini();
                art.emit("mini", true);
            } else hideMini();
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lglHp":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>posterMix);
var _utils = require("../utils");
function posterMix(art) {
    const { template: { $poster } } = art;
    (0, _utils.def)(art, "poster", {
        get: ()=>{
            try {
                return $poster.style["backgroundImage"].match(/"(.*)"/)[1];
            // eslint-disable-next-line no-unused-vars
            } catch (error) {
                return "";
            }
        },
        set (url) {
            (0, _utils.setStyle)($poster, "backgroundImage", `url(${url})`);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"58Y02":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>autoHeightMix);
var _utils = require("../utils");
function autoHeightMix(art) {
    const { template: { $container, $video } } = art;
    (0, _utils.def)(art, "autoHeight", {
        value () {
            const { clientWidth } = $container;
            const { videoHeight, videoWidth } = $video;
            const height = videoHeight * (clientWidth / videoWidth);
            (0, _utils.setStyle)($container, "height", height + "px");
            art.emit("autoHeight", height);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"fPbnY":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>cssVarMix);
var _utils = require("../utils");
function cssVarMix(art) {
    const { $player } = art.template;
    (0, _utils.def)(art, "cssVar", {
        value (key, value) {
            if (value) return $player.style.setProperty(key, value);
            else return getComputedStyle($player).getPropertyValue(key);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lga3g":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>themeMix);
var _utils = require("../utils");
function themeMix(art) {
    (0, _utils.def)(art, "theme", {
        get () {
            return art.cssVar("--art-theme");
        },
        set (theme) {
            art.cssVar("--art-theme", theme);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"dnAFx":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>typeMix);
var _utils = require("../utils");
function typeMix(art) {
    (0, _utils.def)(art, "type", {
        get () {
            return art.option.type;
        },
        set (type) {
            art.option.type = type;
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"8mwXw":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>stateMix);
var _utils = require("../utils");
function stateMix(art) {
    const states = [
        "mini",
        "pip",
        "fullscreen",
        "fullscreenWeb"
    ];
    (0, _utils.def)(art, "state", {
        get: ()=>states.find((name)=>art[name]) || "standard",
        set (name) {
            for(let index = 0; index < states.length; index++){
                const prop = states[index];
                if (prop !== name && art[prop]) art[prop] = false;
            }
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4Ny6z":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>subtitleOffsetMix);
var _utils = require("../utils");
function subtitleOffsetMix(art) {
    const { clamp } = art.constructor.utils;
    const { notice, template, i18n } = art;
    let offsetCache = 0;
    let cuesCache = [];
    art.on("subtitle:switch", ()=>{
        cuesCache = [];
    });
    (0, _utils.def)(art, "subtitleOffset", {
        get () {
            return offsetCache;
        },
        set (value) {
            if (template.$track && template.$track.track) {
                const cues = Array.from(template.$track.track.cues);
                offsetCache = clamp(value, -5, 5);
                for(let index = 0; index < cues.length; index++){
                    const cue = cues[index];
                    if (!cuesCache[index]) cuesCache[index] = {
                        startTime: cue.startTime,
                        endTime: cue.endTime
                    };
                    cue.startTime = clamp(cuesCache[index].startTime + offsetCache, 0, art.duration);
                    cue.endTime = clamp(cuesCache[index].endTime + offsetCache, 0, art.duration);
                }
                art.subtitle.update();
                notice.show = `${i18n.get("Subtitle Offset")}: ${value}s`;
                art.emit("subtitleOffset", value);
            } else art.emit("subtitleOffset", 0);
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"gcYqJ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>airplayMix);
var _utils = require("../utils");
function airplayMix(art) {
    const { i18n, notice, proxy, template: { $video } } = art;
    let available = true;
    if (window.WebKitPlaybackTargetAvailabilityEvent && $video.webkitShowPlaybackTargetPicker) proxy($video, "webkitplaybacktargetavailabilitychanged", (event)=>{
        switch(event.availability){
            case "available":
                available = true;
                break;
            case "not-available":
                available = false;
                break;
        }
    });
    else available = false;
    (0, _utils.def)(art, "airplay", {
        value () {
            if (available) {
                $video.webkitShowPlaybackTargetPicker();
                art.emit("airplay");
            } else notice.show = i18n.get("AirPlay Not Available");
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1L7ST":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>qualityMix);
var _utils = require("../utils");
function qualityMix(art) {
    (0, _utils.def)(art, "quality", {
        set (quality) {
            const { controls, notice, i18n } = art;
            const qualityDefault = quality.find((item)=>item.default) || quality[0];
            controls.update({
                name: "quality",
                position: "right",
                index: 10,
                style: {
                    marginRight: "10px"
                },
                html: qualityDefault ? qualityDefault.html : "",
                selector: quality,
                async onSelect (item) {
                    await art.switchQuality(item.url);
                    notice.show = `${i18n.get("Switch Video")}: ${item.html}`;
                }
            });
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"vGIPW":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>attrInit);
var _utils = require("../utils");
function attrInit(art) {
    const { option, storage, template: { $video, $poster } } = art;
    for(const key in option.moreVideoAttr)art.attr(key, option.moreVideoAttr[key]);
    if (option.muted) art.muted = option.muted;
    if (option.volume) $video.volume = (0, _utils.clamp)(option.volume, 0, 1);
    const volumeStorage = storage.get("volume");
    if (typeof volumeStorage === "number") $video.volume = (0, _utils.clamp)(volumeStorage, 0, 1);
    if (option.poster) (0, _utils.setStyle)($poster, "backgroundImage", `url(${option.poster})`);
    if (option.autoplay) $video.autoplay = option.autoplay;
    if (option.playsInline) {
        $video.playsInline = true;
        $video["webkit-playsinline"] = true;
    }
    if (option.theme) option.cssVar["--art-theme"] = option.theme;
    for(const key in option.cssVar)art.cssVar(key, option.cssVar[key]);
    art.url = option.url;
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"5D1O8":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>eventInit);
var _config = require("../config");
var _configDefault = parcelHelpers.interopDefault(_config);
var _utils = require("../utils");
function eventInit(art) {
    const { i18n, notice, option, constructor, proxy, template: { $player, $video, $poster } } = art;
    let reconnectTime = 0;
    for(let index = 0; index < (0, _configDefault.default).events.length; index++)proxy($video, (0, _configDefault.default).events[index], (event)=>{
        art.emit(`video:${event.type}`, event);
    });
    // art.on('video:abort', () => {
    // });
    art.on("video:canplay", ()=>{
        reconnectTime = 0;
        art.loading.show = false;
    });
    art.once("video:canplay", ()=>{
        art.loading.show = false;
        art.controls.show = true;
        art.mask.show = true;
        art.isReady = true;
        art.emit("ready");
    });
    // art.on('video:canplaythrough', () => {
    // });
    // art.on('video:durationchange', () => {
    // });
    // art.on('video:emptied', () => {
    // });
    art.on("video:ended", ()=>{
        if (option.loop) {
            art.seek = 0;
            art.play();
            art.controls.show = false;
            art.mask.show = false;
        } else {
            art.controls.show = true;
            art.mask.show = true;
        }
    });
    art.on("video:error", async (error)=>{
        if (reconnectTime < constructor.RECONNECT_TIME_MAX) {
            await (0, _utils.sleep)(constructor.RECONNECT_SLEEP_TIME);
            reconnectTime += 1;
            art.url = option.url;
            notice.show = `${i18n.get("Reconnect")}: ${reconnectTime}`;
            art.emit("error", error, reconnectTime);
        } else {
            art.mask.show = true;
            art.loading.show = false;
            art.controls.show = true;
            (0, _utils.addClass)($player, "art-error");
            await (0, _utils.sleep)(constructor.RECONNECT_SLEEP_TIME);
            notice.show = i18n.get("Video Load Failed");
        }
    });
    // art.on('video:loadeddata', () => {
    // });
    art.on("video:loadedmetadata", ()=>{
        art.emit("resize");
        if (0, _utils.isMobile) {
            art.loading.show = false;
            art.controls.show = true;
            art.mask.show = true;
        }
    });
    art.on("video:loadstart", ()=>{
        art.loading.show = true;
        art.mask.show = false;
        art.controls.show = true;
    });
    art.on("video:pause", ()=>{
        art.controls.show = true;
        art.mask.show = true;
    });
    art.on("video:play", ()=>{
        art.mask.show = false;
        (0, _utils.setStyle)($poster, "display", "none");
    });
    art.on("video:playing", ()=>{
        art.mask.show = false;
    });
    art.on("video:progress", ()=>{
        if (art.playing) art.loading.show = false;
    });
    // art.on('video:ratechange', () => {
    // });
    art.on("video:seeked", ()=>{
        art.loading.show = false;
        art.mask.show = true;
    });
    art.on("video:seeking", ()=>{
        art.loading.show = true;
        art.mask.show = false;
    });
    // art.on('video:stalled', () => {
    // });
    // art.on('video:suspend', () => {
    // });
    art.on("video:timeupdate", ()=>{
        art.mask.show = false;
    });
    // art.on('video:volumechange', () => {
    // });
    art.on("video:waiting", ()=>{
        art.loading.show = true;
        art.mask.show = false;
    });
}

},{"../config":"1hSww","../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"nK2ZQ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("../utils");
var _component = require("../utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
var _fullscreen = require("./fullscreen");
var _fullscreenDefault = parcelHelpers.interopDefault(_fullscreen);
var _speed = require("./speed");
var _speedDefault = parcelHelpers.interopDefault(_speed);
var _fullscreenWeb = require("./fullscreenWeb");
var _fullscreenWebDefault = parcelHelpers.interopDefault(_fullscreenWeb);
var _pip = require("./pip");
var _pipDefault = parcelHelpers.interopDefault(_pip);
var _playAndPause = require("./playAndPause");
var _playAndPauseDefault = parcelHelpers.interopDefault(_playAndPause);
var _progress = require("./progress");
var _progressDefault = parcelHelpers.interopDefault(_progress);
var _time = require("./time");
var _timeDefault = parcelHelpers.interopDefault(_time);
var _volume = require("./volume");
var _volumeDefault = parcelHelpers.interopDefault(_volume);
var _setting = require("./setting");
var _settingDefault = parcelHelpers.interopDefault(_setting);
var _thumbnails = require("./thumbnails");
var _thumbnailsDefault = parcelHelpers.interopDefault(_thumbnails);
var _screenshot = require("./screenshot");
var _screenshotDefault = parcelHelpers.interopDefault(_screenshot);
var _airplay = require("./airplay");
var _airplayDefault = parcelHelpers.interopDefault(_airplay);
class Control extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.isHover = false;
        this.name = "control";
        this.timer = Date.now();
        const { constructor } = art;
        const { $player, $bottom } = this.art.template;
        art.on("mousemove", ()=>{
            if (!(0, _utils.isMobile)) this.show = true;
        });
        art.on("click", ()=>{
            if (0, _utils.isMobile) this.toggle();
            else this.show = true;
        });
        art.on("document:mousemove", (event)=>{
            this.isHover = (0, _utils.includeFromEvent)(event, $bottom);
        });
        art.on("video:timeupdate", ()=>{
            if (!art.setting.show && !this.isHover && !art.isInput && art.playing && this.show && Date.now() - this.timer >= constructor.CONTROL_HIDE_TIME) this.show = false;
        });
        art.on("control", (state)=>{
            if (state) {
                (0, _utils.removeClass)($player, "art-hide-cursor");
                (0, _utils.addClass)($player, "art-hover");
                this.timer = Date.now();
            } else {
                (0, _utils.addClass)($player, "art-hide-cursor");
                (0, _utils.removeClass)($player, "art-hover");
            }
        });
        this.init();
    }
    init() {
        const { option } = this.art;
        if (!option.isLive) this.add((0, _progressDefault.default)({
            name: "progress",
            position: "top",
            index: 10
        }));
        if (option.thumbnails.url && !option.isLive) this.add((0, _thumbnailsDefault.default)({
            name: "thumbnails",
            position: "top",
            index: 20
        }));
        this.add((0, _playAndPauseDefault.default)({
            name: "playAndPause",
            position: "left",
            index: 10
        }));
        this.add((0, _volumeDefault.default)({
            name: "volume",
            position: "left",
            index: 20
        }));
        if (!option.isLive) this.add((0, _timeDefault.default)({
            name: "time",
            position: "left",
            index: 30
        }));
        if (option.quality.length) (0, _utils.sleep)().then(()=>{
            this.art.quality = option.quality;
        });
        if (option.screenshot && !(0, _utils.isMobile)) this.add((0, _screenshotDefault.default)({
            name: "screenshot",
            position: "right",
            index: 20
        }));
        if (option.setting) this.add((0, _settingDefault.default)({
            name: "setting",
            position: "right",
            index: 30
        }));
        if (option.pip) this.add((0, _pipDefault.default)({
            name: "pip",
            position: "right",
            index: 40
        }));
        if (option.airplay && window.WebKitPlaybackTargetAvailabilityEvent) this.add((0, _airplayDefault.default)({
            name: "airplay",
            position: "right",
            index: 50
        }));
        if (option.fullscreenWeb) this.add((0, _fullscreenWebDefault.default)({
            name: "fullscreenWeb",
            position: "right",
            index: 60
        }));
        if (option.fullscreen) this.add((0, _fullscreenDefault.default)({
            name: "fullscreen",
            position: "right",
            index: 70
        }));
        if (option.speed) this.add((0, _speedDefault.default)({
            name: "speed",
            position: "right",
            index: 1
        }));

        for(let index = 0; index < option.controls.length; index++)this.add(option.controls[index]);
    }
    add(getOption) {
        const option = typeof getOption === "function" ? getOption(this.art) : getOption;
        const { $progress, $controlsLeft, $controlsRight } = this.art.template;
        switch(option.position){
            case "top":
                this.$parent = $progress;
                break;
            case "left":
                this.$parent = $controlsLeft;
                break;
            case "right":
                this.$parent = $controlsRight;
                break;
            default:
                (0, _utils.errorHandle)(false, `Control option.position must one of 'top', 'left', 'right'`);
                break;
        }
        super.add(option);
    }
}
exports.default = Control;

},{"../utils":"euhMG","../utils/component":"1UWqI","./fullscreen":"d7VBA","./speed":"d7VBS","./fullscreenWeb":"iE4ux","./pip":"03ERY","./playAndPause":"2tuF0","./progress":"afGEi","./time":"e6eX5","./volume":"ezhk3","./setting":"3Vg4s","./thumbnails":"8AAYm","./screenshot":"lcqMk","./airplay":"4dMTc","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1UWqI":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _dom = require("./dom");
var _format = require("./format");
var _error = require("./error");
var _optionValidator = require("option-validator");
var _optionValidatorDefault = parcelHelpers.interopDefault(_optionValidator);
var _scheme = require("../scheme");
class Component {
    constructor(art){
        this.id = 0;
        this.art = art;
        this.cache = new Map();
        this.add = this.add.bind(this);
        this.remove = this.remove.bind(this);
        this.update = this.update.bind(this);
    }
    get show() {
        return (0, _dom.hasClass)(this.art.template.$player, `art-${this.name}-show`);
    }
    set show(value) {
        const { $player } = this.art.template;
        const className = `art-${this.name}-show`;
        if (value) (0, _dom.addClass)($player, className);
        else (0, _dom.removeClass)($player, className);
        this.art.emit(this.name, value);
    }
    toggle() {
        this.show = !this.show;
    }
    add(getOption) {
        const option = typeof getOption === "function" ? getOption(this.art) : getOption;
        option.html = option.html || "";
        (0, _optionValidatorDefault.default)(option, (0, _scheme.ComponentOption));
        if (!this.$parent || !this.name || option.disable) return;
        const name = option.name || `${this.name}${this.id}`;
        const item = this.cache.get(name);
        (0, _error.errorHandle)(!item, `Can't add an existing [${name}] to the [${this.name}]`);
        this.id += 1;
        const $ref = (0, _dom.createElement)("div");
        (0, _dom.addClass)($ref, `art-${this.name}`);
        (0, _dom.addClass)($ref, `art-${this.name}-${name}`);
        const childs = Array.from(this.$parent.children);
        $ref.dataset.index = option.index || this.id;
        const nextChild = childs.find((item)=>Number(item.dataset.index) >= Number($ref.dataset.index));
        if (nextChild) nextChild.insertAdjacentElement("beforebegin", $ref);
        else (0, _dom.append)(this.$parent, $ref);
        if (option.html) (0, _dom.append)($ref, option.html);
        if (option.style) (0, _dom.setStyles)($ref, option.style);
        if (option.tooltip) (0, _dom.tooltip)($ref, option.tooltip);
        const events = [];
        if (option.click) {
            const destroyEvent = this.art.events.proxy($ref, "click", (event)=>{
                event.preventDefault();
                option.click.call(this.art, this, event);
            });
            events.push(destroyEvent);
        }
        if (option.selector && [
            "left",
            "right"
        ].includes(option.position)) this.addSelector(option, $ref, events);



        this[name] = $ref;
        this.cache.set(name, {
            $ref,
            events,
            option
        });
        if (option.mounted) option.mounted.call(this.art, $ref);
        return $ref;
    }
    addSelector(option, $ref, events) {
        const { hover, proxy } = this.art.events;
        (0, _dom.addClass)($ref, "art-control-selector");
        const $value = (0, _dom.createElement)("div");
        (0, _dom.addClass)($value, "art-selector-value");
        (0, _dom.append)($value, option.html);
        $ref.innerText = "";
        (0, _dom.append)($ref, $value);
        const list = option.selector.map((item, index)=>`<div class="art-selector-item ${item.default ? "art-current" : ""}" data-index="${index}">${item.html}</div>`).join("");
        const $list = (0, _dom.createElement)("div");
        (0, _dom.addClass)($list, "art-selector-list");
        (0, _dom.append)($list, list);
        (0, _dom.append)($ref, $list);
        const setLeft = ()=>{
            const refWidth = (0, _dom.getStyle)($ref, "width");
            const listWidth = (0, _dom.getStyle)($list, "width");
            const left = refWidth / 2 - listWidth / 2;
            $list.style.left = `${left}px`;
        };
        hover($ref, setLeft);
        const destroyEvent = proxy($list, "click", async (event)=>{
            const path = event.composedPath() || [];
            const $item = path.find((item)=>(0, _dom.hasClass)(item, "art-selector-item"));
            if (!$item) return;
            (0, _dom.inverseClass)($item, "art-current");
            const index = Number($item.dataset.index);
            const find = option.selector[index] || {};
            $value.innerText = $item.innerText;
            if (option.onSelect) {
                const result = await option.onSelect.call(this.art, find, $item, event);
                if ((0, _format.isStringOrNumber)(result)) $value.innerHTML = result;
            }
            setLeft();
        });
        events.push(destroyEvent);
    }
    remove(name) {
        const item = this.cache.get(name);
        (0, _error.errorHandle)(item, `Can't find [${name}] from the [${this.name}]`);
        if (item.option.beforeUnmount) item.option.beforeUnmount.call(this.art, item.$ref);
        for(let index = 0; index < item.events.length; index++)this.art.events.remove(item.events[index]);
        this.cache.delete(name);
        delete this[name];
        (0, _dom.remove)(item.$ref);
    }
    update(option) {
        const item = this.cache.get(option.name);
        if (item) {
            option = Object.assign(item.option, option);
            this.remove(option.name);
        }
        return this.add(option);
    }
}
exports.default = Component;

},{"./dom":"iWXW0","./format":"9vUua","./error":"kCmly","option-validator":"1vNkK","../scheme":"jVxq1","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"d7VBA":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>fullscreen);
var _utils = require("../utils");
function fullscreen(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("Fullscreen"),
            mounted: ($control)=>{
                const { proxy, icons, i18n } = art;
                const $fullscreenOn = (0, _utils.append)($control, icons.fullscreenOn);
                const $fullscreenOff = (0, _utils.append)($control, icons.fullscreenOff);
                (0, _utils.setStyle)($fullscreenOff, "display", "none");
                proxy($control, "click", ()=>{
                    art.fullscreen = !art.fullscreen;
                });
                art.on("fullscreen", (state)=>{
                    if (state) {
                        (0, _utils.tooltip)($control, i18n.get("Exit Fullscreen"));
                        (0, _utils.setStyle)($fullscreenOn, "display", "none");
                        (0, _utils.setStyle)($fullscreenOff, "display", "inline-flex");
                    } else {
                        (0, _utils.tooltip)($control, i18n.get("Fullscreen"));
                        (0, _utils.setStyle)($fullscreenOn, "display", "inline-flex");
                        (0, _utils.setStyle)($fullscreenOff, "display", "none");
                    }
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"d7VBS":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>speed);
var _utils = require("../utils");
function speed(option) {
    return (art)=>({
            ...option,
            //tooltip: "倍速",
            name: 'speed',
            position: 'right',
            html: '1x',
            index: 1,
            selector:  Artplayer.PLAYBACK_RATE.map(r => ({
                default: 1 === r,
                html: `${r}x`
            })),
            onSelect: function (item, $dom) {
                art.playbackRate = item.html.substr(0, item.html.length - 1);
                return '' + item.html;
            },
            //style: {
            //    marginRight: '20px',
            //},
            mounted: ($panel)=>{
                art.on("video:ratechange", ()=>{
                    var r = art.playbackRate;
                    $panel.querySelector('.art-selector-value').innerHTML = r + 'x';
                    $panel.querySelectorAll('.art-selector-item').forEach((e,i)=>{
                        if (e.innerText === (r + 'x')) {
                            if (!e.classList.contains("art-current")) {
                                e.classList.add("art-current");
                            }
                        }else {
                            e.classList.remove("art-current");
                        }
                    })
                    const $current = (0, _utils.queryAll)("span", $panel).find((item)=>Number(item.dataset.value) === art.playbackRate);
                    if ($current) (0, _utils.inverseClass)($current, "art-current");
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"iE4ux":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>fullscreenWeb);
var _utils = require("../utils");
function fullscreenWeb(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("Web Fullscreen"),
            mounted: ($control)=>{
                const { proxy, icons, i18n } = art;
                const $fullscreenWebOn = (0, _utils.append)($control, icons.fullscreenWebOn);
                const $fullscreenWebOff = (0, _utils.append)($control, icons.fullscreenWebOff);
                (0, _utils.setStyle)($fullscreenWebOff, "display", "none");
                proxy($control, "click", ()=>{
                    art.fullscreenWeb = !art.fullscreenWeb;
                });
                art.on("fullscreenWeb", (value)=>{
                    if (value) {
                        (0, _utils.tooltip)($control, i18n.get("Exit Web Fullscreen"));
                        (0, _utils.setStyle)($fullscreenWebOn, "display", "none");
                        (0, _utils.setStyle)($fullscreenWebOff, "display", "inline-flex");
                    } else {
                        (0, _utils.tooltip)($control, i18n.get("Web Fullscreen"));
                        (0, _utils.setStyle)($fullscreenWebOn, "display", "inline-flex");
                        (0, _utils.setStyle)($fullscreenWebOff, "display", "none");
                    }
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"03ERY":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>pip);
var _utils = require("../utils");
function pip(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("PIP Mode"),
            mounted: ($control)=>{
                const { proxy, icons, i18n } = art;
                (0, _utils.append)($control, icons.pip);
                proxy($control, "click", ()=>{
                    art.pip = !art.pip;
                });
                art.on("pip", (value)=>{
                    (0, _utils.tooltip)($control, i18n.get(value ? "Exit PIP Mode" : "PIP Mode"));
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"2tuF0":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playAndPause);
var _utils = require("../utils");
function playAndPause(option) {
    return (art)=>({
            ...option,
            mounted: ($control)=>{
                const { proxy, icons, i18n } = art;
                const $play = (0, _utils.append)($control, icons.play);
                const $pause = (0, _utils.append)($control, icons.pause);
                (0, _utils.tooltip)($play, i18n.get("Play"));
                (0, _utils.tooltip)($pause, i18n.get("Pause"));
                proxy($play, "click", ()=>{
                    art.play();
                });
                proxy($pause, "click", ()=>{
                    art.pause();
                });
                function showPlay() {
                    (0, _utils.setStyle)($play, "display", "flex");
                    (0, _utils.setStyle)($pause, "display", "none");
                }
                function showPause() {
                    (0, _utils.setStyle)($play, "display", "none");
                    (0, _utils.setStyle)($pause, "display", "flex");
                }
                if (art.playing) showPause();
                else showPlay();
                art.on("video:playing", ()=>{
                    showPause();
                });
                art.on("video:pause", ()=>{
                    showPlay();
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"afGEi":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "getPosFromEvent", ()=>getPosFromEvent);
parcelHelpers.export(exports, "setCurrentTime", ()=>setCurrentTime);
parcelHelpers.export(exports, "default", ()=>progress);
var _utils = require("../utils");
function getPosFromEvent(art, event) {
    const { $progress } = art.template;
    const { left } = (0, _utils.getRect)($progress);
    const eventLeft = (0, _utils.isMobile) ? event.touches[0].clientX : event.clientX;
    const width = (0, _utils.clamp)(eventLeft - left, 0, $progress.clientWidth);
    const second = width / $progress.clientWidth * art.duration;
    const time = (0, _utils.secondToTime)(second);
    const percentage = (0, _utils.clamp)(width / $progress.clientWidth, 0, 1);
    return {
        second,
        time,
        width,
        percentage
    };
}

function timeToSeconds(timeString) {
    const regex1 = /(\d{2}):(\d{2})/;
    const regex2 = /(\d{2}):(\d{2}):(\d{2})/;
    if (timeString.match(regex2)) {

    }else  if (timeString.match(regex1)) {
        timeString = "00:" + timeString;
    }
    const [, hours, minutes, seconds] = timeString.match(regex2);
    return Number(hours) * 3600 + Number(minutes) * 60 + Number(seconds);
}

function setCurrentTime(art, event) {
    if (art.isRotate) {
        const percentage = event.touches[0].clientY / art.height;
        const second = percentage * art.duration;
        art.emit("setBar", "played", percentage, event);
        art.seek = second;
    } else {
        const {                             second,
            time,
            width,
            percentage } = getPosFromEvent(art, event);
        art.emit("setBar", "played", percentage, event);
        art.seek = timeToSeconds(time);
    }
}

function progress(options) {
    return (art)=>{
        const { icons, option, proxy } = art;
        return {
            ...options,
            html: `
                <div class="art-control-progress-inner">
                    <div class="art-progress-hover"></div>
                    <div class="art-progress-loaded"></div>
                    <div class="art-progress-played"></div>
                    <div class="art-progress-highlight"></div>
                    <div class="art-progress-indicator"></div>
                    <div class="art-progress-tip"></div>
                </div>
                <div class="art-control art-control-thumbnails" data-index="20" style="
                            width: 160px;
                            height: 90px;
                            left: 275px;
                            text-align: center;
                            justify-content: center;
                            background: rgb(0 0 0 / 0%);
                            border: 1px solid rgb(100 100 100 / 50%);
                            display: none;
                        ">
                    <img id="thumbnail_container" class="sharkplayer-bar-cut-img" src="">
                    <!--<div class="red-dot">🚂🚂🚂</div>-->
                </div>
            `,
            mounted: ($control)=>{
                let tipTimer = null;
                let isDroging = false;
                let current_cuttime = "";
                const $hover = (0, _utils.query)(".art-progress-hover", $control);
                const $loaded = (0, _utils.query)(".art-progress-loaded", $control);
                const $played = (0, _utils.query)(".art-progress-played", $control);
                const $highlight = (0, _utils.query)(".art-progress-highlight", $control);
                const $indicator = (0, _utils.query)(".art-progress-indicator", $control);
                const $tip = (0, _utils.query)(".art-progress-tip", $control);
                const $thumbnails = (0, _utils.query)(".art-control-thumbnails", $control);
                if (icons.indicator) (0, _utils.append)($indicator, icons.indicator);
                else (0, _utils.setStyle)($indicator, "backgroundColor", "var(--art-theme)");
                function showHighlight(event) {
                    const { width } = getPosFromEvent(art, event);
                    const { text } = event.target.dataset;
                    $tip.innerText = text;
                    const tipWidth = $tip.clientWidth;
                    if (width <= tipWidth / 2) (0, _utils.setStyle)($tip, "left", 0);
                    else if (width > $control.clientWidth - tipWidth / 2) (0, _utils.setStyle)($tip, "left", `${$control.clientWidth - tipWidth}px`);
                    else (0, _utils.setStyle)($tip, "left", `${width - tipWidth / 2}px`);
                }
                function showTime(event, touch) {
                    const { width, time } = touch || getPosFromEvent(art, event);
                    $tip.innerText = time;
                    const tipWidth = $tip.clientWidth;
                    if (width <= tipWidth / 2) (0, _utils.setStyle)($tip, "left", 0);
                    else if (width > $control.clientWidth - tipWidth / 2) (0, _utils.setStyle)($tip, "left", `${$control.clientWidth - tipWidth}px`);
                    else (0, _utils.setStyle)($tip, "left", `${width - tipWidth / 2}px`);
                }

                function generateThumbnail(event, touch) {
                    var video = document.getElementById("art-video-cut");
                    const {second, time, width, percentage } = getPosFromEvent(art, event);
                    if (video.duration && time !== current_cuttime) {
                        $thumbnails.querySelector('img').setAttribute('src', "");
                        current_cuttime = time;
                        video.currentTime = timeToSeconds(time);

                        const tipWidth = $tip.clientWidth;
                        if (width <= tipWidth / 2) {
                            (0, _utils.setStyle)($thumbnails, "left", 0);
                        }
                        else if (width > $control.clientWidth - tipWidth / 2) {
                            (0, _utils.setStyle)($thumbnails, "left", `${($control.clientWidth - tipWidth)-105}px`);
                        }
                        else {
                            (0, _utils.setStyle)($thumbnails, "left", `${(width - tipWidth / 2)-60}px`);
                        }

                        takeVideoSnapshot(video, function(snapshot) {
                            $thumbnails.querySelector('img').setAttribute('src', snapshot);
                            current_cuttime = "";
                        });
                    }
                }

                function takeVideoSnapshot(videoElement, callback) {
                    if (videoElement.readyState >= 2) { // 确保视频已加载足够的数据
                        var canvas = document.createElement('canvas');
                        canvas.width = videoElement.videoWidth/10;
                        canvas.height = videoElement.videoHeight/10;
                        var ctx = canvas.getContext('2d');
                        ctx.drawImage(videoElement, 0, 0, canvas.width, canvas.height);
                        callback(canvas.toDataURL('image/png'));
                    } else {
                        // 如果视频未准备好，则稍后重试
                        setTimeout(function() {
                            takeVideoSnapshot(videoElement, callback);
                        }, 100);
                    }
                }

                function updateHighlight() {
                    $highlight.innerText = "";
                    for(let index = 0; index < option.highlight.length; index++){
                        const item = option.highlight[index];
                        const left = (0, _utils.clamp)(item.time, 0, art.duration) / art.duration * 100;
                        const html = `<span data-text="${item.text}" data-time="${item.time}" style="left: ${left}%"></span>`;
                        (0, _utils.append)($highlight, html);
                    }
                }
                function setBar(type, percentage, event) {
                    const isMobileDroging = type === "played" && event && (0, _utils.isMobile);
                    if (type === "loaded") (0, _utils.setStyle)($loaded, "width", `${percentage * 100}%`);
                    if (type === "hover") (0, _utils.setStyle)($hover, "width", `${percentage * 100}%`);
                    if (type === "played") {
                        (0, _utils.setStyle)($played, "width", `${percentage * 100}%`);
                        (0, _utils.setStyle)($indicator, "left", `${percentage * 100}%`);
                    }
                    if (isMobileDroging) {
                        (0, _utils.setStyle)($tip, "display", "flex");
                        (0, _utils.setStyle)($thumbnails, "display", "flex");
                        const width = $control.clientWidth * percentage;
                        const time = (0, _utils.secondToTime)(percentage * art.duration);
                        showTime(event, {
                            width,
                            time
                        });
                        generateThumbnail(event, {
                            width,
                            time
                        });
                        clearTimeout(tipTimer);
                        tipTimer = setTimeout(()=>{
                            (0, _utils.setStyle)($tip, "display", "none");
                            (0, _utils.setStyle)($thumbnails, "display", "none");
                        }, 500);
                    }
                }
                art.on("setBar", setBar);
                art.on("video:loadedmetadata", updateHighlight);
                art.on("video:progress", ()=>{
                    art.emit("setBar", "loaded", art.loaded);
                });
                if (art.constructor.USE_RAF) art.on("raf", ()=>{
                    art.emit("setBar", "played", art.played);
                });
                else art.on("video:timeupdate", ()=>{
                    art.emit("setBar", "played", art.played);
                });
                art.on("video:ended", ()=>{
                    art.emit("setBar", "played", 1);
                });
                art.emit("setBar", "loaded", art.loaded || 0);
                if (!(0, _utils.isMobile)) {
                    proxy($control, "click", (event)=>{
                        if (event.target !== $indicator) setCurrentTime(art, event);
                    });
                    proxy($control, "mousemove", (event)=>{
                        const { percentage } = getPosFromEvent(art, event);
                        art.emit("setBar", "hover", percentage, event);
                        (0, _utils.setStyle)($tip, "display", "flex");
                        (0, _utils.setStyle)($thumbnails, "display", "flex");
                        if ((0, _utils.includeFromEvent)(event, $highlight)) {
                            showHighlight(event);
                        } else {
                            showTime(event);
                            generateThumbnail(event)
                        }
                    });
                    proxy($control, "mouseleave", (event)=>{
                        (0, _utils.setStyle)($tip, "display", "none");
                        (0, _utils.setStyle)($thumbnails, "display", "none");
                        art.emit("setBar", "hover", 0, event);
                    });
                    proxy($control, "mousedown", (event)=>{
                        isDroging = event.button === 0;
                    });
                    art.on("document:mousemove", (event)=>{
                        if (isDroging) {
                            const { second, percentage } = getPosFromEvent(art, event);
                            art.emit("setBar", "played", percentage, event);
                            art.seek = second;
                        }
                    });
                    art.on("document:mouseup", ()=>{
                        if (isDroging) isDroging = false;
                    });
                }
            }
        };
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"e6eX5":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>time);
var _utils = require("../utils");
function time(option) {
    return (art)=>({
            ...option,
            style: (0, _utils.isMobile) ? {
                fontSize: "12px",
                padding: "0 5px"
            } : {
                cursor: "auto",
                padding: "0 10px"
            },
            mounted: ($control)=>{
                function getTime() {
                    const newTime = `${(0, _utils.secondToTime)(art.currentTime)} / ${(0, _utils.secondToTime)(art.duration)}`;
                    if (newTime !== $control.innerText) $control.innerText = newTime;
                }
                getTime();
                const events = [
                    "video:loadedmetadata",
                    "video:timeupdate",
                    "video:progress"
                ];
                for(let index = 0; index < events.length; index++)art.on(events[index], getTime);
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"ezhk3":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>volume);
var _utils = require("../utils");
function volume(option) {
    return (art)=>({
            ...option,
            mounted: ($control)=>{
                const { proxy, icons } = art;
                const $volume = (0, _utils.append)($control, icons.volume);
                const $close = (0, _utils.append)($control, icons.volumeClose);
                const $panel = (0, _utils.append)($control, '<div class="art-volume-panel"></div>');
                const $inner = (0, _utils.append)($panel, '<div class="art-volume-inner"></div>');
                const $value = (0, _utils.append)($inner, `<div class="art-volume-val"></div>`);
                const $slider = (0, _utils.append)($inner, `<div class="art-volume-slider"></div>`);
                const $handle = (0, _utils.append)($slider, `<div class="art-volume-handle"></div>`);
                const $loaded = (0, _utils.append)($handle, `<div class="art-volume-loaded"></div>`);
                const $indicator = (0, _utils.append)($slider, `<div class="art-volume-indicator"></div>`);
                function getVolumeFromEvent(event) {
                    const { top, height } = (0, _utils.getRect)($slider);
                    return 1 - (event.clientY - top) / height;
                }
                function update() {
                    if (art.muted || art.volume === 0) {
                        (0, _utils.setStyle)($volume, "display", "none");
                        (0, _utils.setStyle)($close, "display", "flex");
                        (0, _utils.setStyle)($indicator, "top", "100%");
                        (0, _utils.setStyle)($loaded, "top", "100%");
                        $value.innerText = 0;
                    } else {
                        const percentage = art.volume * 100;
                        (0, _utils.setStyle)($volume, "display", "flex");
                        (0, _utils.setStyle)($close, "display", "none");
                        (0, _utils.setStyle)($indicator, "top", `${100 - percentage}%`);
                        (0, _utils.setStyle)($loaded, "top", `${100 - percentage}%`);
                        $value.innerText = Math.floor(percentage);
                    }
                }
                update();
                art.on("video:volumechange", update);
                proxy($volume, "click", ()=>{
                    art.muted = true;
                });
                proxy($close, "click", ()=>{
                    art.muted = false;
                });
                if (0, _utils.isMobile) (0, _utils.setStyle)($panel, "display", "none");
                else {
                    let isDroging = false;
                    proxy($slider, "mousedown", (event)=>{
                        isDroging = event.button === 0;
                        art.volume = getVolumeFromEvent(event);
                    });
                    art.on("document:mousemove", (event)=>{
                        if (isDroging) {
                            art.muted = false;
                            art.volume = getVolumeFromEvent(event);
                        }
                    });
                    art.on("document:mouseup", ()=>{
                        if (isDroging) isDroging = false;
                    });
                }
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"3Vg4s":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>setting);
var _utils = require("../utils");
function setting(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("Show Setting"),
            mounted: ($control)=>{
                const { proxy, icons, i18n } = art;
                (0, _utils.append)($control, icons.setting);
                proxy($control, "click", ()=>{
                    art.setting.toggle();
                    art.setting.updateStyle();
                });
                art.on("setting", (value)=>{
                    (0, _utils.tooltip)($control, i18n.get(value ? "Hide Setting" : "Show Setting"));
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"8AAYm":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>thumbnails);
var _utils = require("../utils");
function thumbnails(options) {
    return (art)=>({
            ...options,
            mounted: ($control)=>{
                const { option, events: { loadImg }, template: { $progress, $video } } = art;
                let timer = null;
                let image = null;
                let loading = false;
                let isLoad = false;
                function showThumbnails(posWidth) {
                    const { url, number, column, width, height } = option.thumbnails;
                    const width2 = width || image.naturalWidth / column;
                    const height2 = height || width2 / ($video.videoWidth / $video.videoHeight);
                    const perWidth = $progress.clientWidth / number;
                    const perIndex = Math.floor(posWidth / perWidth);
                    const yIndex = Math.ceil(perIndex / column) - 1;
                    const xIndex = perIndex % column || column - 1;
                    (0, _utils.setStyle)($control, "backgroundImage", `url(${url})`);
                    (0, _utils.setStyle)($control, "height", `${height2}px`);
                    (0, _utils.setStyle)($control, "width", `${width2}px`);
                    (0, _utils.setStyle)($control, "backgroundPosition", `-${xIndex * width2}px -${yIndex * height2}px`);
                    if (posWidth <= width2 / 2) (0, _utils.setStyle)($control, "left", 0);
                    else if (posWidth > $progress.clientWidth - width2 / 2) (0, _utils.setStyle)($control, "left", `${$progress.clientWidth - width2}px`);
                    else (0, _utils.setStyle)($control, "left", `${posWidth - width2 / 2}px`);
                }
                art.on("setBar", async (type, percentage, event)=>{
                    const isMobileDroging = type === "played" && event && (0, _utils.isMobile);
                    if (type === "hover" || isMobileDroging) {
                        if (!loading) {
                            loading = true;
                            image = await loadImg(option.thumbnails.url);
                            isLoad = true;
                        }
                        if (!isLoad) return;
                        const width = $progress.clientWidth * percentage;
                        (0, _utils.setStyle)($control, "display", "flex");
                        if (width > 0 && width < $progress.clientWidth) showThumbnails(width);
                        else if (!(0, _utils.isMobile)) (0, _utils.setStyle)($control, "display", "none");
                        if (isMobileDroging) {
                            clearTimeout(timer);
                            timer = setTimeout(()=>{
                                (0, _utils.setStyle)($control, "display", "none");
                            }, 500);
                        }
                    }
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lcqMk":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>screenshot);
var _utils = require("../utils");
function screenshot(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("Screenshot"),
            mounted: ($control)=>{
                const { proxy, icons } = art;
                (0, _utils.append)($control, icons.screenshot);
                proxy($control, "click", ()=>{
                    art.screenshot();
                });
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4dMTc":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>pip);
var _utils = require("../utils");
function pip(option) {
    return (art)=>({
            ...option,
            tooltip: art.i18n.get("AirPlay"),
            mounted: ($control)=>{
                const { proxy, icons } = art;
                (0, _utils.append)($control, icons.airplay);
                proxy($control, "click", ()=>art.airplay());
            }
        });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"iygWX":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("../utils");
var _component = require("../utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
var _playbackRate = require("./playbackRate");
var _playbackRateDefault = parcelHelpers.interopDefault(_playbackRate);
var _aspectRatio = require("./aspectRatio");
var _aspectRatioDefault = parcelHelpers.interopDefault(_aspectRatio);
var _flip = require("./flip");
var _flipDefault = parcelHelpers.interopDefault(_flip);
var _info = require("./info");
var _infoDefault = parcelHelpers.interopDefault(_info);
var _version = require("./version");
var _versionDefault = parcelHelpers.interopDefault(_version);
var _close = require("./close");
var _closeDefault = parcelHelpers.interopDefault(_close);
class Contextmenu extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.name = "contextmenu";
        this.$parent = art.template.$contextmenu;
        if (!(0, _utils.isMobile)) this.init();
    }
    init() {
        const { option, proxy, template: { $player, $contextmenu } } = this.art;
        if (option.playbackRate) this.add((0, _playbackRateDefault.default)({
            name: "playbackRate",
            index: 10
        }));
        if (option.aspectRatio) this.add((0, _aspectRatioDefault.default)({
            name: "aspectRatio",
            index: 20
        }));
        if (option.flip) this.add((0, _flipDefault.default)({
            name: "flip",
            index: 30
        }));
        this.add((0, _infoDefault.default)({
            name: "info",
            index: 40
        }));
        this.add((0, _versionDefault.default)({
            name: "version",
            index: 50
        }));
        this.add((0, _closeDefault.default)({
            name: "close",
            index: 60
        }));
        for(let index = 0; index < option.contextmenu.length; index++)this.add(option.contextmenu[index]);
        proxy($player, "contextmenu", (event)=>{
            event.preventDefault();
            if (!this.art.constructor.CONTEXTMENU) return;
            this.show = true;
            const mouseX = event.clientX;
            const mouseY = event.clientY;
            const { height: cHeight, width: cWidth, left: cLeft, top: cTop } = (0, _utils.getRect)($player);
            const { height: mHeight, width: mWidth } = (0, _utils.getRect)($contextmenu);
            let menuLeft = mouseX - cLeft;
            let menuTop = mouseY - cTop;
            if (mouseX + mWidth > cLeft + cWidth) menuLeft = cWidth - mWidth;
            if (mouseY + mHeight > cTop + cHeight) menuTop = cHeight - mHeight;
            (0, _utils.setStyles)($contextmenu, {
                top: `${menuTop}px`,
                left: `${menuLeft}px`
            });
        });
        proxy($player, "click", (event)=>{
            if (!(0, _utils.includeFromEvent)(event, $contextmenu)) this.show = false;
        });
        this.art.on("blur", ()=>{
            this.show = false;
        });
    }
}
exports.default = Contextmenu;

},{"../utils":"euhMG","../utils/component":"1UWqI","./playbackRate":"aEEkc","./aspectRatio":"jQvOA","./flip":"gcvCz","./info":"2g4ET","./version":"6YbWR","./close":"kM2pD","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"aEEkc":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playbackRate);
var _utils = require("../utils");
function playbackRate(option) {
    return (art)=>{
        const { i18n, constructor: { PLAYBACK_RATE } } = art;
        const html = PLAYBACK_RATE.map((item)=>`<span data-value="${item}">${item === 1 ? i18n.get("Normal") : item.toFixed(1)}</span>`).join("");
        return {
            ...option,
            html: `${i18n.get("Play Speed")}: ${html}`,
            click: (contextmenu, event)=>{
                const { value } = event.target.dataset;
                if (value) {
                    art.playbackRate = Number(value);
                    contextmenu.show = false;
                }
            },
            mounted: ($panel)=>{
                const $default = (0, _utils.query)('[data-value="1"]', $panel);
                if ($default) (0, _utils.inverseClass)($default, "art-current");
                art.on("video:ratechange", ()=>{
                    const $current = (0, _utils.queryAll)("span", $panel).find((item)=>Number(item.dataset.value) === art.playbackRate);
                    if ($current) (0, _utils.inverseClass)($current, "art-current");
                });
            }
        };
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jQvOA":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>aspectRatio);
var _utils = require("../utils");
function aspectRatio(option) {
    return (art)=>{
        const { i18n, constructor: { ASPECT_RATIO } } = art;
        const html = ASPECT_RATIO.map((item)=>`<span data-value="${item}">${item === "default" ? i18n.get("Default") : item}</span>`).join("");
        return {
            ...option,
            html: `${i18n.get("Aspect Ratio")}: ${html}`,
            click: (contextmenu, event)=>{
                const { value } = event.target.dataset;
                if (value) {
                    art.aspectRatio = value;
                    contextmenu.show = false;
                }
            },
            mounted: ($panel)=>{
                const $default = (0, _utils.query)('[data-value="default"]', $panel);
                if ($default) (0, _utils.inverseClass)($default, "art-current");
                art.on("aspectRatio", (value)=>{
                    const $current = (0, _utils.queryAll)("span", $panel).find((item)=>item.dataset.value === value);
                    if ($current) (0, _utils.inverseClass)($current, "art-current");
                });
            }
        };
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"gcvCz":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>flip);
var _utils = require("../utils");
function flip(option) {
    return (art)=>{
        const { i18n, constructor: { FLIP } } = art;
        const html = FLIP.map((item)=>`<span data-value="${item}">${i18n.get((0, _utils.capitalize)(item))}</span>`).join("");
        return {
            ...option,
            html: `${i18n.get("Video Flip")}: ${html}`,
            click: (contextmenu, event)=>{
                const { value } = event.target.dataset;
                if (value) {
                    art.flip = value.toLowerCase();
                    contextmenu.show = false;
                }
            },
            mounted: ($panel)=>{
                const $default = (0, _utils.query)('[data-value="normal"]', $panel);
                if ($default) (0, _utils.inverseClass)($default, "art-current");
                art.on("flip", (value)=>{
                    const $current = (0, _utils.queryAll)("span", $panel).find((item)=>item.dataset.value === value);
                    if ($current) (0, _utils.inverseClass)($current, "art-current");
                });
            }
        };
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"2g4ET":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>info);
function info(option) {
    return (art)=>({
            ...option,
            html: art.i18n.get("Video Info"),
            click: (contextmenu)=>{
                art.info.show = true;
                art.info.startLoop();
                contextmenu.show = false;
            }
        });
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6YbWR":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>version);
function version(option) {
    return {
        ...option,
        html: `<a href="https://artplayer.org" target="_blank">ArtPlayer ${"5.1.6"}</a>`
    };
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"kM2pD":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>close);
function close(option) {
    return (art)=>({
            ...option,
            html: art.i18n.get("Close"),
            click: (contextmenu)=>{
                contextmenu.show = false;
            }
        });
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6tuCt":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
var _component = require("./utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
class Info extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.name = "info";
        if (!(0, _utils.isMobile)) this.init();
    }
    init() {
        const { proxy, constructor, template: { $infoPanel, $infoClose, $video } } = this.art;
        proxy($infoClose, "click", ()=>{
            this.show = false;
            this.stopLoop();
        });
        let timer = null;
        const $types = (0, _utils.queryAll)("[data-video]", $infoPanel) || [];
        const $playerFrameRate = (0, _utils.queryAll)("#playerFrameRate", $infoPanel) || [];
        this.art.on("destroy", ()=>clearTimeout(timer));
        function loop() {
            for(let index = 0; index < $types.length; index++){
                const item = $types[index];
                const value = $video[item.dataset.video];
                const innerText = typeof value === "number" ? value.toFixed(2) : value;
                if (item.innerText !== innerText) item.innerText = innerText;
            }
            timer = setTimeout(loop, constructor.INFO_LOOP_TIME);
        }
        loop();

        /**
         * https://bi.cool/bi/63jgqKX
         * @type {number}
         */
        let last = Date.now(), ticks = 0, frameRateTimer = null;
        function rafLoop() {
            ticks += 1;
            if (ticks >= 30) {
                const now = Date.now();
                const diff = now - last
                const fps = Math.round(1000 / (diff / ticks));
                last = now
                ticks = 0
                renderFps(fps);
            }
            frameRateTimer = requestAnimationFrame(rafLoop);
        }

        function renderFps(fps) {
            //console.log("画面帧率：", fps);
            $playerFrameRate[0].innerText = fps + " fps";
        }

        this.startLoop = function startLoop(){
            rafLoop();
        }

        this.stopLoop = function stopLoop(){
            cancelAnimationFrame(frameRateTimer)
        }
    }
}
exports.default = Info;

},{"./utils":"euhMG","./utils/component":"1UWqI","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1kFyE":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
var _component = require("./utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
var _optionValidator = require("option-validator");
var _optionValidatorDefault = parcelHelpers.interopDefault(_optionValidator);
var _scheme = require("./scheme");
var _schemeDefault = parcelHelpers.interopDefault(_scheme);
class Subtitle extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.name = "subtitle";
        this.eventDestroy = ()=>null;
        this.init(art.option.subtitle);
        let lastState = false;
        art.on("video:timeupdate", ()=>{
            if (!this.url) return;
            const state = this.art.template.$video.webkitDisplayingFullscreen;
            if (typeof state !== "boolean") return;
            if (state !== lastState) {
                lastState = state;
                this.createTrack(state ? "subtitles" : "metadata", this.url);
            }
        });
    }
    get url() {
        return this.art.template.$track.src;
    }
    set url(url) {
        this.switch(url);
    }
    get textTrack() {
        return this.art.template.$video.textTracks[0];
    }
    get activeCue() {
        return this.textTrack.activeCues[0];
    }
    style(key, value) {
        const { $subtitle } = this.art.template;
        if (typeof key === "object") return (0, _utils.setStyles)($subtitle, key);
        return (0, _utils.setStyle)($subtitle, key, value);
    }
    update() {
        const { $subtitle } = this.art.template;
        $subtitle.innerHTML = "";
        if (this.activeCue) {
            if (this.art.option.subtitle.escape) $subtitle.innerHTML = this.activeCue.text.split(/\r?\n/).map((item)=>`<div class="art-subtitle-line">${(0, _utils.escape)(item)}</div>`).join("");
            else $subtitle.innerHTML = this.activeCue.text;
            this.art.emit("subtitleUpdate", this.activeCue.text);
        }
    }
    async switch(url, newOption = {}) {
        const { i18n, notice, option } = this.art;
        const subtitleOption = {
            ...option.subtitle,
            ...newOption,
            url
        };
        const subUrl = await this.init(subtitleOption);
        if (newOption.name) notice.show = `${i18n.get("Switch Subtitle")}: ${newOption.name}`;
        return subUrl;
    }
    createTrack(kind, url) {
        const { template, proxy, option } = this.art;
        const { $video, $track } = template;
        const $newTrack = (0, _utils.createElement)("track");
        $newTrack.default = true;
        $newTrack.kind = kind;
        $newTrack.src = url;
        $newTrack.label = option.subtitle.name || "Artplayer";
        $newTrack.track.mode = "hidden";
        this.eventDestroy();
        (0, _utils.remove)($track);
        (0, _utils.append)($video, $newTrack);
        template.$track = $newTrack;
        this.eventDestroy = proxy(this.textTrack, "cuechange", ()=>this.update());
    }
    async init(subtitleOption) {
        const { notice, template: { $subtitle } } = this.art;
        (0, _optionValidatorDefault.default)(subtitleOption, (0, _schemeDefault.default).subtitle);
        if (!subtitleOption.url) return;
        this.style(subtitleOption.style);
        return fetch(subtitleOption.url).then((response)=>response.arrayBuffer()).then((buffer)=>{
            const decoder = new TextDecoder(subtitleOption.encoding);
            const text = decoder.decode(buffer);
            this.art.emit("subtitleLoad", subtitleOption.url);
            switch(subtitleOption.type || (0, _utils.getExt)(subtitleOption.url)){
                case "srt":
                    {
                        const vtt = (0, _utils.srtToVtt)(text);
                        const vttNew = subtitleOption.onVttLoad(vtt);
                        return (0, _utils.vttToBlob)(vttNew);
                    }
                case "ass":
                    {
                        const vtt = (0, _utils.assToVtt)(text);
                        const vttNew = subtitleOption.onVttLoad(vtt);
                        return (0, _utils.vttToBlob)(vttNew);
                    }
                case "vtt":
                    {
                        const vttNew = subtitleOption.onVttLoad(text);
                        return (0, _utils.vttToBlob)(vttNew);
                    }
                default:
                    return subtitleOption.url;
            }
        }).then((subUrl)=>{
            $subtitle.innerHTML = "";
            if (this.url === subUrl) return subUrl;
            URL.revokeObjectURL(this.url);
            this.createTrack("metadata", subUrl);
            this.art.emit("subtitleSwitch", subUrl);
            return subUrl;
        }).catch((err)=>{
            $subtitle.innerHTML = "";
            notice.show = err;
            throw err;
        });
    }
}
exports.default = Subtitle;

},{"./utils":"euhMG","./utils/component":"1UWqI","option-validator":"1vNkK","./scheme":"jVxq1","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"akAUN":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _error = require("../utils/error");
var _clickInit = require("./clickInit");
var _clickInitDefault = parcelHelpers.interopDefault(_clickInit);
var _hoverInit = require("./hoverInit");
var _hoverInitDefault = parcelHelpers.interopDefault(_hoverInit);
var _moveInit = require("./moveInit");
var _moveInitDefault = parcelHelpers.interopDefault(_moveInit);
var _resizeInit = require("./resizeInit");
var _resizeInitDefault = parcelHelpers.interopDefault(_resizeInit);
var _gestureInit = require("./gestureInit");
var _gestureInitDefault = parcelHelpers.interopDefault(_gestureInit);
var _viewInit = require("./viewInit");
var _viewInitDefault = parcelHelpers.interopDefault(_viewInit);
var _documentInit = require("./documentInit");
var _documentInitDefault = parcelHelpers.interopDefault(_documentInit);
var _updateInit = require("./updateInit");
var _updateInitDefault = parcelHelpers.interopDefault(_updateInit);
class Events {
    constructor(art){
        this.destroyEvents = [];
        this.proxy = this.proxy.bind(this);
        this.hover = this.hover.bind(this);
        this.loadImg = this.loadImg.bind(this);
        (0, _clickInitDefault.default)(art, this);
        (0, _hoverInitDefault.default)(art, this);
        (0, _moveInitDefault.default)(art, this);
        (0, _resizeInitDefault.default)(art, this);
        (0, _gestureInitDefault.default)(art, this);
        (0, _viewInitDefault.default)(art, this);
        (0, _documentInitDefault.default)(art, this);
        (0, _updateInitDefault.default)(art, this);
    }
    proxy(target, name, callback, option = {}) {
        if (Array.isArray(name)) return name.map((item)=>this.proxy(target, item, callback, option));
        target.addEventListener(name, callback, option);
        const destroy = ()=>target.removeEventListener(name, callback, option);
        this.destroyEvents.push(destroy);
        return destroy;
    }
    hover(target, mouseenter, mouseleave) {
        if (mouseenter) this.proxy(target, "mouseenter", mouseenter);
        if (mouseleave) this.proxy(target, "mouseleave", mouseleave);
    }
    loadImg(img) {
        return new Promise((resolve, reject)=>{
            let image;
            if (img instanceof HTMLImageElement) image = img;
            else if (typeof img === "string") {
                image = new Image();
                image.src = img;
            } else return reject(new (0, _error.ArtPlayerError)("Unable to get Image"));
            if (image.complete) return resolve(image);
            this.proxy(image, "load", ()=>resolve(image));
            this.proxy(image, "error", ()=>reject(new (0, _error.ArtPlayerError)(`Failed to load Image: ${image.src}`)));
        });
    }
    remove(destroyEvent) {
        const index = this.destroyEvents.indexOf(destroyEvent);
        if (index > -1) {
            destroyEvent();
            this.destroyEvents.splice(index, 1);
        }
    }
    destroy() {
        for(let index = 0; index < this.destroyEvents.length; index++)this.destroyEvents[index]();
    }
}
exports.default = Events;

},{"../utils/error":"kCmly","./clickInit":"4xN0W","./hoverInit":"bO8Cy","./moveInit":"l5Ock","./resizeInit":"1e06H","./gestureInit":"1Cim3","./viewInit":"xZUxN","./documentInit":"jKzGQ","./updateInit":"ONlxE","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4xN0W":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>clickInit);
var _utils = require("../utils");
function clickInit(art, events) {
    const { constructor, template: { $player, $video } } = art;
    events.proxy(document, [
        "click",
        "contextmenu"
    ], (event)=>{
        if ((0, _utils.includeFromEvent)(event, $player)) {
            art.isInput = event.target.tagName === "INPUT";
            art.isFocus = true;
            art.emit("focus", event);
        } else {
            art.isInput = false;
            art.isFocus = false;
            art.emit("blur", event);
        }
    });
    let clickTimes = [];
    events.proxy($video, "click", (event)=>{
        const now = Date.now();
        clickTimes.push(now);
        const { MOBILE_CLICK_PLAY, DBCLICK_TIME, MOBILE_DBCLICK_PLAY, DBCLICK_FULLSCREEN } = constructor;
        const clicks = clickTimes.filter((t)=>now - t <= DBCLICK_TIME);
        switch(clicks.length){
            case 1:
                art.emit("click", event);
                if (0, _utils.isMobile) {
                    if (!art.isLock && MOBILE_CLICK_PLAY) art.toggle();
                } else art.toggle();
                clickTimes = clicks;
                break;
            case 2:
                art.emit("dblclick", event);
                if (0, _utils.isMobile) {
                    if (!art.isLock && MOBILE_DBCLICK_PLAY) art.toggle();
                } else if (DBCLICK_FULLSCREEN) art.fullscreen = !art.fullscreen;
                clickTimes = [];
                break;
            default:
                clickTimes = [];
        }
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"bO8Cy":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>hoverInit);
var _utils = require("../utils");
function hoverInit(art, events) {
    const { $player } = art.template;
    events.hover($player, (event)=>{
        (0, _utils.addClass)($player, "art-hover");
        art.emit("hover", true, event);
    }, (event)=>{
        (0, _utils.removeClass)($player, "art-hover");
        art.emit("hover", false, event);
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"l5Ock":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>moveInit);
function moveInit(art, events) {
    const { $player } = art.template;
    events.proxy($player, "mousemove", (event)=>{
        art.emit("mousemove", event);
    });
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1e06H":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>resizeInit);
var _utils = require("../utils");
function resizeInit(art, events) {
    const { option, constructor } = art;
    art.on("resize", ()=>{
        const { aspectRatio, notice } = art;
        if (art.state === "standard" && option.autoSize) art.autoSize();
        art.aspectRatio = aspectRatio;
        notice.show = "";
    });
    const resizeFn = (0, _utils.debounce)(()=>art.emit("resize"), constructor.RESIZE_TIME);
    events.proxy(window, [
        "orientationchange",
        "resize"
    ], ()=>resizeFn());
    if (screen && screen.orientation && screen.orientation.onchange) events.proxy(screen.orientation, "change", ()=>resizeFn());
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1Cim3":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>gestureInit);
var _utils = require("../utils");
var _progress = require("../control/progress");
function GetSlideAngle(dx, dy) {
    return Math.atan2(dy, dx) * 180 / Math.PI;
}
function GetSlideDirection(startX, startY, endX, endY) {
    var dy = startY - endY;
    var dx = endX - startX;
    var result = 0;
    if (Math.abs(dx) < 2 && Math.abs(dy) < 2) return result;
    var angle = GetSlideAngle(dx, dy);
    if (angle >= -45 && angle < 45) result = 4;
    else if (angle >= 45 && angle < 135) result = 1;
    else if (angle >= -135 && angle < -45) result = 2;
    else if (angle >= 135 && angle <= 180 || angle >= -180 && angle < -135) result = 3;
    return result;
}
function gestureInit(art, events) {
    if ((0, _utils.isMobile) && !art.option.isLive) {
        const { $video, $progress } = art.template;
        let touchTarget = null;
        let isDroging = false;
        let startX = 0;
        let startY = 0;
        let startTime = 0;
        const onTouchStart = (event)=>{
            if (event.touches.length === 1 && !art.isLock) {
                if (touchTarget === $progress) (0, _progress.setCurrentTime)(art, event);
                isDroging = true;
                const { pageX, pageY } = event.touches[0];
                startX = pageX;
                startY = pageY;
                startTime = art.currentTime;
            }
        };
        const onTouchMove = (event)=>{
            if (event.touches.length === 1 && isDroging && art.duration) {
                const { pageX, pageY } = event.touches[0];
                const direction = GetSlideDirection(startX, startY, pageX, pageY);
                const isHorizontal = [
                    3,
                    4
                ].includes(direction);
                const isVertical = [
                    1,
                    2
                ].includes(direction);
                const isLegal = isHorizontal && !art.isRotate || isVertical && art.isRotate;
                if (isLegal) {
                    const ratioX = (0, _utils.clamp)((pageX - startX) / art.width, -1, 1);
                    const ratioY = (0, _utils.clamp)((pageY - startY) / art.height, -1, 1);
                    const ratio = art.isRotate ? ratioY : ratioX;
                    const TOUCH_MOVE_RATIO = touchTarget === $video ? art.constructor.TOUCH_MOVE_RATIO : 1;
                    const currentTime = (0, _utils.clamp)(startTime + art.duration * ratio * TOUCH_MOVE_RATIO, 0, art.duration);
                    art.seek = currentTime;
                    art.emit("setBar", "played", (0, _utils.clamp)(currentTime / art.duration, 0, 1), event);
                    art.notice.show = `${(0, _utils.secondToTime)(currentTime)} / ${(0, _utils.secondToTime)(art.duration)}`;
                }
            }
        };
        const onTouchEnd = ()=>{
            if (isDroging) {
                startX = 0;
                startY = 0;
                startTime = 0;
                isDroging = false;
                touchTarget = null;
            }
        };
        events.proxy($progress, "touchstart", (event)=>{
            touchTarget = $progress;
            onTouchStart(event);
        });
        events.proxy($video, "touchstart", (event)=>{
            touchTarget = $video;
            onTouchStart(event);
        });
        events.proxy($video, "touchmove", onTouchMove);
        events.proxy($progress, "touchmove", onTouchMove);
        events.proxy(document, "touchend", onTouchEnd);
    }
}

},{"../utils":"euhMG","../control/progress":"afGEi","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"xZUxN":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>viewInit);
var _utils = require("../utils");
function viewInit(art, events) {
    const { option, constructor, template: { $container } } = art;
    const scrollFn = (0, _utils.throttle)(()=>{
        art.emit("view", (0, _utils.isInViewport)($container, constructor.SCROLL_GAP));
    }, constructor.SCROLL_TIME);
    events.proxy(window, "scroll", ()=>scrollFn());
    art.on("view", (state)=>{
        if (option.autoMini) art.mini = !state;
    });
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"jKzGQ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>documentInit);
function documentInit(art, events) {
    events.proxy(document, "mousemove", (event)=>{
        art.emit("document:mousemove", event);
    });
    events.proxy(document, "mouseup", (event)=>{
        art.emit("document:mouseup", event);
    });
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"ONlxE":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>updateInit);
function updateInit(art) {
    if (art.constructor.USE_RAF) {
        let timer = null;
        (function update() {
            if (art.playing) art.emit("raf");
            if (!art.isDestroy) timer = requestAnimationFrame(update);
        })();
        art.on("destroy", ()=>{
            cancelAnimationFrame(timer);
        });
    }
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"f1oWx":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
class Hotkey {
    constructor(art){
        this.art = art;
        this.keys = {};
        if (art.option.hotkey && !(0, _utils.isMobile)) this.init();
    }
    init() {
        const { proxy, storage, constructor } = this.art;
        this.add(27, ()=>{
            if (this.art.fullscreenWeb) this.art.fullscreenWeb = false;
        });
        this.add(32, ()=>{
            this.art.toggle();
        });
        this.add(37, ()=>{
            this.art.backward = constructor.SEEK_STEP;
        });
        this.add(38, ()=>{
            this.art.volume += constructor.VOLUME_STEP;
        });
        this.add(39, ()=>{
            //this.art.forward = constructor.SEEK_STEP;
        });
        this.add(40, ()=>{
            this.art.volume -= constructor.VOLUME_STEP;
        });
        const longPressDuration = 500;
        var beforeTime = new Date().getTime();
        var keyStatus = 0;
        var before_playbackRate = 0;
        proxy(window, "keydown", (event)=>{
            if (this.art.isFocus) {
                const tag = document.activeElement.tagName.toUpperCase();
                const editable = document.activeElement.getAttribute("contenteditable");
                if (tag !== "INPUT" && tag !== "TEXTAREA" && editable !== "" && editable !== "true" && !event.altKey && !event.ctrlKey && !event.metaKey && !event.shiftKey) {
                    if (event.keyCode === 39) {
                        if (keyStatus === 1) {
                            //console.log("长按触发");
                            if (before_playbackRate === 0) {
                                before_playbackRate = art.playbackRate;
                            }else {
                                art.playbackRate = storage.getDefault("forwardSpeed", 3);
                                document.querySelector('.art-layer-notice-apeed').setAttribute('style','display:flex')
                            }
                        } else {
                            keyStatus = 1;
                            beforeTime = new Date().getTime();
                        }
                    }else {
                        const events = this.keys[event.keyCode];
                        if (events) {
                            event.preventDefault();
                            for(let index = 0; index < events.length; index++)events[index].call(this.art, event);
                            this.art.emit("hotkey", event);
                        }
                    }
                }
            }
        });
        proxy(window, "keyup", (event)=>{
            if (this.art.isFocus) {
                if (event.keyCode === 39) {
                    var now = new Date().getTime();
                    if ((now - beforeTime) < longPressDuration) {
                        //console.log("短按弹起", event)
                        art.forward = constructor.SEEK_STEP;
                    }else {
                        //console.log("长按弹起", event)
                        art.playbackRate = before_playbackRate;
                        document.querySelector('.art-layer-notice-apeed').setAttribute('style','display:none')
                        before_playbackRate = 0;
                    }
                    keyStatus = 0;
                }
            }
        });
    }
    add(key, event) {
        if (this.keys[key]) this.keys[key].push(event);
        else this.keys[key] = [
            event
        ];
        return this;
    }
    remove(key, event) {
        if (this.keys[key]) {
            const index = this.keys[key].indexOf(event);
            if (index !== -1) this.keys[key].splice(index, 1);
        }
        return this;
    }
}
exports.default = Hotkey;

},{"./utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"bKuSu":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _component = require("./utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
class Layer extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        const { option, template: { $layer } } = art;
        this.name = "layer";
        this.$parent = $layer;
        for(let index = 0; index < option.layers.length; index++)this.add(option.layers[index]);
    }
}
exports.default = Layer;

},{"./utils/component":"1UWqI","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"4AfId":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
var _component = require("./utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
class Loading extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.name = "loading";
        (0, _utils.append)(art.template.$loading, art.icons.loading);
    }
}
exports.default = Loading;

},{"./utils":"euhMG","./utils/component":"1UWqI","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"aKncc":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
class Notice {
    constructor(art){
        this.art = art;
        this.timer = null;
    }
    set show(msg) {
        const { constructor, template: { $player, $noticeInner } } = this.art;
        if (msg) {
            $noticeInner.innerText = msg instanceof Error ? msg.message.trim() : msg;
            (0, _utils.addClass)($player, "art-notice-show");
            clearTimeout(this.timer);
            this.timer = setTimeout(()=>{
                $noticeInner.innerText = "";
                (0, _utils.removeClass)($player, "art-notice-show");
            }, constructor.NOTICE_TIME);
        } else (0, _utils.removeClass)($player, "art-notice-show");
    }
}
exports.default = Notice;

},{"./utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"1R5LH":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("./utils");
var _component = require("./utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
class Mask extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        this.name = "mask";
        const { template, icons, events } = art;
        const $state = (0, _utils.append)(template.$state, icons.state);
        const $error = (0, _utils.append)(template.$state, icons.error);
        (0, _utils.setStyle)($error, "display", "none");
        art.on("destroy", ()=>{
            (0, _utils.setStyle)($state, "display", "none");
            (0, _utils.setStyle)($error, "display", null);
        });
        events.proxy(template.$state, "click", ()=>art.play());
    }
}
exports.default = Mask;

},{"./utils":"euhMG","./utils/component":"1UWqI","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"bPpva":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("../utils");
var _loadingSvg = require("bundle-text:./loading.svg");
var _loadingSvgDefault = parcelHelpers.interopDefault(_loadingSvg);
var _stateSvg = require("bundle-text:./state.svg");
var _stateSvgDefault = parcelHelpers.interopDefault(_stateSvg);
var _checkSvg = require("bundle-text:./check.svg");
var _checkSvgDefault = parcelHelpers.interopDefault(_checkSvg);
var _playSvg = require("bundle-text:./play.svg");
var _playSvgDefault = parcelHelpers.interopDefault(_playSvg);
var _pauseSvg = require("bundle-text:./pause.svg");
var _pauseSvgDefault = parcelHelpers.interopDefault(_pauseSvg);
var _volumeSvg = require("bundle-text:./volume.svg");
var _volumeSvgDefault = parcelHelpers.interopDefault(_volumeSvg);
var _volumeCloseSvg = require("bundle-text:./volume-close.svg");
var _volumeCloseSvgDefault = parcelHelpers.interopDefault(_volumeCloseSvg);
var _screenshotSvg = require("bundle-text:./screenshot.svg");
var _screenshotSvgDefault = parcelHelpers.interopDefault(_screenshotSvg);
var _settingSvg = require("bundle-text:./setting.svg");
var _settingSvgDefault = parcelHelpers.interopDefault(_settingSvg);
var _arrowLeftSvg = require("bundle-text:./arrow-left.svg");
var _arrowLeftSvgDefault = parcelHelpers.interopDefault(_arrowLeftSvg);
var _arrowRightSvg = require("bundle-text:./arrow-right.svg");
var _arrowRightSvgDefault = parcelHelpers.interopDefault(_arrowRightSvg);
var _playbackRateSvg = require("bundle-text:./playback-rate.svg");
var _playbackRateSvgDefault = parcelHelpers.interopDefault(_playbackRateSvg);
var _aspectRatioSvg = require("bundle-text:./aspect-ratio.svg");
var _aspectRatioSvgDefault = parcelHelpers.interopDefault(_aspectRatioSvg);
var _configSvg = require("bundle-text:./config.svg");
var _configSvgDefault = parcelHelpers.interopDefault(_configSvg);
var _pipSvg = require("bundle-text:./pip.svg");
var _pipSvgDefault = parcelHelpers.interopDefault(_pipSvg);
var _lockSvg = require("bundle-text:./lock.svg");
var _lockSvgDefault = parcelHelpers.interopDefault(_lockSvg);
var _unlockSvg = require("bundle-text:./unlock.svg");
var _unlockSvgDefault = parcelHelpers.interopDefault(_unlockSvg);
var _fullscreenOffSvg = require("bundle-text:./fullscreen-off.svg");
var _fullscreenOffSvgDefault = parcelHelpers.interopDefault(_fullscreenOffSvg);
var _fullscreenOnSvg = require("bundle-text:./fullscreen-on.svg");
var _fullscreenOnSvgDefault = parcelHelpers.interopDefault(_fullscreenOnSvg);
var _fullscreenWebOffSvg = require("bundle-text:./fullscreen-web-off.svg");
var _fullscreenWebOffSvgDefault = parcelHelpers.interopDefault(_fullscreenWebOffSvg);
var _fullscreenWebOnSvg = require("bundle-text:./fullscreen-web-on.svg");
var _fullscreenWebOnSvgDefault = parcelHelpers.interopDefault(_fullscreenWebOnSvg);
var _switchOnSvg = require("bundle-text:./switch-on.svg");
var _switchOnSvgDefault = parcelHelpers.interopDefault(_switchOnSvg);
var _switchOffSvg = require("bundle-text:./switch-off.svg");
var _switchOffSvgDefault = parcelHelpers.interopDefault(_switchOffSvg);
var _flipSvg = require("bundle-text:./flip.svg");
var _flipSvgDefault = parcelHelpers.interopDefault(_flipSvg);
var _errorSvg = require("bundle-text:./error.svg");
var _errorSvgDefault = parcelHelpers.interopDefault(_errorSvg);
var _closeSvg = require("bundle-text:./close.svg");
var _closeSvgDefault = parcelHelpers.interopDefault(_closeSvg);
var _airplaySvg = require("bundle-text:./airplay.svg");
var _airplaySvgDefault = parcelHelpers.interopDefault(_airplaySvg);
class Icons {
    constructor(art){
        const icons = {
            loading: (0, _loadingSvgDefault.default),
            state: (0, _stateSvgDefault.default),
            play: (0, _playSvgDefault.default),
            pause: (0, _pauseSvgDefault.default),
            check: (0, _checkSvgDefault.default),
            volume: (0, _volumeSvgDefault.default),
            volumeClose: (0, _volumeCloseSvgDefault.default),
            screenshot: (0, _screenshotSvgDefault.default),
            setting: (0, _settingSvgDefault.default),
            pip: (0, _pipSvgDefault.default),
            arrowLeft: (0, _arrowLeftSvgDefault.default),
            arrowRight: (0, _arrowRightSvgDefault.default),
            playbackRate: (0, _playbackRateSvgDefault.default),
            aspectRatio: (0, _aspectRatioSvgDefault.default),
            config: (0, _configSvgDefault.default),
            lock: (0, _lockSvgDefault.default),
            flip: (0, _flipSvgDefault.default),
            unlock: (0, _unlockSvgDefault.default),
            fullscreenOff: (0, _fullscreenOffSvgDefault.default),
            fullscreenOn: (0, _fullscreenOnSvgDefault.default),
            fullscreenWebOff: (0, _fullscreenWebOffSvgDefault.default),
            fullscreenWebOn: (0, _fullscreenWebOnSvgDefault.default),
            switchOn: (0, _switchOnSvgDefault.default),
            switchOff: (0, _switchOffSvgDefault.default),
            error: (0, _errorSvgDefault.default),
            close: (0, _closeSvgDefault.default),
            airplay: (0, _airplaySvgDefault.default),
            ...art.option.icons
        };
        for(const key in icons)(0, _utils.def)(this, key, {
            get: ()=>(0, _utils.getIcon)(key, icons[key])
        });
    }
}
exports.default = Icons;

},{"../utils":"euhMG","bundle-text:./loading.svg":"kSZpY","bundle-text:./state.svg":"l1cGI","bundle-text:./check.svg":"ihtKw","bundle-text:./play.svg":"aCrjI","bundle-text:./pause.svg":"djndS","bundle-text:./volume.svg":"3Mi6x","bundle-text:./volume-close.svg":"jxG45","bundle-text:./screenshot.svg":"eXfwA","bundle-text:./setting.svg":"kXSEM","bundle-text:./arrow-left.svg":"etyqn","bundle-text:./arrow-right.svg":"fU9m5","bundle-text:./playback-rate.svg":"wh93r","bundle-text:./aspect-ratio.svg":"2OSVS","bundle-text:./config.svg":"1WMKP","bundle-text:./pip.svg":"gGDL8","bundle-text:./lock.svg":"bDVqH","bundle-text:./unlock.svg":"b8r9U","bundle-text:./fullscreen-off.svg":"1F5ib","bundle-text:./fullscreen-on.svg":"6Nkxe","bundle-text:./fullscreen-web-off.svg":"akUW2","bundle-text:./fullscreen-web-on.svg":"5ohBx","bundle-text:./switch-on.svg":"2V2BU","bundle-text:./switch-off.svg":"cIVbn","bundle-text:./flip.svg":"eBNt7","bundle-text:./error.svg":"32zQ7","bundle-text:./close.svg":"9rzgA","bundle-text:./airplay.svg":"foceu","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"kSZpY":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"50px\" height=\"50px\" viewBox=\"0 0 100 100\" preserveAspectRatio=\"xMidYMid\" class=\"uil-default\">\n  <rect x=\"0\" y=\"0\" width=\"100\" height=\"100\" fill=\"none\" class=\"bk\"></rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(0 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-1s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(30 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.9166666666666666s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(60 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.8333333333333334s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(90 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.75s\" repeatCount=\"indefinite\"></animate></rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(120 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.6666666666666666s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(150 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.5833333333333334s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(180 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.5s\" repeatCount=\"indefinite\"></animate></rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(210 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.4166666666666667s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(240 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.3333333333333333s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(270 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.25s\" repeatCount=\"indefinite\"></animate></rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(300 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.16666666666666666s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n  <rect x=\"47\" y=\"40\" width=\"6\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#ffffff\" transform=\"rotate(330 50 50) translate(0 -30)\">\n    <animate attributeName=\"opacity\" from=\"1\" to=\"0\" dur=\"1s\" begin=\"-0.08333333333333333s\" repeatCount=\"indefinite\"></animate>\n  </rect>\n</svg>";

},{}],"l1cGI":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"80\" height=\"80\" viewBox=\"0 0 24 24\">\n<path fill=\"#fff\" d=\"M9.5 9.325v5.35q0 .575.525.875t1.025-.05l4.15-2.65q.475-.3.475-.85t-.475-.85L11.05 8.5q-.5-.35-1.025-.05t-.525.875ZM12 22q-2.075 0-3.9-.788t-3.175-2.137q-1.35-1.35-2.137-3.175T2 12q0-2.075.788-3.9t2.137-3.175q1.35-1.35 3.175-2.137T12 2q2.075 0 3.9.788t3.175 2.137q1.35 1.35 2.138 3.175T22 12q0 2.075-.788 3.9t-2.137 3.175q-1.35 1.35-3.175 2.138T12 22Z\"></path>\n</svg>\n";

},{}],"ihtKw":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 24 24\" style=\"width: 100%; height: 100%\">\n<path d=\"M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z\" fill=\"#fff\"></path>\n</svg>";

},{}],"aCrjI":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 22 22\">\n  <path d=\"M17.982 9.275L8.06 3.27A2.013 2.013 0 0 0 5 4.994v12.011a2.017 2.017 0 0 0 3.06 1.725l9.922-6.005a2.017 2.017 0 0 0 0-3.45z\"></path>\n</svg>";

},{}],"djndS":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 22 22\">\n    <path d=\"M7 3a2 2 0 0 0-2 2v12a2 2 0 1 0 4 0V5a2 2 0 0 0-2-2zM15 3a2 2 0 0 0-2 2v12a2 2 0 1 0 4 0V5a2 2 0 0 0-2-2z\"></path>\n</svg>";

},{}],"3Mi6x":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 22 22\">\n    <path d=\"M10.188 4.65L6 8H5a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h1l4.188 3.35a.5.5 0 0 0 .812-.39V5.04a.498.498 0 0 0-.812-.39zM14.446 3.778a1 1 0 0 0-.862 1.804 6.002 6.002 0 0 1-.007 10.838 1 1 0 0 0 .86 1.806A8.001 8.001 0 0 0 19 11a8.001 8.001 0 0 0-4.554-7.222z\"></path>\n    <path d=\"M15 11a3.998 3.998 0 0 0-2-3.465v6.93A3.998 3.998 0 0 0 15 11z\"></path>\n</svg>";

},{}],"jxG45":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 22 22\">\n    <path d=\"M15 11a3.998 3.998 0 0 0-2-3.465v2.636l1.865 1.865A4.02 4.02 0 0 0 15 11z\"></path>\n    <path d=\"M13.583 5.583A5.998 5.998 0 0 1 17 11a6 6 0 0 1-.585 2.587l1.477 1.477a8.001 8.001 0 0 0-3.446-11.286 1 1 0 0 0-.863 1.805zM18.778 18.778l-2.121-2.121-1.414-1.414-1.415-1.415L13 13l-2-2-3.889-3.889-3.889-3.889a.999.999 0 1 0-1.414 1.414L5.172 8H5a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h1l4.188 3.35a.5.5 0 0 0 .812-.39v-3.131l2.587 2.587-.01.005a1 1 0 0 0 .86 1.806c.215-.102.424-.214.627-.333l2.3 2.3a1.001 1.001 0 0 0 1.414-1.416zM11 5.04a.5.5 0 0 0-.813-.39L8.682 5.854 11 8.172V5.04z\"></path>\n</svg>";

},{}],"eXfwA":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 50 50\">\n\t<path d=\"M 19.402344 6 C 17.019531 6 14.96875 7.679688 14.5 10.011719 L 14.097656 12 L 9 12 C 6.238281 12 4 14.238281 4 17 L 4 38 C 4 40.761719 6.238281 43 9 43 L 41 43 C 43.761719 43 46 40.761719 46 38 L 46 17 C 46 14.238281 43.761719 12 41 12 L 35.902344 12 L 35.5 10.011719 C 35.03125 7.679688 32.980469 6 30.597656 6 Z M 25 17 C 30.519531 17 35 21.480469 35 27 C 35 32.519531 30.519531 37 25 37 C 19.480469 37 15 32.519531 15 27 C 15 21.480469 19.480469 17 25 17 Z M 25 19 C 20.589844 19 17 22.589844 17 27 C 17 31.410156 20.589844 35 25 35 C 29.410156 35 33 31.410156 33 27 C 33 22.589844 29.410156 19 25 19 Z \"></path>\n</svg>\n";

},{}],"kXSEM":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"22\" width=\"22\" viewBox=\"0 0 22 22\">\n    <circle cx=\"11\" cy=\"11\" r=\"2\"></circle>\n    <path d=\"M19.164 8.861L17.6 8.6a6.978 6.978 0 0 0-1.186-2.099l.574-1.533a1 1 0 0 0-.436-1.217l-1.997-1.153a1.001 1.001 0 0 0-1.272.23l-1.008 1.225a7.04 7.04 0 0 0-2.55.001L8.716 2.829a1 1 0 0 0-1.272-.23L5.447 3.751a1 1 0 0 0-.436 1.217l.574 1.533A6.997 6.997 0 0 0 4.4 8.6l-1.564.261A.999.999 0 0 0 2 9.847v2.306c0 .489.353.906.836.986l1.613.269a7 7 0 0 0 1.228 2.075l-.558 1.487a1 1 0 0 0 .436 1.217l1.997 1.153c.423.244.961.147 1.272-.23l1.04-1.263a7.089 7.089 0 0 0 2.272 0l1.04 1.263a1 1 0 0 0 1.272.23l1.997-1.153a1 1 0 0 0 .436-1.217l-.557-1.487c.521-.61.94-1.31 1.228-2.075l1.613-.269a.999.999 0 0 0 .835-.986V9.847a.999.999 0 0 0-.836-.986zM11 15a4 4 0 1 1 0-8 4 4 0 0 1 0 8z\"></path>\n</svg>";

},{}],"etyqn":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"32\" width=\"32\" version=\"1.1\" viewBox=\"0 0 32 32\">\n    <path d=\"M 19.41,20.09 14.83,15.5 19.41,10.91 18,9.5 l -6,6 6,6 z\" fill=\"#fff\"></path>\n</svg>";

},{}],"fU9m5":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"32\" width=\"32\" version=\"1.1\" viewBox=\"0 0 32 32\">\n    <path d=\"m 12.59,20.34 4.58,-4.59 -4.58,-4.59 1.41,-1.41 6,6 -6,6 z\" fill=\"#fff\"></path>\n</svg>";

},{}],"wh93r":[function(require,module,exports) {
module.exports = "<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\"><path d=\"M10,8v8l6-4L10,8L10,8z M6.3,5L5.7,4.2C7.2,3,9,2.2,11,2l0.1,1C9.3,3.2,7.7,3.9,6.3,5z            M5,6.3L4.2,5.7C3,7.2,2.2,9,2,11 l1,.1C3.2,9.3,3.9,7.7,5,6.3z            M5,17.7c-1.1-1.4-1.8-3.1-2-4.8L2,13c0.2,2,1,3.8,2.2,5.4L5,17.7z            M11.1,21c-1.8-0.2-3.4-0.9-4.8-2 l-0.6,.8C7.2,21,9,21.8,11,22L11.1,21z            M22,12c0-5.2-3.9-9.4-9-10l-0.1,1c4.6,.5,8.1,4.3,8.1,9s-3.5,8.5-8.1,9l0.1,1 C18.2,21.5,22,17.2,22,12z\" fill=\"white\" data-darkreader-inline-fill=\"\" style=\"--darkreader-inline-fill: #a8a6a4\"></path></svg>";

},{}],"2OSVS":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 88 88\" preserveAspectRatio=\"xMidYMid meet\" style=\"width: 100%; height: 100%; transform: translate3d(0, 0, 0)\"><defs><clipPath id=\"__lottie_element_216\"><rect width=\"88\" height=\"88\" x=\"0\" y=\"0\"></rect></clipPath></defs><g clip-path=\"url('#__lottie_element_216')\"><g transform=\"matrix(1,0,0,1,44,44)\" opacity=\"1\" style=\"display: block\"><g opacity=\"1\" transform=\"matrix(1,0,0,1,0,0)\"><path fill=\"rgb(255,255,255)\" fill-opacity=\"1\" d=\" M12.437999725341797,-12.70199966430664 C12.437999725341797,-12.70199966430664 9.618000030517578,-9.881999969482422 9.618000030517578,-9.881999969482422 C8.82800006866455,-9.092000007629395 8.82800006866455,-7.831999778747559 9.618000030517578,-7.052000045776367 C9.618000030517578,-7.052000045776367 16.687999725341797,0.017999999225139618 16.687999725341797,0.017999999225139618 C16.687999725341797,0.017999999225139618 9.618000030517578,7.0879998207092285 9.618000030517578,7.0879998207092285 C8.82800006866455,7.877999782562256 8.82800006866455,9.137999534606934 9.618000030517578,9.918000221252441 C9.618000030517578,9.918000221252441 12.437999725341797,12.748000144958496 12.437999725341797,12.748000144958496 C13.227999687194824,13.527999877929688 14.48799991607666,13.527999877929688 15.267999649047852,12.748000144958496 C15.267999649047852,12.748000144958496 26.58799934387207,1.437999963760376 26.58799934387207,1.437999963760376 C27.368000030517578,0.6579999923706055 27.368000030517578,-0.6119999885559082 26.58799934387207,-1.3919999599456787 C26.58799934387207,-1.3919999599456787 15.267999649047852,-12.70199966430664 15.267999649047852,-12.70199966430664 C14.48799991607666,-13.491999626159668 13.227999687194824,-13.491999626159668 12.437999725341797,-12.70199966430664z M-12.442000389099121,-12.70199966430664 C-13.182000160217285,-13.442000389099121 -14.362000465393066,-13.482000350952148 -15.142000198364258,-12.821999549865723 C-15.142000198364258,-12.821999549865723 -15.272000312805176,-12.70199966430664 -15.272000312805176,-12.70199966430664 C-15.272000312805176,-12.70199966430664 -26.582000732421875,-1.3919999599456787 -26.582000732421875,-1.3919999599456787 C-27.32200050354004,-0.6520000100135803 -27.36199951171875,0.5180000066757202 -26.70199966430664,1.3079999685287476 C-26.70199966430664,1.3079999685287476 -26.582000732421875,1.437999963760376 -26.582000732421875,1.437999963760376 C-26.582000732421875,1.437999963760376 -15.272000312805176,12.748000144958496 -15.272000312805176,12.748000144958496 C-14.531999588012695,13.48799991607666 -13.362000465393066,13.527999877929688 -12.571999549865723,12.868000030517578 C-12.571999549865723,12.868000030517578 -12.442000389099121,12.748000144958496 -12.442000389099121,12.748000144958496 C-12.442000389099121,12.748000144958496 -9.612000465393066,9.918000221252441 -9.612000465393066,9.918000221252441 C-8.871999740600586,9.178000450134277 -8.831999778747559,8.008000373840332 -9.501999855041504,7.2179999351501465 C-9.501999855041504,7.2179999351501465 -9.612000465393066,7.0879998207092285 -9.612000465393066,7.0879998207092285 C-9.612000465393066,7.0879998207092285 -16.68199920654297,0.017999999225139618 -16.68199920654297,0.017999999225139618 C-16.68199920654297,0.017999999225139618 -9.612000465393066,-7.052000045776367 -9.612000465393066,-7.052000045776367 C-8.871999740600586,-7.791999816894531 -8.831999778747559,-8.961999893188477 -9.501999855041504,-9.751999855041504 C-9.501999855041504,-9.751999855041504 -9.612000465393066,-9.881999969482422 -9.612000465393066,-9.881999969482422 C-9.612000465393066,-9.881999969482422 -12.442000389099121,-12.70199966430664 -12.442000389099121,-12.70199966430664z M28,-28 C32.41999816894531,-28 36,-24.420000076293945 36,-20 C36,-20 36,20 36,20 C36,24.420000076293945 32.41999816894531,28 28,28 C28,28 -28,28 -28,28 C-32.41999816894531,28 -36,24.420000076293945 -36,20 C-36,20 -36,-20 -36,-20 C-36,-24.420000076293945 -32.41999816894531,-28 -28,-28 C-28,-28 28,-28 28,-28z\" data-darkreader-inline-fill=\"\" style=\"--darkreader-inline-fill: #a8a6a4\"></path></g></g></g></svg>";

},{}],"1WMKP":[function(require,module,exports) {
module.exports = "<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\"><path d=\"M15,17h6v1h-6V17z M11,17H3v1h8v2h1v-2v-1v-2h-1V17z M14,8h1V6V5V3h-1v2H3v1h11V8z            M18,5v1h3V5H18z M6,14h1v-2v-1V9H6v2H3v1 h3V14z M10,12h11v-1H10V12z\" fill=\"white\" data-darkreader-inline-fill=\"\" style=\"--darkreader-inline-fill: #a8a6a4\"></path></svg>";

},{}],"gGDL8":[function(require,module,exports) {
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 36 36\" height=\"32\" width=\"32\">\n    <path d=\"M25,17 L17,17 L17,23 L25,23 L25,17 L25,17 Z M29,25 L29,10.98 C29,9.88 28.1,9 27,9 L9,9 C7.9,9 7,9.88 7,10.98 L7,25 C7,26.1 7.9,27 9,27 L27,27 C28.1,27 29,26.1 29,25 L29,25 Z M27,25.02 L9,25.02 L9,10.97 L27,10.97 L27,25.02 L27,25.02 Z\"></path>\n</svg>";

},{}],"bDVqH":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg t=\"1650612139149\" class=\"icon\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"12683\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"20\" height=\"20\"><defs>\n<style type=\"text/css\"></style></defs><path d=\"M298.666667 426.666667V341.333333a213.333333 213.333333 0 1 1 426.666666 0v85.333334h42.666667a85.333333 85.333333 0 0 1 85.333333 85.333333v256a85.333333 85.333333 0 0 1-85.333333 85.333333H256a85.333333 85.333333 0 0 1-85.333333-85.333333v-256a85.333333 85.333333 0 0 1 85.333333-85.333333h42.666667z m213.333333-213.333334a128 128 0 0 0-128 128v85.333334h256V341.333333a128 128 0 0 0-128-128z\" fill=\"#ffffff\" p-id=\"12684\"></path>\n</svg>";

},{}],"b8r9U":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg t=\"1650612464266\" class=\"icon\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"14150\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"20\" height=\"20\"><defs>\n<style type=\"text/css\"></style></defs><path d=\"M666.752 194.517333L617.386667 268.629333A128 128 0 0 0 384 341.333333l0.042667 85.333334h384a85.333333 85.333333 0 0 1 85.333333 85.333333v256a85.333333 85.333333 0 0 1-85.333333 85.333333H256a85.333333 85.333333 0 0 1-85.333333-85.333333v-256a85.333333 85.333333 0 0 1 85.333333-85.333333h42.666667V341.333333a213.333333 213.333333 0 0 1 368.085333-146.816z\" fill=\"#ffffff\" p-id=\"14151\"></path></svg>";

},{}],"1F5ib":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"22\" height=\"22\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill=\"#ffffff\" d=\"M768 298.666667h170.666667v85.333333h-256V128h85.333333v170.666667zM341.333333 384H85.333333V298.666667h170.666667V128h85.333333v256z m426.666667 341.333333v170.666667h-85.333333v-256h256v85.333333h-170.666667zM341.333333 640v256H256v-170.666667H85.333333v-85.333333h256z\"></path>\n</svg>";

},{}],"6Nkxe":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"22\" height=\"22\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill=\"#ffffff\" d=\"M625.777778 256h142.222222V398.222222h113.777778V142.222222H625.777778v113.777778zM256 398.222222V256H398.222222v-113.777778H142.222222V398.222222h113.777778zM768 625.777778v142.222222H625.777778v113.777778h256V625.777778h-113.777778zM398.222222 768H256V625.777778h-113.777778v256H398.222222v-113.777778z\"></path>\n</svg>";

},{}],"akUW2":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"18\" height=\"18\" viewBox=\"0 0 1152 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill=\"#ffffff\" d=\"M1075.2 0H76.8A76.8 76.8 0 0 0 0 76.8v870.4A76.8 76.8 0 0 0 76.8 1024h998.4a76.8 76.8 0 0 0 76.8-76.8V76.8A76.8 76.8 0 0 0 1075.2 0zM1024 128v768H128V128h896zM896 512a64 64 0 0 1 7.488 127.552L896 640h-128v128a64 64 0 0 1-56.512 63.552L704 832a64 64 0 0 1-63.552-56.512L640 768V582.592c0-34.496 25.024-66.112 61.632-70.208L709.632 512H896zM256 512a64 64 0 0 1-7.488-127.552L256 384h128V256a64 64 0 0 1 56.512-63.552L448 192a64 64 0 0 1 63.552 56.512L512 256v185.408c0 34.432-25.024 66.112-61.632 70.144L442.368 512H256z\"></path>\n</svg>";

},{}],"5ohBx":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"18\" height=\"18\" viewBox=\"0 0 1152 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill=\"#ffffff\" d=\"M1075.2 0H76.8A76.8 76.8 0 0 0 0 76.8v870.4A76.8 76.8 0 0 0 76.8 1024h998.4a76.8 76.8 0 0 0 76.8-76.8V76.8A76.8 76.8 0 0 0 1075.2 0zM1024 128v768H128V128h896zM448 192a64 64 0 0 1 7.488 127.552L448 320H320v128a64 64 0 0 1-56.512 63.552L256 512a64 64 0 0 1-63.552-56.512L192 448V262.592c0-34.432 25.024-66.112 61.632-70.144L261.632 192H448zM704 832a64 64 0 0 1-7.488-127.552L704 704h128V576a64 64 0 0 1 56.512-63.552L896 512a64 64 0 0 1 63.552 56.512L960 576v185.408c0 34.496-25.024 66.112-61.632 70.208l-8 0.384H704z\"></path>\n</svg>";

},{}],"2V2BU":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"26\" height=\"26\" viewBox=\"0 0 1664 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path fill=\"#648FFC\" d=\"M1152 0H512a512 512 0 0 0 0 1024h640a512 512 0 0 0 0-1024z m0 960a448 448 0 1 1 448-448 448 448 0 0 1-448 448z\"></path>\n</svg>";

},{}],"cIVbn":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg class=\"icon\" width=\"26\" height=\"26\" viewBox=\"0 0 1740 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path fill=\"#ffffff\" d=\"M511.8976 1024h670.5152c282.4192-0.4096 511.1808-229.4784 511.1808-511.8976 0-282.4192-228.7616-511.488-511.1808-511.8976H511.8976C229.4784 0.6144 0.7168 229.6832 0.7168 512.1024c0 282.4192 228.7616 511.488 511.1808 511.8976zM511.3344 48.64A464.5888 464.5888 0 1 1 48.0256 513.024 463.872 463.872 0 0 1 511.3344 48.4352V48.64z\"></path>\n</svg>";

},{}],"eBNt7":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg t=\"1652445277062\" class=\"icon\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"6034\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"24\" height=\"24\">\n<path d=\"M554.666667 810.666667v85.333333h-85.333334v-85.333333h85.333334zM170.666667 178.005333a42.666667 42.666667 0 0 1 34.986666 18.218667l203.904 291.328a42.666667 42.666667 0 0 1 0 48.896l-203.946666 291.328A42.666667 42.666667 0 0 1 128 803.328V220.672a42.666667 42.666667 0 0 1 42.666667-42.666667z m682.666666 0a42.666667 42.666667 0 0 1 42.368 37.717334l0.298667 4.949333v582.656a42.666667 42.666667 0 0 1-74.24 28.629333l-3.413333-4.181333-203.904-291.328a42.666667 42.666667 0 0 1-3.029334-43.861333l3.029334-5.034667 203.946666-291.328A42.666667 42.666667 0 0 1 853.333333 178.005333zM554.666667 640v85.333333h-85.333334v-85.333333h85.333334zM196.266667 319.104V716.8L335.957333 512 196.309333 319.104zM554.666667 469.333333v85.333334h-85.333334v-85.333334h85.333334z m0-170.666666v85.333333h-85.333334V298.666667h85.333334z m0-170.666667v85.333333h-85.333334V128h85.333334z\" fill=\"#ffffff\" p-id=\"6035\">\n</path>\n</svg>";

},{}],"32zQ7":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg t=\"1652850026663\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"2749\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"50\" height=\"50\">\n<path d=\"M593.8176 168.5504l356.00384 595.21024c26.15296 43.74528 10.73152 99.7376-34.44736 125.05088-14.39744 8.06912-30.72 12.30848-47.37024 12.30848H155.97568C103.75168 901.12 61.44 860.16 61.44 809.61536c0-16.09728 4.38272-31.92832 12.71808-45.8752L430.16192 168.5504c26.17344-43.7248 84.00896-58.65472 129.20832-33.34144a93.0816 93.0816 0 0 1 34.44736 33.34144zM512 819.2a61.44 61.44 0 1 0 0-122.88 61.44 61.44 0 0 0 0 122.88z m0-512a72.31488 72.31488 0 0 0-71.76192 81.3056l25.72288 205.7216a46.40768 46.40768 0 0 0 92.07808 0l25.72288-205.74208A72.31488 72.31488 0 0 0 512 307.2z\" p-id=\"2750\">\n</path>\n</svg>";

},{}],"9rzgA":[function(require,module,exports) {
module.exports = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg t=\"1655876154826\" class=\"icon\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"22\" height=\"22\">\n<path d=\"M571.733333 512l268.8-268.8c17.066667-17.066667 17.066667-42.666667 0-59.733333-17.066667-17.066667-42.666667-17.066667-59.733333 0L512 452.266667 243.2 183.466667c-17.066667-17.066667-42.666667-17.066667-59.733333 0-17.066667 17.066667-17.066667 42.666667 0 59.733333L452.266667 512 183.466667 780.8c-17.066667 17.066667-17.066667 42.666667 0 59.733333 8.533333 8.533333 19.2 12.8 29.866666 12.8s21.333333-4.266667 29.866667-12.8L512 571.733333l268.8 268.8c8.533333 8.533333 19.2 12.8 29.866667 12.8s21.333333-4.266667 29.866666-12.8c17.066667-17.066667 17.066667-42.666667 0-59.733333L571.733333 512z\" p-id=\"2131\">\n</path>\n</svg>";

},{}],"foceu":[function(require,module,exports) {
module.exports = "<svg width=\"18px\" height=\"18px\" viewBox=\"0 0 18 18\" xmlns=\"http://www.w3.org/2000/svg\">\n    <g>\n        <path fill=\"#fff\" d=\"M16,1 L2,1 C1.447,1 1,1.447 1,2 L1,12 C1,12.553 1.447,13 2,13 L5,13 L5,11 L3,11 L3,3 L15,3 L15,11 L13,11 L13,13 L16,13 C16.553,13 17,12.553 17,12 L17,2 C17,1.447 16.553,1 16,1 L16,1 Z\"></path>\n        <polygon fill=\"#fff\" points=\"4 17 14 17 9 11\"></polygon>\n    </g>\n</svg>";

},{}],"i2oRN":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _flip = require("./flip");
var _flipDefault = parcelHelpers.interopDefault(_flip);
var _aspectRatio = require("./aspectRatio");
var _aspectRatioDefault = parcelHelpers.interopDefault(_aspectRatio);
var _playbackRate = require("./playbackRate");
var _playbackRateDefault = parcelHelpers.interopDefault(_playbackRate);
var _subtitleOffset = require("./subtitleOffset");
var _subtitleOffsetDefault = parcelHelpers.interopDefault(_subtitleOffset);
var _component = require("../utils/component");
var _componentDefault = parcelHelpers.interopDefault(_component);
var _error = require("../utils/error");
var _utils = require("../utils");
class Setting extends (0, _componentDefault.default) {
    constructor(art){
        super(art);
        const { option, controls, template: { $setting } } = art;
        this.name = "setting";
        this.$parent = $setting;
        this.option = [];
        this.events = [];
        this.cache = new Map();
        if (option.setting) {
            this.init();
            art.on("blur", ()=>{
                if (this.show) {
                    this.show = false;
                    this.render(this.option);
                }
            });
            art.on("focus", (event)=>{
                const isSetting = (0, _utils.includeFromEvent)(event, controls.setting);
                const isParent = (0, _utils.includeFromEvent)(event, this.$parent);
                if (this.show && !isSetting && !isParent) {
                    this.show = false;
                    this.render(this.option);
                }
            });
        }
    }
    static makeRecursion(option, parentItem, parentList) {
        for(let index = 0; index < option.length; index++){
            const item = option[index];
            item.$parentItem = parentItem;
            item.$parentList = parentList;
            Setting.makeRecursion(item.selector || [], item, option);
        }
        return option;
    }
    get defaultSettings() {
        const result = [];
        const { option } = this.art;
        if (option.playbackRate) result.push((0, _playbackRateDefault.default)(this.art));
        if (option.aspectRatio) result.push((0, _aspectRatioDefault.default)(this.art));
        if (option.flip) result.push((0, _flipDefault.default)(this.art));
        if (option.subtitleOffset) result.push((0, _subtitleOffsetDefault.default)(this.art));
        return result;
    }
    init() {
        const { option } = this.art;
        const mergeSettings = [
            ...this.defaultSettings,
            ...option.settings
        ];
        this.option = Setting.makeRecursion(mergeSettings);
        this.destroy();
        this.render(this.option);
    }
    destroy() {
        for(let index = 0; index < this.events.length; index++)this.art.events.remove(this.events[index]);
        this.$parent.innerHTML = "";
        this.events = [];
        this.cache = new Map();
    }
    find(name = "", option = this.option) {
        for(let index = 0; index < option.length; index++){
            const item = option[index];
            if (item.name === name) return item;
            else {
                const result = this.find(name, item.selector || []);
                if (result) return result;
            }
        }
    }
    remove(name) {
        const item = this.find(name);
        (0, _error.errorHandle)(item, `Can't find [${name}] from the [setting]`);
        const parent = item.$parentItem ? item.$parentItem.selector : this.option;
        parent.splice(parent.indexOf(item), 1);
        this.option = Setting.makeRecursion(this.option);
        this.destroy();
        this.render(this.option);
        return this.option;
    }
    update(setting) {
        const item = this.find(setting.name);
        if (item) {
            Object.assign(item, setting);
            this.option = Setting.makeRecursion(this.option);
            this.destroy();
            this.render(this.option);
        } else this.add(setting);
        return this.option;
    }
    add(setting) {
        this.option.push(setting);
        this.option = Setting.makeRecursion(this.option);
        this.destroy();
        this.render(this.option);
        return this.option;
    }
    creatHeader(item) {
        const { icons, proxy, constructor } = this.art;
        const $item = (0, _utils.createElement)("div");
        (0, _utils.setStyle)($item, "height", `${constructor.SETTING_ITEM_HEIGHT}px`);
        (0, _utils.addClass)($item, "art-setting-item");
        (0, _utils.addClass)($item, "art-setting-item-back");
        const $left = (0, _utils.append)($item, '<div class="art-setting-item-left"></div>');
        const $icon = (0, _utils.createElement)("div");
        (0, _utils.addClass)($icon, "art-setting-item-left-icon");
        (0, _utils.append)($icon, icons.arrowLeft);
        (0, _utils.append)($left, $icon);
        (0, _utils.append)($left, item.$parentItem.html);
        const event = proxy($item, "click", ()=>this.render(item.$parentList));
        this.events.push(event);
        return $item;
    }
    creatItem(type, item) {
        const { icons, proxy, constructor } = this.art;
        const $item = (0, _utils.createElement)("div");
        (0, _utils.addClass)($item, "art-setting-item");
        (0, _utils.setStyle)($item, "height", `${constructor.SETTING_ITEM_HEIGHT}px`);
        if ((0, _utils.isStringOrNumber)(item.name)) $item.dataset.name = item.name;
        if ((0, _utils.isStringOrNumber)(item.value)) $item.dataset.value = item.value;
        const $left = (0, _utils.append)($item, '<div class="art-setting-item-left"></div>');
        const $right = (0, _utils.append)($item, '<div class="art-setting-item-right"></div>');
        const $icon = (0, _utils.createElement)("div");
        (0, _utils.addClass)($icon, "art-setting-item-left-icon");
        switch(type){
            case "switch":
            case "range":
                (0, _utils.append)($icon, (0, _utils.isStringOrNumber)(item.icon) || item.icon instanceof Element ? item.icon : icons.config);
                break;
            case "custom":
                (0, _utils.append)($icon, (0, _utils.isStringOrNumber)(item.icon) || item.icon instanceof Element ? item.icon : icons.config);
                break;
            case "selector":
                if (item.selector && item.selector.length) (0, _utils.append)($icon, (0, _utils.isStringOrNumber)(item.icon) || item.icon instanceof Element ? item.icon : icons.config);
                else (0, _utils.append)($icon, icons.check);
                break;
            default:
                break;
        }
        (0, _utils.append)($left, $icon);
        item.$icon = $icon;
        (0, _utils.def)(item, "icon", {
            configurable: true,
            get () {
                return $icon.innerHTML;
            },
            set (value) {
                if ((0, _utils.isStringOrNumber)(value)) $icon.innerHTML = value;
            }
        });
        const $html = (0, _utils.createElement)("div");
        (0, _utils.addClass)($html, "art-setting-item-left-text");
        (0, _utils.append)($html, item.html || "");
        (0, _utils.append)($left, $html);
        item.$html = $html;
        (0, _utils.def)(item, "html", {
            configurable: true,
            get () {
                return $html.innerHTML;
            },
            set (value) {
                if ((0, _utils.isStringOrNumber)(value)) $html.innerHTML = value;
            }
        });
        const $tooltip = (0, _utils.createElement)("div");
        (0, _utils.addClass)($tooltip, "art-setting-item-right-tooltip");
        (0, _utils.append)($tooltip, item.tooltip || "");
        (0, _utils.append)($right, $tooltip);
        item.$tooltip = $tooltip;
        (0, _utils.def)(item, "tooltip", {
            configurable: true,
            get () {
                return $tooltip.innerHTML;
            },
            set (value) {
                if ((0, _utils.isStringOrNumber)(value)) $tooltip.innerHTML = value;
            }
        });
        switch(type){
            case "switch":
                {
                    const $state = (0, _utils.createElement)("div");
                    (0, _utils.addClass)($state, "art-setting-item-right-icon");
                    const $switchOn = (0, _utils.append)($state, icons.switchOn);
                    const $switchOff = (0, _utils.append)($state, icons.switchOff);
                    (0, _utils.setStyle)(item.switch ? $switchOff : $switchOn, "display", "none");
                    (0, _utils.append)($right, $state);
                    item.$switch = item.switch;
                    (0, _utils.def)(item, "switch", {
                        configurable: true,
                        get () {
                            return item.$switch;
                        },
                        set (value) {
                            item.$switch = value;
                            if (value) {
                                (0, _utils.setStyle)($switchOff, "display", "none");
                                (0, _utils.setStyle)($switchOn, "display", null);
                            } else {
                                (0, _utils.setStyle)($switchOff, "display", null);
                                (0, _utils.setStyle)($switchOn, "display", "none");
                            }
                        }
                    });
                    break;
                }
            case "range":
                {
                    const $state = (0, _utils.createElement)("div");
                    (0, _utils.addClass)($state, "art-setting-item-right-icon");
                    const $range = (0, _utils.append)($state, '<input type="range">');
                    $range.value = item.range[0] || 0;
                    $range.min = item.range[1] || 0;
                    $range.max = item.range[2] || 10;
                    $range.step = item.range[3] || 1;
                    (0, _utils.addClass)($range, "art-setting-range");
                    (0, _utils.append)($right, $state);
                    item.$range = $range;
                    (0, _utils.def)(item, "range", {
                        configurable: true,
                        get () {
                            return $range.valueAsNumber;
                        },
                        set (value) {
                            $range.value = Number(value);
                        }
                    });
                }
                break;
            case "custom":
                {
                    const $state = (0, _utils.createElement)("div");
                    (0, _utils.addClass)($state, "art-setting-item-right-icon");
                    const $range = (0, _utils.append)($state, item.custom);
                    (0, _utils.addClass)($range, "art-setting-custom");
                    (0, _utils.append)($right, $state);
                }
                break;
            case "selector":
                if (item.selector && item.selector.length) {
                    const $state = (0, _utils.createElement)("div");
                    (0, _utils.addClass)($state, "art-setting-item-right-icon");
                    (0, _utils.append)($state, icons.arrowRight);
                    (0, _utils.append)($right, $state);
                }
                break;
            default:
                break;
        }
        switch(type){
            case "switch":
                if (item.onSwitch) {
                    const event = proxy($item, "click", async (event)=>{
                        item.switch = await item.onSwitch.call(this.art, item, $item, event);
                    });
                    this.events.push(event);
                }
                break;
            case "range":
                if (item.$range) {
                    if (item.onRange) {
                        const event = proxy(item.$range, "change", async (event)=>{
                            item.tooltip = await item.onRange.call(this.art, item, $item, event);
                        });
                        this.events.push(event);
                    }
                    if (item.onChange) {
                        const event = proxy(item.$range, "input", async (event)=>{
                            item.tooltip = await item.onChange.call(this.art, item, $item, event);
                        });
                        this.events.push(event);
                    }
                }
                break;
            case "custom":
                if (item.$range) {
                    if (item.onRange) {
                        const event = proxy(item.$range, "change", async (event)=>{
                            item.tooltip = await item.onRange.call(this.art, item, $item, event);
                        });
                        this.events.push(event);
                    }
                    if (item.onChange) {
                        const event = proxy(item.$range, "input", async (event)=>{
                            item.tooltip = await item.onChange.call(this.art, item, $item, event);
                        });
                        this.events.push(event);
                    }
                }
                break;
            case "selector":
                {
                    const event = proxy($item, "click", async (event)=>{
                        if (item.selector && item.selector.length) this.render(item.selector, item.width);
                        else {
                            (0, _utils.inverseClass)($item, "art-current");
                            for(let index = 0; index < item.$parentItem.selector.length; index++){
                                const element = item.$parentItem.selector[index];
                                element.default = element === item;
                            }
                            if (item.$parentList) this.render(item.$parentList);
                            if (item.$parentItem && item.$parentItem.onSelect) {
                                const result = await item.$parentItem.onSelect.call(this.art, item, $item, event);
                                if (item.$parentItem.$tooltip && (0, _utils.isStringOrNumber)(result)) item.$parentItem.$tooltip.innerHTML = result;
                            }
                        }
                    });
                    this.events.push(event);
                    if (item.default) (0, _utils.addClass)($item, "art-current");
                }
                break;
            default:
                break;
        }
        return $item;
    }
    updateStyle(width) {
        const { controls, constructor, template: { $player, $setting } } = this.art;
        if (controls.setting && !(0, _utils.isMobile)) {
            const settingWidth = width || constructor.SETTING_WIDTH;
            const { left: controlLeft, width: controlWidth } = (0, _utils.getRect)(controls.setting);
            const { left: playerLeft, width: playerWidth } = (0, _utils.getRect)($player);
            const settingLeft = controlLeft - playerLeft + controlWidth / 2 - settingWidth / 2;
            if (settingLeft + settingWidth > playerWidth) {
                (0, _utils.setStyle)($setting, "left", null);
                (0, _utils.setStyle)($setting, "right", null);
            } else {
                (0, _utils.setStyle)($setting, "left", `${settingLeft}px`);
                (0, _utils.setStyle)($setting, "right", "auto");
            }
        }
    }
    render(option, width) {
        const { constructor } = this.art;
        if (this.cache.has(option)) {
            const $panel = this.cache.get(option);
            (0, _utils.inverseClass)($panel, "art-current");
            (0, _utils.setStyle)(this.$parent, "width", `${$panel.dataset.width}px`);
            (0, _utils.setStyle)(this.$parent, "height", `${$panel.dataset.height}px`);
            this.updateStyle(Number($panel.dataset.width));
        } else {
            const $panel = (0, _utils.createElement)("div");
            (0, _utils.addClass)($panel, "art-setting-panel");
            $panel.dataset.width = width || constructor.SETTING_WIDTH;
            $panel.dataset.height = option.length * constructor.SETTING_ITEM_HEIGHT;
            if (option[0] && option[0].$parentItem) {
                (0, _utils.append)($panel, this.creatHeader(option[0]));
                $panel.dataset.height = Number($panel.dataset.height) + constructor.SETTING_ITEM_HEIGHT;
            }
            for(let index = 0; index < option.length; index++){
                const item = option[index];
                if ((0, _utils.has)(item, "switch")) (0, _utils.append)($panel, this.creatItem("switch", item));
                else if ((0, _utils.has)(item, "range")) (0, _utils.append)($panel, this.creatItem("range", item));
                else if ((0, _utils.has)(item, "custom")) (0, _utils.append)($panel, this.creatItem("custom", item));
                else (0, _utils.append)($panel, this.creatItem("selector", item));
            }
            (0, _utils.append)(this.$parent, $panel);
            this.cache.set(option, $panel);
            (0, _utils.inverseClass)($panel, "art-current");
            (0, _utils.setStyle)(this.$parent, "width", `${$panel.dataset.width}px`);
            (0, _utils.setStyle)(this.$parent, "height", `${$panel.dataset.height}px`);
            this.updateStyle(Number($panel.dataset.width));
            if (option[0] && option[0].$parentItem && option[0].$parentItem.mounted) option[0].$parentItem.mounted.call(this.art, $panel, option[0].$parentItem);
        }
    }
}
exports.default = Setting;

},{"./flip":"cyEw6","./aspectRatio":"l7RGi","./playbackRate":"l9tWN","./subtitleOffset":"lQoyH","../utils/component":"1UWqI","../utils/error":"kCmly","../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"cyEw6":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>flip);
var _utils = require("../utils");
function flip(art) {
    const { i18n, icons, constructor: { SETTING_ITEM_WIDTH, FLIP } } = art;
    function update($panel, $tooltip, value) {
        if ($tooltip) $tooltip.innerText = i18n.get((0, _utils.capitalize)(value));
        const $current = (0, _utils.queryAll)(".art-setting-item", $panel).find((item)=>item.dataset.value === value);
        if ($current) (0, _utils.inverseClass)($current, "art-current");
    }
    return {
        width: SETTING_ITEM_WIDTH,
        name: "flip",
        html: i18n.get("Video Flip"),
        tooltip: i18n.get((0, _utils.capitalize)(art.flip)),
        icon: icons.flip,
        selector: FLIP.map((item)=>{
            return {
                value: item,
                name: `aspect-ratio-${item}`,
                default: item === art.flip,
                html: i18n.get((0, _utils.capitalize)(item))
            };
        }),
        onSelect (item) {
            art.flip = item.value;
            return item.html;
        },
        mounted: ($panel, item)=>{
            update($panel, item.$tooltip, art.flip);
            art.on("flip", ()=>{
                update($panel, item.$tooltip, art.flip);
            });
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"l7RGi":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>aspectRatio);
var _utils = require("../utils");
function aspectRatio(art) {
    const { i18n, icons, constructor: { SETTING_ITEM_WIDTH, ASPECT_RATIO } } = art;
    function getI18n(value) {
        return value === "default" ? i18n.get("Default") : value;
    }
    function update($panel, $tooltip, value) {
        if ($tooltip) $tooltip.innerText = getI18n(value);
        const $current = (0, _utils.queryAll)(".art-setting-item", $panel).find((item)=>item.dataset.value === value);
        if ($current) (0, _utils.inverseClass)($current, "art-current");
    }
    return {
        width: SETTING_ITEM_WIDTH,
        name: "aspect-ratio",
        html: i18n.get("Aspect Ratio"),
        icon: icons.aspectRatio,
        tooltip: getI18n(art.aspectRatio),
        selector: ASPECT_RATIO.map((item)=>{
            return {
                value: item,
                name: `aspect-ratio-${item}`,
                default: item === art.aspectRatio,
                html: getI18n(item)
            };
        }),
        onSelect (item) {
            art.aspectRatio = item.value;
            return item.html;
        },
        mounted: ($panel, item)=>{
            update($panel, item.$tooltip, art.aspectRatio);
            art.on("aspectRatio", ()=>{
                update($panel, item.$tooltip, art.aspectRatio);
            });
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"l9tWN":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>playbackRate);
var _utils = require("../utils");
function playbackRate(art) {
    const { i18n, icons, constructor: { SETTING_ITEM_WIDTH, PLAYBACK_RATE } } = art;
    function getI18n(value) {
        return value === 1.0 ? i18n.get("Normal") : value.toFixed(1);
    }
    function update($panel, $tooltip, value) {
        if ($tooltip) $tooltip.innerText = getI18n(value);
        const $current = (0, _utils.queryAll)(".art-setting-item", $panel).find((item)=>Number(item.dataset.value) === value);
        if ($current) (0, _utils.inverseClass)($current, "art-current");
    }
    return {
        width: SETTING_ITEM_WIDTH,
        name: "playback-rate",
        html: i18n.get("Play Speed"),
        tooltip: getI18n(art.playbackRate),
        icon: icons.playbackRate,
        selector: PLAYBACK_RATE.map((item)=>{
            return {
                value: item,
                name: `aspect-ratio-${item}`,
                default: item === art.playbackRate,
                html: getI18n(item)
            };
        }),
        onSelect (item) {
            art.playbackRate = item.value;
            return item.html;
        },
        mounted: ($panel, item)=>{
            update($panel, item.$tooltip, art.playbackRate);
            art.on("video:ratechange", ()=>{
                update($panel, item.$tooltip, art.playbackRate);
            });
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"lQoyH":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>subtitleOffset);
function subtitleOffset(art) {
    const { i18n, icons, constructor } = art;
    return {
        width: constructor.SETTING_ITEM_WIDTH,
        name: "subtitle-offset",
        html: i18n.get("Subtitle Offset"),
        icon: icons.subtitle,
        tooltip: "0s",
        range: [
            0,
            -5,
            5,
            0.1
        ],
        onChange (item) {
            art.subtitleOffset = item.range;
            return item.range + "s";
        }
    };
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"9ruid":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
class Storage {
    constructor(){
        this.name = "artplayer_settings";
        this.settings = {};
    }
    get(key) {
        try {
            const storage = JSON.parse(window.localStorage.getItem(this.name)) || {};
            return key ? storage[key] : storage;
        // eslint-disable-next-line no-unused-vars
        } catch (error) {
            return key ? this.settings[key] : this.settings;
        }
    }
    getDefault(key, dv) {
        var v= this.get(key);
        if (v) {
            return v;
        }
        return dv;
    }
    set(key, value) {
        try {
            const storage = Object.assign({}, this.get(), {
                [key]: value
            });
            window.localStorage.setItem(this.name, JSON.stringify(storage));
        // eslint-disable-next-line no-unused-vars
        } catch (error) {
            this.settings[key] = value;
        }
    }
    del(key) {
        try {
            const storage = this.get();
            delete storage[key];
            window.localStorage.setItem(this.name, JSON.stringify(storage));
        // eslint-disable-next-line no-unused-vars
        } catch (error) {
            delete this.settings[key];
        }
    }
    clear() {
        try {
            window.localStorage.removeItem(this.name);
        // eslint-disable-next-line no-unused-vars
        } catch (error) {
            this.settings = {};
        }
    }
}
exports.default = Storage;

},{"@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"7Fd4c":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _utils = require("../utils");
var _miniProgressBar = require("./miniProgressBar");
var _miniProgressBarDefault = parcelHelpers.interopDefault(_miniProgressBar);
var _autoOrientation = require("./autoOrientation");
var _autoOrientationDefault = parcelHelpers.interopDefault(_autoOrientation);
var _autoPlayback = require("./autoPlayback");
var _autoPlaybackDefault = parcelHelpers.interopDefault(_autoPlayback);
var _videoTitle = require("./videoTitle");
var _videoTitleDefault = parcelHelpers.interopDefault(_videoTitle);
var _fastForward = require("./fastForward");
var _fastForwardDefault = parcelHelpers.interopDefault(_fastForward);
var _lock = require("./lock");
var _lockDefault = parcelHelpers.interopDefault(_lock);
class Plugins {
    constructor(art){
        this.art = art;
        this.id = 0;
        const { option } = art;
        if (option.miniProgressBar && !option.isLive) this.add((0, _miniProgressBarDefault.default));
        if (option.lock && (0, _utils.isMobile)) this.add((0, _lockDefault.default));
        if (option.autoPlayback && !option.isLive) this.add((0, _autoPlaybackDefault.default));
        if (option.videoTitle) this.add((0, _videoTitleDefault.default));
        if (option.autoOrientation && (0, _utils.isMobile)) this.add((0, _autoOrientationDefault.default));
        if (option.fastForward && (0, _utils.isMobile) && !option.isLive) this.add((0, _fastForwardDefault.default));
        for(let index = 0; index < option.plugins.length; index++)this.add(option.plugins[index]);
    }
    add(plugin) {
        this.id += 1;
        const result = plugin.call(this.art, this.art);
        if (result instanceof Promise) return result.then((res)=>this.next(plugin, res));
        else return this.next(plugin, result);
    }
    next(plugin, result) {
        const pluginName = result && result.name || plugin.name || `plugin${this.id}`;
        (0, _utils.errorHandle)(!(0, _utils.has)(this, pluginName), `Cannot add a plugin that already has the same name: ${pluginName}`);
        (0, _utils.def)(this, pluginName, {
            value: result
        });
        return this;
    }
}
exports.default = Plugins;

},{"../utils":"euhMG","./miniProgressBar":"3al9F","./autoOrientation":"ocofD","./autoPlayback":"6aLII","./videoTitle":"6aLIP","./fastForward":"i0uB0","./lock":"cuQyc","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"3al9F":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>miniProgressBar);
var _utils = require("../utils");
function miniProgressBar(art) {
    art.on("control", (state)=>{
        if (state) (0, _utils.removeClass)(art.template.$player, "art-mini-progress-bar");
        else (0, _utils.addClass)(art.template.$player, "art-mini-progress-bar");
    });
    return {
        name: "mini-progress-bar"
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"ocofD":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>autoOrientation);
var _utils = require("../utils");
function autoOrientation(art) {
    const { constructor, template: { $player, $video } } = art;
    art.on("fullscreenWeb", (state)=>{
        if (state) {
            const { videoWidth, videoHeight } = $video;
            const { clientWidth: viewWidth, clientHeight: viewHeight } = document.documentElement;
            if (videoWidth > videoHeight && viewWidth < viewHeight || videoWidth < videoHeight && viewWidth > viewHeight) // There is a conflict with the fullscreen event, and it is changed to asynchronous execution
            setTimeout(()=>{
                (0, _utils.setStyle)($player, "width", `${viewHeight}px`);
                (0, _utils.setStyle)($player, "height", `${viewWidth}px`);
                (0, _utils.setStyle)($player, "transform-origin", "0 0");
                (0, _utils.setStyle)($player, "transform", `rotate(90deg) translate(0, -${viewWidth}px)`);
                (0, _utils.addClass)($player, "art-auto-orientation");
                art.isRotate = true;
                art.emit("resize");
            }, constructor.AUTO_ORIENTATION_TIME);
        } else if ((0, _utils.hasClass)($player, "art-auto-orientation")) {
            (0, _utils.removeClass)($player, "art-auto-orientation");
            art.isRotate = false;
            art.emit("resize");
        }
    });
    return {
        name: "autoOrientation",
        get state () {
            return (0, _utils.hasClass)($player, "art-auto-orientation");
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6aLII":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>autoPlayback);
var _utils = require("../utils");
function autoPlayback(art) {
    const { i18n, icons, storage, constructor, proxy, template: { $poster } } = art;
    const $autoPlayback = art.layers.add({
        name: "auto-playback",
        html: `
            <div class="art-auto-playback-close"></div>
            <div class="art-auto-playback-last"></div>
            <div class="art-auto-playback-jump"></div>
        `
    });
    const $last = (0, _utils.query)(".art-auto-playback-last", $autoPlayback);
    const $jump = (0, _utils.query)(".art-auto-playback-jump", $autoPlayback);
    const $close = (0, _utils.query)(".art-auto-playback-close", $autoPlayback);
    art.on("video:timeupdate", ()=>{
        //播放时长太短不记录！！
        if (art.playing && art.currentTime > Artplayer.AUTO_PLAYBACK_MIN) {
            const times = storage.get("times") || {};
            const keys = Object.keys(times);
            if (keys.length > constructor.AUTO_PLAYBACK_MAX) delete times[keys[0]];
            times[art.option.id || art.option.url] = art.currentTime;
            storage.set("times", times);
        }
    });

    art.on("video:ratechange", ()=>{
        storage.set("playbackRate", art.playbackRate);
    });

    art.on("ready", ()=>{
        const playbackRate = storage.getDefault("playbackRate", 1)
        if (playbackRate > 0) {
            art.playbackRate = playbackRate;
        }
        const times = storage.get("times") || {};
        const currentTime = times[art.option.id || art.option.url];
        let isPlayEnd = false;
        if ((currentTime + 1) > video.duration) {
            isPlayEnd = true;
        }
        if (currentTime && currentTime >= constructor.AUTO_PLAYBACK_MIN) {
            (0, _utils.append)($close, icons.close);
            (0, _utils.setStyle)($autoPlayback, "display", "flex");
            if (isPlayEnd) {
                $last.innerText = `播放结束`;
                art.pause();
            }else {
                $last.innerText = `${i18n.get("Last Seen")} ${(0, _utils.secondToTime)(currentTime)}`;
                $jump.innerText = i18n.get("Jump Play");
            }
            proxy($close, "click", ()=>{
                (0, _utils.setStyle)($autoPlayback, "display", "none");
            });
            proxy($jump, "click", ()=>{
                art.seek = currentTime;
                art.play();
                (0, _utils.setStyle)($poster, "display", "none");
                (0, _utils.setStyle)($autoPlayback, "display", "none");
            });
            art.once("video:timeupdate", ()=>{
                setTimeout(()=>{
                    (0, _utils.setStyle)($autoPlayback, "display", "none");
                }, constructor.AUTO_PLAYBACK_TIMEOUT);
            });

            if (!isPlayEnd) {
                setTimeout(()=>{
                    $jump.click()
                    art.on('ready', () => {
                        art.play();
                    });
                }, 2000)
            }
        }
    });
    return {
        name: "auto-playback",
        get times () {
            return storage.get("times") || {};
        },
        clear () {
            return storage.del("times");
        },
        delete (id) {
            const times = storage.get("times") || {};
            delete times[id];
            storage.set("times", times);
            return times;
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"6aLIP":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>videoTitle);
var _utils = require("../utils");
function videoTitle(art) {
    const { option, constructor } = art;
    art.layers.add(            {
        name: 'videoTitle',
        html: `<div class="video-title">${option.videoTitle}</div>`,
        style: {

        },
        click: function (...args) {
            //console.info('click', args);
            //art.controls.show = false;
        },
        mounted: function (...args) {
            //console.info('mounted', args);
        },
    });
    function show() {
        art.layers.videoTitle.style.display = 'block';
    }

    function hide() {
        art.layers.videoTitle.style.display = 'none';
    }

    function update(t) {
        option.videoTitle = t;
        art.layers.update({
            name: 'videoTitle',
            html: `<div class="video-title">${option.videoTitle}</div>`,
        });
    }

    art.on('play', hide);
    art.on('pause', show);

    //art.on('control', (state) => {
    //    if (state) {
    //        show()
    //    }else {
    //        hide()
    //    }
    //});

    return {
        name: "videoTitle",
        show,
        hide,
        update
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"i0uB0":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>fastForward);
var _utils = require("../utils");
function fastForward(art) {
    const { constructor, proxy, template: { $player, $video } } = art;
    let timer = null;
    let isPress = false;
    let lastPlaybackRate = 1;
    const onStart = (event)=>{
        if (event.touches.length === 1 && art.playing && !art.isLock) timer = setTimeout(()=>{
            isPress = true;
            lastPlaybackRate = art.playbackRate;
            art.playbackRate = constructor.FAST_FORWARD_VALUE;
            (0, _utils.addClass)($player, "art-fast-forward");
        }, constructor.FAST_FORWARD_TIME);
    };
    const onStop = ()=>{
        clearTimeout(timer);
        if (isPress) {
            isPress = false;
            art.playbackRate = lastPlaybackRate;
            (0, _utils.removeClass)($player, "art-fast-forward");
        }
    };
    proxy($video, "touchstart", onStart);
    proxy(document, "touchmove", onStop);
    proxy(document, "touchend", onStop);
    return {
        name: "fastForward",
        get state () {
            return (0, _utils.hasClass)($player, "art-fast-forward");
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}],"cuQyc":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "default", ()=>lock);
var _utils = require("../utils");
function lock(art) {
    const { layers, icons, template: { $player } } = art;
    function getState() {
        return (0, _utils.hasClass)($player, "art-lock");
    }
    function setLock() {
        (0, _utils.addClass)($player, "art-lock");
        art.isLock = true;
        art.emit("lock", true);
    }
    function setUnlock() {
        (0, _utils.removeClass)($player, "art-lock");
        art.isLock = false;
        art.emit("lock", false);
    }
    layers.add({
        name: "lock",
        mounted ($el) {
            const $lock = (0, _utils.append)($el, icons.lock);
            const $unlock = (0, _utils.append)($el, icons.unlock);
            (0, _utils.setStyle)($lock, "display", "none");
            art.on("lock", (state)=>{
                if (state) {
                    (0, _utils.setStyle)($lock, "display", "inline-flex");
                    (0, _utils.setStyle)($unlock, "display", "none");
                } else {
                    (0, _utils.setStyle)($lock, "display", "none");
                    (0, _utils.setStyle)($unlock, "display", "inline-flex");
                }
            });
        },
        click () {
            if (getState()) setUnlock();
            else setLock();
        }
    });
    return {
        name: "lock",
        get state () {
            return getState();
        },
        set state (value){
            if (value) setLock();
            else setUnlock();
        }
    };
}

},{"../utils":"euhMG","@parcel/transformer-js/src/esmodule-helpers.js":"6SDkN"}]},["gEVO5"], "gEVO5", "parcelRequireb749")

//# sourceMappingURL=artplayer.js.map
