/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.model;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u5f53\u524d\u9875")
    private Integer pageNum;
    @ApiModelProperty(value="\u6bcf\u9875\u663e\u793a\u6761\u6570")
    private Integer pageSize;
    @ApiModelProperty(value="\u603b\u9875\u6570")
    private Integer totalPage;
    @ApiModelProperty(value="\u603b\u8bb0\u5f55\u6570")
    private Long total;
    @ApiModelProperty(value="\u6709\u4e0b\u4e00\u9875")
    private boolean hasNextPage = false;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private List<T> list = new ArrayList<T>();
    @ApiModelProperty(value="\u6269\u5c55\u6570\u636e\u4fe1\u606f\uff08\u7528\u4e8e\u6570\u636e\u7edf\u8ba1\u7b49...\uff09")
    private Object extData;

    public PageData(Integer pageNum, Integer pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
        this.processNextPage();
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        this.processNextPage();
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
        this.processNextPage();
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Object getExtData() {
        return this.extData;
    }

    public void setExtData(Object extData) {
        this.extData = extData;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void processNextPage() {
        if (this.pageNum != null && this.pageSize != null && this.total != null) {
            long totalPage;
            if (this.pageSize == 0) {
                totalPage = this.total;
                this.hasNextPage = false;
            } else {
                totalPage = (this.total + (long)this.pageSize.intValue() - 1L) / (long)this.pageSize.intValue();
                if ((long)this.pageNum.intValue() < totalPage) {
                    this.hasNextPage = true;
                }
            }
            this.totalPage = (int)totalPage;
        }
    }

    public String toString() {
        return "\u5206\u9875\u6570\u636e \uff1a " + "[" + "\u7b2c " + this.pageNum + " \u9875, " + "\u6bcf\u9875\u663e\u793a " + this.pageSize + " \u6761, " + "\u5f53\u524d\u9875 " + (this.list != null ? this.list.size() : 0) + " \u6761\u8bb0\u5f55\uff0c" + "\u5171 " + this.totalPage + " \u9875\uff0c" + "\u5171 " + this.total + " \u6761\u8bb0\u5f55" + "]";
    }
}

