/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.model;

import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.base.DTO;

public class Result<T>
extends DTO {
    private int code;
    private String message;
    private T data;
    private static final int SUCCESS_CODE = 200;
    private static final String SUCCESS_MESSAGE = "\u5904\u7406\u6210\u529f";
    private static final int ERROR_CODE = 500;
    private static final String ERROR_MESSAGE = "\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    public Result() {
    }

    private Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> error() {
        return Result.error(500, ERROR_MESSAGE);
    }

    public static <T> Result<T> error(String message) {
        return Result.error(500, message);
    }

    public static <T> Result<T> error(int code, String message) {
        return new Result<T>(code, message);
    }

    public static <T> Result<T> error(String code, String message) {
        return new Result<T>(Integer.parseInt(code), message);
    }

    public static <T> Result<T> error(ErrorEnum errorEnum) {
        return Result.error(errorEnum.getCode(), errorEnum.getMessage());
    }

    public static <T> Result<T> error(ErrorEnum errorEnum, T data) {
        return Result.error(errorEnum.getCode(), errorEnum.getMessage(), data);
    }

    public static <T> Result<T> error(int code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public static <T> Result<T> success() {
        return Result.success(SUCCESS_MESSAGE, null);
    }

    public static <T> Result<T> success(T data) {
        return Result.success(SUCCESS_MESSAGE, data);
    }

    public static <T> Result<T> success(String message, T data) {
        return new Result<T>(200, message, data);
    }

    public static <T> Result<T> custom(int code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean successful() {
        return this.code == 200;
    }

    public boolean unsuccessful() {
        return this.code != 200;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

