/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.model;

import cn.acyou.leo.framework.model.ErrorEnum;
import cn.acyou.leo.framework.model.base.DTO;
import io.swagger.annotations.ApiModelProperty;

public class Result<T>
extends DTO {
    @ApiModelProperty(value="\u7f16\u7801(\u9ed8\u8ba4\u6210\u529f\uff1a200)")
    private int code;
    @ApiModelProperty(value="\u63cf\u8ff0")
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u5185\u5bb9")
    private T data;
    private static int SUCCESS_CODE = 200;
    private static String SUCCESS_MESSAGE = "\u5904\u7406\u6210\u529f";
    private static int ERROR_CODE = 500;
    private static String ERROR_MESSAGE = "\u670d\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";

    public static void setDefaultSuccess(int SUCCESS_CODE, String SUCCESS_MESSAGE) {
        Result.SUCCESS_CODE = SUCCESS_CODE;
        Result.SUCCESS_MESSAGE = SUCCESS_MESSAGE;
    }

    public static void setDefaultError(int ERROR_CODE, String ERROR_MESSAGE) {
        Result.ERROR_CODE = ERROR_CODE;
        Result.ERROR_MESSAGE = ERROR_MESSAGE;
    }

    private Result() {
    }

    private Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> error() {
        return Result.error(ERROR_CODE, ERROR_MESSAGE);
    }

    public static <T> Result<T> error(String message) {
        return Result.error(ERROR_CODE, message);
    }

    public static <T> Result<T> error(int code, String message) {
        return new Result<T>(code, message);
    }

    public static <T> Result<T> error(String code, String message) {
        return new Result<T>(Integer.parseInt(code), message);
    }

    public static <T> Result<T> error(ErrorEnum errorEnum) {
        return Result.error(errorEnum.getCode(), errorEnum.getMessage());
    }

    public static <T> Result<T> error(ErrorEnum errorEnum, T data) {
        return Result.error(errorEnum.getCode(), errorEnum.getMessage(), data);
    }

    public static <T> Result<T> error(int code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public static <T> Result<T> success() {
        return Result.success(SUCCESS_MESSAGE, null);
    }

    public static <T> Result<T> success(T data) {
        return Result.success(SUCCESS_MESSAGE, data);
    }

    public static <T> Result<T> success(String message, T data) {
        return new Result<T>(SUCCESS_CODE, message, data);
    }

    public static <T> Result<T> custom(int code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean successful() {
        return this.code == SUCCESS_CODE;
    }

    public boolean unsuccessful() {
        return this.code != SUCCESS_CODE;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

