/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.oss;

import cn.acyou.leo.framework.listener.GetObjectProgressListener;
import cn.acyou.leo.framework.listener.ProgressCallback;
import cn.acyou.leo.framework.listener.PutObjectProgressListener;
import cn.acyou.leo.framework.prop.OSSProperty;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@EnableConfigurationProperties(value={OSSProperty.class})
public class OSSUtils {
    private static final Logger log = LoggerFactory.getLogger(OSSUtils.class);
    private static OSSProperty ossProperty;
    private static OSS ossClient;

    @Autowired
    public void setWxConfigProperties(OSSProperty ossProperty) {
        if (!(StringUtils.hasText((String)ossProperty.getEndpoint()) && StringUtils.hasText((String)ossProperty.getAccess_key_id()) && StringUtils.hasText((String)ossProperty.getAccess_key_secret()))) {
            log.warn("OSS \u672a\u914d\u7f6e\uff0c\u5c06\u5f71\u54cdOSS\u4f7f\u7528\uff01");
            return;
        }
        OSSUtils.ossProperty = ossProperty;
        ossClient = OSSUtils.initOssClient();
    }

    private static OSS initOssClient() {
        log.info("OSS Client \u521d\u59cb\u5316...");
        ClientBuilderConfiguration conf = new ClientBuilderConfiguration();
        conf.setSupportCname(true);
        return new OSSClientBuilder().build(ossProperty.getEndpoint(), ossProperty.getAccess_key_id(), ossProperty.getAccess_key_secret(), conf);
    }

    public static void uploadURL(String bucket, String fileName, String url) {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OSSException("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01");
        }
        OSSUtils.uploadInputStream(bucket, fileName, inputStream);
    }

    public static void uploadLocalFile(String bucket, String fileName, String localFilePath) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(localFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OSSException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
        OSSUtils.uploadInputStream(bucket, fileName, inputStream);
    }

    public static void uploadLocalFile(String bucket, String fileName, File file) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, fileName, file);
        ossClient.putObject(putObjectRequest);
    }

    public static void uploadWithProcess(String bucket, String fileName, File file, ProgressCallback process) {
        ossClient.putObject((PutObjectRequest)new PutObjectRequest(bucket, fileName, file).withProgressListener((ProgressListener)new PutObjectProgressListener(process)));
    }

    public static void uploadInputStream(String bucket, String fileName, InputStream inputStream) {
        ossClient.putObject(bucket, fileName, inputStream);
    }

    public static void uploadString(String bucket, String fileName, String content) {
        byte[] bytes = content.getBytes();
        OSSUtils.uploadByte(bucket, fileName, bytes);
    }

    public static void uploadByte(String bucket, String fileName, byte[] bytes) {
        ossClient.putObject(bucket, fileName, (InputStream)new ByteArrayInputStream(bytes));
    }

    public static AppendObjectResult uploadAppend(String bucket, String fileName, InputStream inputStream, long position, ObjectMetadata meta) {
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucket, fileName, inputStream, meta);
        appendObjectRequest.setPosition(Long.valueOf(position));
        return ossClient.appendObject(appendObjectRequest);
    }

    public static OSSObject download(String bucket, String fileName) {
        return ossClient.getObject(bucket, fileName);
    }

    public static void downloadLocalFile(String bucket, String fileName, File file) {
        ossClient.getObject(new GetObjectRequest(bucket, fileName), file);
    }

    public static void downloadWithProcess(String bucket, String fileName, File file, ProgressCallback callback) {
        ossClient.getObject((GetObjectRequest)new GetObjectRequest(bucket, fileName).withProgressListener((ProgressListener)new GetObjectProgressListener(callback)), file);
    }

    public static boolean existFile(String bucketName, String objectName) {
        return ossClient.doesObjectExist(bucketName, objectName);
    }

    public static List<String> listBuckets() {
        List buckets = ossClient.listBuckets();
        ArrayList<String> buckNameList = new ArrayList<String>();
        for (Bucket input : buckets) {
            String name = input.getName();
            buckNameList.add(name);
        }
        return buckNameList;
    }

    public static void shutdown() {
        ossClient.shutdown();
    }
}

