/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.ftp;

import cn.acyou.leo.framework.exception.FsException;
import cn.acyou.leo.framework.prop.FTPProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@EnableConfigurationProperties(value={FTPProperty.class})
public class FTPUtil {
    private static final Logger log = LoggerFactory.getLogger(FTPUtil.class);
    private static FTPProperty ftpProperty;
    private static final String LOCAL_CHARSET = "GBK";
    private static final String SERVER_CHARSET = "ISO-8859-1";

    @Autowired
    public void setFtpProperties(FTPProperty ftpProperty) {
        if (!StringUtils.hasText((String)ftpProperty.getHost())) {
            log.warn("FTP \u672a\u914d\u7f6e\uff0c\u5c06\u5f71\u54cdFTP\u4f7f\u7528\uff01");
            return;
        }
        FTPUtil.ftpProperty = ftpProperty;
    }

    public String uploadFile(String filePath, String filename, InputStream input) {
        boolean b = FTPUtil.uploadFile(ftpProperty.getHost(), ftpProperty.getPort(), ftpProperty.getUsername(), ftpProperty.getPassword(), ftpProperty.getBasePath(), filePath, filename, input);
        if (b) {
            return ftpProperty.getBasePathUrl() + filePath + filename;
        }
        return null;
    }

    public boolean downloadFile(String filePath, String filename, OutputStream os) {
        return FTPUtil.downloadFile(ftpProperty.getHost(), ftpProperty.getPort(), ftpProperty.getUsername(), ftpProperty.getPassword(), ftpProperty.getBasePath(), filePath + "/" + filename, os);
    }

    public boolean deleteFile(String filePath, String filename) {
        return FTPUtil.deleteFile(ftpProperty.getHost(), ftpProperty.getPort(), ftpProperty.getUsername(), ftpProperty.getPassword(), ftpProperty.getBasePath(), filePath + "/" + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String host, int port, String username, String password, String basePath, String filePath, String filename, InputStream input) {
        block18: {
            boolean dirs2;
            FTPClient ftp = FTPUtil.checkGetFTPClient(host, port, username, password);
            try {
                if (!ftp.changeWorkingDirectory(basePath + filePath)) {
                    String[] dirs2 = filePath.split("/");
                    String tempPath = basePath;
                    for (String dir : dirs2) {
                        if (null == dir || "".equals(dir) || ftp.changeWorkingDirectory(tempPath = tempPath + "/" + dir)) continue;
                        if (!ftp.makeDirectory(tempPath)) {
                            boolean bl = false;
                            return bl;
                        }
                        ftp.changeWorkingDirectory(tempPath);
                    }
                }
                ftp.setFileType(2);
                log.info("\u51c6\u5907\u4e0a\u4f20\u6587\u4ef6\uff1a{}", (Object)(ftp.printWorkingDirectory() + "/" + filename));
                dirs2 = ftp.storeFile(filename, input);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block18;
            }
            finally {
                try {
                    input.close();
                    if (ftp.isConnected()) {
                        ftp.logout();
                        ftp.disconnect();
                    }
                }
                catch (IOException iOException) {}
            }
            return dirs2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String host, int port, String username, String password, String remotePath, String fileName, OutputStream os) {
        FTPClient ftp = FTPUtil.checkGetFTPClient(host, port, username, password);
        try {
            boolean bl = ftp.retrieveFile(remotePath + fileName, os);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static FTPClient checkGetFTPClient(String host, int port, String userName, String password) {
        try {
            FTPClient ftpClient = new FTPClient();
            ftpClient.connect(host, port);
            ftpClient.login(userName, password);
            int replyCode = ftpClient.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)replyCode)) {
                log.info("FTP\u8fde\u63a5\u6210\u529f\u3002");
                return ftpClient;
            }
            log.info("\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002");
            ftpClient.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("FTP\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
        throw new FsException("FTP Client \u83b7\u53d6\u5931\u8d25\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(String host, int port, String username, String password, String remotePath, String filename) {
        boolean flag = false;
        FTPClient ftpClient = FTPUtil.checkGetFTPClient(host, port, username, password);
        try {
            ftpClient.changeWorkingDirectory(remotePath);
            String charset = LOCAL_CHARSET;
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8", "ON"))) {
                charset = "UTF-8";
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            filename = new String(filename.getBytes(charset), SERVER_CHARSET);
            ftpClient.dele(filename);
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        boolean success = false;
        System.out.println(success);
    }
}

