/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinIoUtil {
    private static final Logger log = LoggerFactory.getLogger(MinIoUtil.class);
    private MinioClient minioClient;

    public MinIoUtil(MinioClient minioClient) {
        this.minioClient = minioClient;
        log.info("MinIoUtil \u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    public void makeBucket(String name) {
        try {
            boolean exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(name)).build());
            if (!exists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(name)).build());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void putObject(String bucket, String objectKey, File file) throws Exception {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).stream((InputStream)new FileInputStream(file), file.length(), -1L).build());
    }
}

