/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.oss;

import cn.acyou.leo.framework.listener.GetObjectProgressListener;
import cn.acyou.leo.framework.listener.ProgressCallback;
import cn.acyou.leo.framework.listener.PutObjectProgressListener;
import cn.acyou.leo.framework.prop.OSSProperty;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSUtil {
    private static final Logger log = LoggerFactory.getLogger(OSSUtil.class);
    private final OSSProperty ossProperty;
    private final OSS ossClient;

    public OSSUtil(OSSProperty ossProperty) {
        this.ossProperty = ossProperty;
        this.ossClient = this.initOssClient();
        log.info("OSSUtil \u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    private OSS initOssClient() {
        log.info("OSS Client \u521d\u59cb\u5316...");
        ClientBuilderConfiguration conf = new ClientBuilderConfiguration();
        conf.setSupportCname(true);
        return new OSSClientBuilder().build(this.ossProperty.getEndpoint(), this.ossProperty.getAccessKeyId(), this.ossProperty.getAccessKeySecret(), conf);
    }

    public void uploadURL(String bucket, String fileName, String url) {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OSSException("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01");
        }
        this.uploadInputStream(bucket, fileName, inputStream);
    }

    public void uploadLocalFile(String bucket, String fileName, String localFilePath) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(localFilePath);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OSSException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
        this.uploadInputStream(bucket, fileName, inputStream);
    }

    public void uploadLocalFile(String bucket, String fileName, File file) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, fileName, file);
        this.ossClient.putObject(putObjectRequest);
    }

    public void uploadWithProcess(String bucket, String fileName, File file, ProgressCallback process) {
        this.ossClient.putObject((PutObjectRequest)new PutObjectRequest(bucket, fileName, file).withProgressListener((ProgressListener)new PutObjectProgressListener(process)));
    }

    public void uploadInputStream(String bucket, String fileName, InputStream inputStream) {
        this.ossClient.putObject(bucket, fileName, inputStream);
    }

    public void uploadString(String bucket, String fileName, String content) {
        byte[] bytes = content.getBytes();
        this.uploadByte(bucket, fileName, bytes);
    }

    public void uploadByte(String bucket, String fileName, byte[] bytes) {
        this.ossClient.putObject(bucket, fileName, (InputStream)new ByteArrayInputStream(bytes));
    }

    public AppendObjectResult uploadAppend(String bucket, String fileName, InputStream inputStream, long position, ObjectMetadata meta) {
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucket, fileName, inputStream, meta);
        appendObjectRequest.setPosition(Long.valueOf(position));
        return this.ossClient.appendObject(appendObjectRequest);
    }

    public OSSObject download(String bucket, String fileName) {
        return this.ossClient.getObject(bucket, fileName);
    }

    public void downloadLocalFile(String bucket, String fileName, File file) {
        this.ossClient.getObject(new GetObjectRequest(bucket, fileName), file);
    }

    public void downloadWithProcess(String bucket, String fileName, File file, ProgressCallback callback) {
        this.ossClient.getObject((GetObjectRequest)new GetObjectRequest(bucket, fileName).withProgressListener((ProgressListener)new GetObjectProgressListener(callback)), file);
    }

    public boolean existFile(String bucketName, String objectName) {
        return this.ossClient.doesObjectExist(bucketName, objectName);
    }

    public void deleteFile(String bucketName, String objectName) {
        this.ossClient.deleteObject(bucketName, objectName);
    }

    public void deleteBucket(String bucketName) {
        this.ossClient.deleteBucket(bucketName);
    }

    public Bucket createBucket(String bucketName) {
        return this.ossClient.createBucket(bucketName);
    }

    public List<String> listBuckets() {
        List buckets = this.ossClient.listBuckets();
        ArrayList<String> buckNameList = new ArrayList<String>();
        for (Bucket input : buckets) {
            String name = input.getName();
            buckNameList.add(name);
        }
        return buckNameList;
    }

    public void shutdown() {
        this.ossClient.shutdown();
    }
}

