/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.obs;

import cn.acyou.leo.framework.exception.FsException;
import cn.acyou.leo.framework.listener.ProgressCallback;
import cn.acyou.leo.framework.obs.ObsSignatureTemporaryVo;
import cn.acyou.leo.framework.obs.ObsSignatureVo;
import cn.acyou.leo.framework.prop.OBSProperty;
import com.obs.services.ObsClient;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadFileRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class OBSUtil {
    private static final Logger log = LoggerFactory.getLogger(OBSUtil.class);
    private final OBSProperty obsProperty;
    private final ObsClient obsClient;

    public OBSUtil(OBSProperty obsProperty) {
        this.obsProperty = obsProperty;
        this.obsClient = this.initObsClient();
        log.info("OBSUtil \u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    private ObsClient initObsClient() {
        log.info("OBS Client \u521d\u59cb\u5316...");
        return new ObsClient(this.obsProperty.getAccessKeyId(), this.obsProperty.getAccessKeySecret(), this.obsProperty.getEndpoint());
    }

    public ObsSignatureVo getSignature(String xObsAcl, String contextType) {
        ObsSignatureVo obsSignatureVo = new ObsSignatureVo();
        obsSignatureVo.setAccessKeyId(this.obsProperty.getAccessKeyId());
        if (!StringUtils.hasText((String)xObsAcl)) {
            xObsAcl = "public-read";
        }
        if (!StringUtils.hasText((String)contextType)) {
            contextType = "text/plain";
        }
        obsSignatureVo.setXObsAcl(xObsAcl);
        obsSignatureVo.setContextType(contextType);
        PostSignatureRequest request = new PostSignatureRequest();
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("x-obs-acl", xObsAcl);
        formParams.put("content-type", contextType);
        request.setFormParams(formParams);
        request.setExpires(3600L);
        PostSignatureResponse response = this.obsClient.createPostSignature(request);
        obsSignatureVo.setPolicy(response.getPolicy());
        obsSignatureVo.setSignature(response.getSignature());
        return obsSignatureVo;
    }

    public ObsSignatureTemporaryVo getTemporarySignature(String bucketName, String objectKey) {
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setMethod(HttpMethodEnum.PUT);
        request.setExpires(3600L);
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.getHeaders().put("content-type", "application/octet-stream");
        TemporarySignatureResponse temporarySignature = this.obsClient.createTemporarySignature(request);
        ObsSignatureTemporaryVo temporaryVo = new ObsSignatureTemporaryVo();
        temporaryVo.setSignedUrl(temporarySignature.getSignedUrl());
        temporaryVo.setActualSignedRequestHeaders(temporarySignature.getActualSignedRequestHeaders());
        temporaryVo.setFileName(objectKey.substring(objectKey.lastIndexOf("/") + 1));
        temporaryVo.setFilePath("/" + objectKey);
        temporaryVo.setEndPoint(this.obsProperty.getEndpoint());
        temporaryVo.setBucketName(bucketName);
        return temporaryVo;
    }

    public void uploadURL(String bucket, String fileName, String url) {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new FsException("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01");
        }
        this.uploadInputStream(bucket, fileName, inputStream);
    }

    public void uploadLocalFile(String bucket, String fileName, String localFilePath) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(localFilePath);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new FsException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
        this.uploadInputStream(bucket, fileName, inputStream);
    }

    public void uploadLocalFile(String bucket, String fileName, File file) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, fileName, file);
        this.obsClient.putObject(putObjectRequest);
    }

    public void uploadWithProcess(String bucket, String fileName, File file, ProgressCallback process) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, fileName, file);
        putObjectRequest.setProgressListener(new ProgressListener(){

            public void progressChanged(ProgressStatus status) {
                System.out.println("AverageSpeed:" + status.getAverageSpeed());
                System.out.println("TransferPercentage:" + status.getTransferPercentage());
            }
        });
        this.obsClient.putObject(putObjectRequest);
    }

    public void uploadInputStream(String bucket, String fileName, InputStream inputStream) {
        this.obsClient.putObject(bucket, fileName, inputStream);
    }

    public void uploadString(String bucket, String fileName, String content) {
        byte[] bytes = content.getBytes();
        this.uploadByte(bucket, fileName, bytes);
    }

    public void uploadByte(String bucket, String fileName, byte[] bytes) {
        this.obsClient.putObject(bucket, fileName, (InputStream)new ByteArrayInputStream(bytes));
    }

    public AppendObjectResult uploadAppend(String bucket, String fileName, InputStream inputStream, long position, ObjectMetadata meta) {
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucket);
        appendObjectRequest.setPosition(position);
        return this.obsClient.appendObject(appendObjectRequest);
    }

    public boolean uploadBigFile(String bucket, String fileName, File file) {
        UploadFileRequest request = new UploadFileRequest(bucket, fileName);
        request.setUploadFile(file.getAbsolutePath());
        request.setTaskNum(5);
        request.setPartSize(0xA00000L);
        request.setEnableCheckpoint(true);
        try {
            CompleteMultipartUploadResult result = this.obsClient.uploadFile(request);
            return true;
        }
        catch (Exception e) {
            this.uploadBigFile(bucket, fileName, file);
            return false;
        }
    }

    public ObsObject download(String bucket, String fileName) {
        return this.obsClient.getObject(bucket, fileName);
    }

    public boolean downloadLocalFile(String bucket, String fileName, File file) {
        try {
            ObsObject object = this.obsClient.getObject(new GetObjectRequest(bucket, fileName));
            FileCopyUtils.copy((InputStream)object.getObjectContent(), (OutputStream)new FileOutputStream(file));
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean downloadWithProcess(String bucket, String fileName, File file, ProgressCallback callback) {
        GetObjectRequest request = new GetObjectRequest(bucket, fileName);
        request.setProgressListener(new ProgressListener(){

            public void progressChanged(ProgressStatus status) {
                System.out.println("AverageSpeed:" + status.getAverageSpeed());
                System.out.println("TransferPercentage:" + status.getTransferPercentage());
            }
        });
        request.setProgressInterval(0x100000L);
        try {
            ObsObject object = this.obsClient.getObject(request);
            FileCopyUtils.copy((InputStream)object.getObjectContent(), (OutputStream)new FileOutputStream(file));
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean existFile(String bucketName, String objectName) {
        return this.obsClient.doesObjectExist(bucketName, objectName);
    }

    public void deleteFile(String bucketName, String objectName) {
        this.obsClient.deleteObject(bucketName, objectName);
    }

    public void deleteBucket(String bucketName) {
        this.obsClient.deleteBucket(bucketName);
    }

    public ObsBucket createBucket(String bucketName) {
        return this.obsClient.createBucket(bucketName);
    }

    public List<String> listBuckets() {
        ListBucketsRequest listBucketsRequest = new ListBucketsRequest();
        List buckets = this.obsClient.listBuckets(listBucketsRequest);
        ArrayList<String> buckNameList = new ArrayList<String>();
        for (ObsBucket input : buckets) {
            String name = input.getBucketName();
            buckNameList.add(name);
        }
        return buckNameList;
    }

    public void shutdown() {
        try {
            this.obsClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

