/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.listener;

import cn.acyou.leo.framework.listener.ProgressCallback;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;

public class PutObjectProgressListener
implements ProgressListener {
    private long bytesWritten = 0L;
    private long totalBytes = -1L;
    private boolean succeed = false;
    private final ProgressCallback callback;

    public PutObjectProgressListener(ProgressCallback process) {
        this.callback = process;
    }

    public void progressChanged(ProgressEvent progressEvent) {
        long bytes = progressEvent.getBytes();
        ProgressEventType eventType = progressEvent.getEventType();
        switch (eventType) {
            case TRANSFER_STARTED_EVENT: {
                break;
            }
            case REQUEST_CONTENT_LENGTH_EVENT: {
                this.totalBytes = bytes;
                break;
            }
            case REQUEST_BYTE_TRANSFER_EVENT: {
                this.bytesWritten += bytes;
                if (this.totalBytes == -1L) break;
                int percent = (int)((double)this.bytesWritten * 100.0 / (double)this.totalBytes);
                this.callback.progress(percent);
                break;
            }
            case TRANSFER_COMPLETED_EVENT: {
                this.succeed = true;
                this.callback.success();
                break;
            }
            case TRANSFER_FAILED_EVENT: {
                break;
            }
        }
    }

    public boolean isSucceed() {
        return this.succeed;
    }
}

