/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.messages.Bucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinIoUtil {
    private static final Logger log = LoggerFactory.getLogger(MinIoUtil.class);
    private MinioClient minioClient;

    public MinIoUtil(MinioClient minioClient) {
        this.minioClient = minioClient;
        log.info("MinIoUtil \u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    public void makeBucket(String name) {
        try {
            boolean exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(name)).build());
            if (!exists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(name)).build());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void putObject(String bucket, String objectKey, File file) throws Exception {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).stream((InputStream)new FileInputStream(file), file.length(), -1L).build());
    }

    public void putObject(String bucket, String objectKey, InputStream is) throws Exception {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).stream(is, (long)is.available(), -1L).build());
    }

    public List<Bucket> listBuckets() throws Exception {
        return this.minioClient.listBuckets();
    }

    public void removeObject(String bucket, String objectKey) throws Exception {
        this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void putObjectHttp(String bucket, String path, String url) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(path)).stream(connection.getInputStream(), connection.getContentLengthLong(), -1L).build());
    }
}

