/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.generator;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MultiModulesCodeGenerator {
    public static String tableName = "student";
    public static String DRIVER = "com.mysql.cj.jdbc.Driver";
    public static String USER = "root";
    public static String PASSWORD = "root123";
    public static String AUTHOR = "youfang";
    public static String PACKAGE_PARENT = "cn.acyou.leo.content";
    public static String JDBC_URL = "jdbc:mysql://localhost:3306/scorpio?useUnicode=true&characterEncoding=UTF-8&allowMultiQueries=true&serverTimezone=UTC&useSSL=false";
    public static Map<String, String> modulesMap = new HashMap<String, String>();
    private static final String projectPath;
    private static Map<String, String> packageInfo;
    private static final ITypeConvert typeConvert;

    public static void doGenerator() {
        AutoGenerator autoGenerator = new AutoGenerator();
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setOutputDir(projectPath);
        globalConfig.setAuthor(AUTHOR);
        globalConfig.setOpen(false);
        globalConfig.setSwagger2(true);
        globalConfig.setFileOverride(true);
        globalConfig.setBaseResultMap(true);
        globalConfig.setBaseColumnList(true);
        globalConfig.setServiceName("%sService");
        autoGenerator.setGlobalConfig(globalConfig);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(JDBC_URL);
        dsc.setDriverName(DRIVER);
        dsc.setUsername(USER);
        dsc.setPassword(PASSWORD);
        dsc.setTypeConvert(typeConvert);
        autoGenerator.setDataSource(dsc);
        TemplateConfig templateConfig = new TemplateConfig();
        autoGenerator.setTemplate(templateConfig);
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("");
        pc.setParent(PACKAGE_PARENT);
        packageInfo.put("Entity", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getEntity()));
        packageInfo.put("Mapper", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getMapper()));
        packageInfo.put("Xml", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getXml()));
        packageInfo.put("Service", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getService()));
        packageInfo.put("ServiceImpl", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getServiceImpl()));
        packageInfo.put("Controller", MultiModulesCodeGenerator.joinPackage(pc.getParent(), pc.getController()));
        HashMap<String, String> pathInfo = new HashMap<String, String>();
        pathInfo.put("xml_path", globalConfig.getOutputDir() + "\\" + modulesMap.get("xml_path") + "\\src\\main\\resources\\mappers");
        MultiModulesCodeGenerator.setPathInfo(pathInfo, templateConfig.getEntity(globalConfig.isKotlin()), globalConfig.getOutputDir() + "\\" + modulesMap.get("entity_path") + "\\src\\main\\java", "entity_path", "Entity");
        MultiModulesCodeGenerator.setPathInfo(pathInfo, templateConfig.getMapper(), globalConfig.getOutputDir() + "\\" + modulesMap.get("mapper_path") + "\\src\\main\\java", "mapper_path", "Mapper");
        MultiModulesCodeGenerator.setPathInfo(pathInfo, templateConfig.getService(), globalConfig.getOutputDir() + "\\" + modulesMap.get("service_path") + "\\src\\main\\java", "service_path", "Service");
        MultiModulesCodeGenerator.setPathInfo(pathInfo, templateConfig.getServiceImpl(), globalConfig.getOutputDir() + "\\" + modulesMap.get("service_impl_path") + "\\src\\main\\java", "service_impl_path", "ServiceImpl");
        MultiModulesCodeGenerator.setPathInfo(pathInfo, templateConfig.getController(), globalConfig.getOutputDir() + "\\" + modulesMap.get("controller_path") + "\\src\\main\\java", "controller_path", "Controller");
        pc.setPathInfo(pathInfo);
        autoGenerator.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
            }
        };
        autoGenerator.setCfg(cfg);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        strategy.setInclude(new String[]{tableName});
        strategy.setControllerMappingHyphenStyle(false);
        strategy.setTablePrefix(new String[]{pc.getModuleName() + "_"});
        autoGenerator.setStrategy(strategy);
        autoGenerator.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        autoGenerator.execute();
    }

    private static void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            pathInfo.put(path, MultiModulesCodeGenerator.joinPath(outputDir, packageInfo.get(module)));
        }
    }

    private static String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private static String joinPackage(String parent, String subPackage) {
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }

    static {
        modulesMap.put("entity_path", "leo-content-mapper");
        modulesMap.put("mapper_path", "leo-content-mapper");
        modulesMap.put("xml_path", "leo-content-mapper");
        modulesMap.put("service_path", "leo-content-service");
        modulesMap.put("service_impl_path", "leo-content-service");
        modulesMap.put("controller_path", "leo-content-web");
        projectPath = System.getProperty("user.dir");
        packageInfo = CollectionUtils.newHashMapWithExpectedSize((int)7);
        typeConvert = new ITypeConvert(){

            public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                String t = fieldType.toLowerCase();
                if (t.contains("datetime")) {
                    return DbColumnType.DATE;
                }
                return new MySqlTypeConvert().processTypeConvert(globalConfig, fieldType);
            }
        };
    }
}

