/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.generator;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CustomCodeGenerator {
    private String tableName = "student";
    private String DRIVER = "com.mysql.cj.jdbc.Driver";
    private String USER = "root";
    private String PASSWORD = "root123";
    private String AUTHOR = "youfang";
    private String PACKAGE_PARENT = "cn.acyou.leo.content";
    private String JDBC_URL = "jdbc:mysql://localhost:3306/scorpio?useUnicode=true&characterEncoding=UTF-8&allowMultiQueries=true&serverTimezone=UTC&useSSL=false";
    private static final String projectPath = System.getProperty("user.dir");
    public Map<String, String[]> modulesMap = new HashMap<String, String[]>();
    private static Map<String, String> packageInfo = CollectionUtils.newHashMapWithExpectedSize((int)7);
    private static final ITypeConvert typeConvert = new ITypeConvert(){

        public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
            String t = fieldType.toLowerCase();
            if (t.contains("datetime")) {
                return DbColumnType.DATE;
            }
            return new MySqlTypeConvert().processTypeConvert(globalConfig, fieldType);
        }
    };

    public CustomCodeGenerator(String tableName) {
        this.tableName = tableName;
    }

    public CustomCodeGenerator author(String AUTHOR) {
        this.AUTHOR = AUTHOR;
        return this;
    }

    public CustomCodeGenerator setDbConfig(String DRIVER, String USER, String PASSWORD) {
        this.DRIVER = DRIVER;
        this.USER = USER;
        this.PASSWORD = PASSWORD;
        return this;
    }

    public CustomCodeGenerator setDbUrl(String JDBC_URL) {
        this.JDBC_URL = JDBC_URL;
        return this;
    }

    public CustomCodeGenerator packageParent(String PACKAGE_PARENT) {
        this.PACKAGE_PARENT = PACKAGE_PARENT;
        return this;
    }

    public CustomCodeGenerator put(String pathKey, String moduleName, String packageName) {
        this.modulesMap.put(pathKey, new String[]{moduleName, packageName});
        return this;
    }

    public void doGenerator() {
        if (this.modulesMap.size() == 0) {
            return;
        }
        AutoGenerator autoGenerator = new AutoGenerator();
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setOutputDir(projectPath);
        globalConfig.setAuthor(this.AUTHOR);
        globalConfig.setOpen(false);
        globalConfig.setSwagger2(true);
        globalConfig.setFileOverride(true);
        globalConfig.setBaseResultMap(true);
        globalConfig.setBaseColumnList(true);
        globalConfig.setServiceName("%sService");
        autoGenerator.setGlobalConfig(globalConfig);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(this.JDBC_URL);
        dsc.setDriverName(this.DRIVER);
        dsc.setUsername(this.USER);
        dsc.setPassword(this.PASSWORD);
        dsc.setTypeConvert(typeConvert);
        autoGenerator.setDataSource(dsc);
        TemplateConfig templateConfig = new TemplateConfig();
        autoGenerator.setTemplate(templateConfig);
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("");
        pc.setParent(this.PACKAGE_PARENT);
        HashMap<String, String> pathInfo = new HashMap<String, String>();
        if (this.modulesMap.get("entity_path") != null) {
            pc.setEntity(this.modulesMap.get("entity_path")[1]);
            packageInfo.put("Entity", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getEntity()));
            CustomCodeGenerator.setPathInfo(pathInfo, templateConfig.getEntity(globalConfig.isKotlin()), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("entity_path")[0] + "\\src\\main\\java", "entity_path", "Entity");
        }
        if (this.modulesMap.get("mapper_path") != null) {
            pc.setMapper(this.modulesMap.get("mapper_path")[1]);
            packageInfo.put("Mapper", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getMapper()));
            CustomCodeGenerator.setPathInfo(pathInfo, templateConfig.getMapper(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("mapper_path")[0] + "\\src\\main\\java", "mapper_path", "Mapper");
        }
        if (this.modulesMap.get("xml_path") != null) {
            pc.setXml(this.modulesMap.get("xml_path")[1]);
            packageInfo.put("Xml", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getXml()));
            pathInfo.put("xml_path", globalConfig.getOutputDir() + "\\" + this.modulesMap.get("xml_path")[0] + "\\src\\main\\resources\\" + this.modulesMap.get("xml_path")[1]);
        }
        if (this.modulesMap.get("service_path") != null) {
            pc.setService(this.modulesMap.get("service_path")[1]);
            packageInfo.put("Service", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getService()));
            CustomCodeGenerator.setPathInfo(pathInfo, templateConfig.getService(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("service_path")[0] + "\\src\\main\\java", "service_path", "Service");
        }
        if (this.modulesMap.get("service_impl_path") != null) {
            pc.setServiceImpl(this.modulesMap.get("service_impl_path")[1]);
            packageInfo.put("ServiceImpl", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getServiceImpl()));
            CustomCodeGenerator.setPathInfo(pathInfo, templateConfig.getServiceImpl(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("service_impl_path")[0] + "\\src\\main\\java", "service_impl_path", "ServiceImpl");
        }
        if (this.modulesMap.get("controller_path") != null) {
            pc.setController(this.modulesMap.get("controller_path")[1]);
            packageInfo.put("Controller", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getController()));
            CustomCodeGenerator.setPathInfo(pathInfo, templateConfig.getController(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("controller_path")[0] + "\\src\\main\\java", "controller_path", "Controller");
        }
        pc.setPathInfo(pathInfo);
        autoGenerator.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
            }
        };
        autoGenerator.setCfg(cfg);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        strategy.setInclude(new String[]{this.tableName});
        strategy.setControllerMappingHyphenStyle(false);
        strategy.setTablePrefix(new String[]{pc.getModuleName() + "_"});
        autoGenerator.setStrategy(strategy);
        autoGenerator.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        autoGenerator.execute();
    }

    private static void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            pathInfo.put(path, CustomCodeGenerator.joinPath(outputDir, packageInfo.get(module)));
        }
    }

    private static String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private static String joinPackage(String parent, String subPackage) {
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }
}

