/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.generator;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class CustomCodeGenerator {
    private String tableName = "student";
    private String tablePrefix = "";
    private String DRIVER = "com.mysql.cj.jdbc.Driver";
    private String USER = "root";
    private String PASSWORD = "root123";
    private String AUTHOR = System.getProperty("user.name");
    private String PACKAGE_PARENT = "cn.acyou.leo";
    private String superMapperClass = "";
    private String superServiceClass = "";
    private String superServiceImplClass = "";
    private String superControllerClass = "";
    private String JDBC_URL = "jdbc:mysql://localhost:3306/scorpio?useUnicode=true&characterEncoding=UTF-8&allowMultiQueries=true&serverTimezone=Asia/Shanghai&useSSL=false";
    private final String projectPath = System.getProperty("user.dir");
    private Map<String, String[]> modulesMap = new HashMap<String, String[]>();
    private Map<String, String> packageInfo = CollectionUtils.newHashMapWithExpectedSize((int)7);
    private static final ITypeConvert typeConvert = new ITypeConvert(){

        public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
            String t = fieldType.toLowerCase();
            if (t.contains("datetime")) {
                return DbColumnType.DATE;
            }
            if (t.contains("timestamp")) {
                return DbColumnType.DATE;
            }
            return new MySqlTypeConvert().processTypeConvert(globalConfig, fieldType);
        }
    };

    private void initDefaultConfig(CustomCodeGenerator customCodeGenerator) {
        customCodeGenerator.put("entity_path", "", "entity");
        customCodeGenerator.put("mapper_path", "", "mapper");
        customCodeGenerator.put("xml_path", "", "mappers");
        customCodeGenerator.put("service_path", "", "service");
        customCodeGenerator.put("service_impl_path", "", "service.impl");
        customCodeGenerator.put("controller_path", "", "controller");
    }

    public static CustomCodeGenerator instance(String tableName) {
        return new CustomCodeGenerator(tableName, "");
    }

    public static CustomCodeGenerator instance(String tableName, String removeTablePrefix) {
        return new CustomCodeGenerator(tableName, removeTablePrefix);
    }

    private CustomCodeGenerator(String tableName, String removeTablePrefix) {
        this.tableName = tableName;
        this.tablePrefix = removeTablePrefix;
        this.initDefaultConfig(this);
    }

    public CustomCodeGenerator author(String AUTHOR) {
        this.AUTHOR = AUTHOR;
        return this;
    }

    public CustomCodeGenerator setDbConfig(String DRIVER, String USER, String PASSWORD) {
        this.DRIVER = DRIVER;
        this.USER = USER;
        this.PASSWORD = PASSWORD;
        return this;
    }

    public CustomCodeGenerator setDbUrl(String JDBC_URL) {
        this.JDBC_URL = JDBC_URL;
        return this;
    }

    public CustomCodeGenerator packageParent(String PACKAGE_PARENT) {
        this.PACKAGE_PARENT = PACKAGE_PARENT;
        return this;
    }

    public CustomCodeGenerator superClass(String superMapperClass, String superServiceClass, String superServiceImplClass, String superControllerClass) {
        this.superMapperClass = superMapperClass;
        this.superServiceClass = superServiceClass;
        this.superServiceImplClass = superServiceImplClass;
        this.superControllerClass = superControllerClass;
        return this;
    }

    public CustomCodeGenerator superMapperClass(String superMapperClass) {
        this.superMapperClass = superMapperClass;
        return this;
    }

    public CustomCodeGenerator superServiceClass(String superServiceClass) {
        this.superServiceClass = superServiceClass;
        return this;
    }

    public CustomCodeGenerator superServiceImplClass(String superServiceImplClass) {
        this.superServiceImplClass = superServiceImplClass;
        return this;
    }

    public CustomCodeGenerator superControllerClass(String superControllerClass) {
        this.superControllerClass = superControllerClass;
        return this;
    }

    public CustomCodeGenerator put(String pathKey, String moduleName, String packageName) {
        this.modulesMap.put(pathKey, new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putEntityPath(String moduleName, String packageName) {
        this.modulesMap.put("entity_path", new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putMapperPath(String moduleName, String packageName) {
        this.modulesMap.put("mapper_path", new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putXmlPath(String moduleName, String packageName) {
        this.modulesMap.put("xml_path", new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putServicePath(String moduleName, String packageName) {
        this.modulesMap.put("service_path", new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putServiceImplPath(String moduleName, String packageName) {
        this.modulesMap.put("service_impl_path", new String[]{moduleName, packageName});
        return this;
    }

    public CustomCodeGenerator putControllerPath(String moduleName, String packageName) {
        this.modulesMap.put("controller_path", new String[]{moduleName, packageName});
        return this;
    }

    public void doGenerator() {
        if (this.modulesMap.size() == 0) {
            return;
        }
        AutoGenerator autoGenerator = new AutoGenerator();
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setOutputDir(this.projectPath);
        globalConfig.setAuthor(this.AUTHOR);
        globalConfig.setOpen(false);
        globalConfig.setSwagger2(true);
        globalConfig.setFileOverride(true);
        globalConfig.setBaseResultMap(true);
        globalConfig.setBaseColumnList(true);
        globalConfig.setServiceName("%sService");
        autoGenerator.setGlobalConfig(globalConfig);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(this.JDBC_URL);
        dsc.setDriverName(this.DRIVER);
        dsc.setUsername(this.USER);
        dsc.setPassword(this.PASSWORD);
        dsc.setTypeConvert(typeConvert);
        autoGenerator.setDataSource(dsc);
        TemplateConfig templateConfig = new TemplateConfig();
        autoGenerator.setTemplate(templateConfig);
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("");
        pc.setParent(this.PACKAGE_PARENT);
        HashMap<String, String> pathInfo = new HashMap<String, String>();
        if (this.modulesMap.get("entity_path") != null) {
            pc.setEntity(this.modulesMap.get("entity_path")[1]);
            this.packageInfo.put("Entity", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getEntity()));
            this.setPathInfo(pathInfo, templateConfig.getEntity(globalConfig.isKotlin()), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("entity_path")[0] + "\\src\\main\\java", "entity_path", "Entity");
        }
        if (this.modulesMap.get("mapper_path") != null) {
            pc.setMapper(this.modulesMap.get("mapper_path")[1]);
            this.packageInfo.put("Mapper", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getMapper()));
            this.setPathInfo(pathInfo, templateConfig.getMapper(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("mapper_path")[0] + "\\src\\main\\java", "mapper_path", "Mapper");
        }
        if (this.modulesMap.get("xml_path") != null) {
            pc.setXml(this.modulesMap.get("xml_path")[1]);
            this.packageInfo.put("Xml", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getXml()));
            pathInfo.put("xml_path", globalConfig.getOutputDir() + "\\" + this.modulesMap.get("xml_path")[0] + "\\src\\main\\resources\\" + this.modulesMap.get("xml_path")[1]);
        }
        if (this.modulesMap.get("service_path") != null) {
            pc.setService(this.modulesMap.get("service_path")[1]);
            this.packageInfo.put("Service", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getService()));
            this.setPathInfo(pathInfo, templateConfig.getService(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("service_path")[0] + "\\src\\main\\java", "service_path", "Service");
        }
        if (this.modulesMap.get("service_impl_path") != null) {
            pc.setServiceImpl(this.modulesMap.get("service_impl_path")[1]);
            this.packageInfo.put("ServiceImpl", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getServiceImpl()));
            this.setPathInfo(pathInfo, templateConfig.getServiceImpl(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("service_impl_path")[0] + "\\src\\main\\java", "service_impl_path", "ServiceImpl");
        }
        if (this.modulesMap.get("controller_path") != null) {
            pc.setController(this.modulesMap.get("controller_path")[1]);
            this.packageInfo.put("Controller", CustomCodeGenerator.joinPackage(pc.getParent(), pc.getController()));
            this.setPathInfo(pathInfo, templateConfig.getController(), globalConfig.getOutputDir() + "\\" + this.modulesMap.get("controller_path")[0] + "\\src\\main\\java", "controller_path", "Controller");
        }
        pc.setPathInfo(pathInfo);
        autoGenerator.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
            }
        };
        autoGenerator.setCfg(cfg);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        strategy.setInclude(new String[]{this.tableName});
        if (StringUtils.isNotBlank((CharSequence)this.superMapperClass)) {
            strategy.setSuperMapperClass(this.superMapperClass);
        }
        if (StringUtils.isNotBlank((CharSequence)this.superServiceClass)) {
            strategy.setSuperServiceClass(this.superServiceClass);
        }
        if (StringUtils.isNotBlank((CharSequence)this.superServiceImplClass)) {
            strategy.setSuperServiceImplClass(this.superServiceImplClass);
        }
        if (StringUtils.isNotBlank((CharSequence)this.superControllerClass)) {
            strategy.setSuperControllerClass(this.superControllerClass);
        }
        strategy.setControllerMappingHyphenStyle(false);
        strategy.setTablePrefix(new String[]{this.tablePrefix});
        autoGenerator.setStrategy(strategy);
        autoGenerator.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        autoGenerator.execute();
    }

    private static String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private static String joinPackage(String parent, String subPackage) {
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }

    private void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            pathInfo.put(path, CustomCodeGenerator.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }
}

