/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.media.encoder;

import cn.acyou.leo.framework.media.encoder.ExecProcess;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileSystemUtils;
import ws.schild.jave.Encoder;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.encode.VideoAttributes;
import ws.schild.jave.filters.Filter;
import ws.schild.jave.filters.FilterChain;
import ws.schild.jave.filters.FilterGraph;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.info.VideoInfo;
import ws.schild.jave.info.VideoSize;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;

public class MediaUtil {
    private static final Logger log = LoggerFactory.getLogger(MediaUtil.class);
    private static final DefaultFFMPEGLocator ffmpegLocator = new DefaultFFMPEGLocator();
    private ExecProcess execProcess;

    private MediaUtil(ExecProcess execProcess) {
        this.execProcess = execProcess;
    }

    public static MediaUtil instance() {
        return new MediaUtil(new ExecProcess(){});
    }

    public static MediaUtil instance(ExecProcess execProcess) {
        return new MediaUtil(execProcess);
    }

    public void exec(List<String> commands) {
        this.exec(commands.toArray(new String[0]));
    }

    public void exec(String ... command) {
        Object[] args = (String[])ArrayUtils.addFirst((Object[])command, (Object)ffmpegLocator.getExecutablePath());
        log.info("\u6267\u884cFFMPEG\u5f00\u59cb \u547d\u4ee4:{}", (Object)StringUtils.join((Object[])args, (String)" "));
        List objects = CollectionUtils.arrayToList((Object)args);
        int i = objects.indexOf("-i");
        String input = "";
        if (i > 0) {
            input = (String)objects.get(i + 1);
        }
        try {
            Process proc = Runtime.getRuntime().exec((String[])args);
            if (this.execProcess != null) {
                this.execProcess.handlerOutPut(input, proc.getErrorStream());
            }
            proc.waitFor();
            if (this.execProcess != null) {
                this.execProcess.progress(1000L);
            }
            log.info("\u6267\u884cFFMPEG\u6210\u529f \u547d\u4ee4:{}", (Object)StringUtils.join((Object[])args, (String)" "));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u6267\u884cFFMPEG\u51fa\u9519 \u547d\u4ee4:{}", (Object)StringUtils.join((Object[])args, (String)" "));
            throw new RuntimeException("\u6267\u884cFFMPEG\u51fa\u9519 \u547d\u4ee4:{}" + StringUtils.join((Object[])args, (String)" "));
        }
    }

    public Long getFrameCount(String source) {
        log.info("\u83b7\u53d6\u89c6\u9891\u5e27\u6570 params:[source:{}] ", (Object)source);
        final Long[] frameCount = new Long[]{0L};
        this.execProcess = new ExecProcess(){

            @Override
            public void frame(Long frame) {
                frameCount[0] = frame;
            }
        };
        this.exec("-i", source, "-map", "0:v:0", "-c", "copy", "-f", "null", "-");
        return frameCount[0];
    }

    public void cutAudio(String source, long ss, long to, String targetPath) {
        boolean mkdirs = new File(targetPath).getParentFile().mkdirs();
        log.info("\u526a\u5207\u97f3\u9891\u6587\u4ef6 params:[source:{}, ss:{}, to:{}, target:{}] \u76ee\u6807\u76ee\u5f55\uff1a{}", new Object[]{source, ss, to, targetPath, mkdirs ? "\u521b\u5efa\u6210\u529f" : "\u65e0\u9700\u521b\u5efa"});
        this.exec("-y", "-i", source, "-ss", MediaUtil.formatDuration(ss), "-to", MediaUtil.formatDuration(to), "-c", "copy", targetPath);
    }

    public void mergeAudioAndVideo(String audioSource, String videoSource, String targetPath) {
        boolean mkdirs = new File(targetPath).getParentFile().mkdirs();
        log.info("\u5408\u5e76\u97f3/\u89c6\u9891\u6587\u4ef6 params:[audioSource:{}, videoSource:{}, target:{}] \u76ee\u6807\u76ee\u5f55\uff1a{}", new Object[]{audioSource, videoSource, targetPath, mkdirs ? "\u521b\u5efa\u6210\u529f" : "\u65e0\u9700\u521b\u5efa"});
        this.exec("-y", "-i", audioSource, "-i", videoSource, "-vcodec", "copy", "-acodec", "copy", targetPath);
    }

    public static String formatDuration(long mss) {
        String hours = mss % 86400000L / 3600000L + "";
        hours = hours.length() == 1 ? 0 + hours : hours;
        String minutes = mss % 3600000L / 60000L + "";
        minutes = minutes.length() == 1 ? 0 + minutes : minutes;
        String seconds = new BigDecimal(mss % 60000L).divide(new BigDecimal(1000), 3, RoundingMode.CEILING).toString();
        seconds = seconds.indexOf(".") == 1 ? 0 + seconds : seconds;
        return hours + ":" + minutes + ":" + seconds;
    }

    public static long parseDuration(String str) {
        String[] split = str.split("\\.");
        String hms = split[0];
        long ms = Long.parseLong(split[1]);
        String[] hmsArray = hms.split(":");
        long h = Long.parseLong(hmsArray[0]);
        long m = Long.parseLong(hmsArray[1]);
        long s = Long.parseLong(hmsArray[2]);
        return ms + s * 1000L + m * 60L * 1000L + h * 60L * 60L * 1000L;
    }

    public void extractFrame(String i, String ss, String targetPath) {
        boolean mkdirs = new File(targetPath).getParentFile().mkdirs();
        log.info("\u63d0\u53d6\u5e27 params:[i:{}, ss:{}, target:{}] \u76ee\u6807\u76ee\u5f55\uff1a{}", new Object[]{i, ss, targetPath, mkdirs ? "\u521b\u5efa\u6210\u529f" : "\u65e0\u9700\u521b\u5efa"});
        this.exec("-y", "-i", i, "-ss", ss, "-f", "image2", targetPath);
    }

    public String[] extractFrameBySpeedRatio(String url, int[] speedRatio, String targetDir) throws Exception {
        String[] paths = new String[speedRatio.length];
        MultimediaObject object = new MultimediaObject(new URL(url));
        MultimediaInfo info = object.getInfo();
        long duration = info.getDuration();
        for (int i = 0; i < speedRatio.length; ++i) {
            int t = (int)((double)duration * ((double)speedRatio[i] * 0.01));
            String targetPath = targetDir + File.separator + "frame_" + t + ".jpg";
            this.extractFrame(url, new BigDecimal(t).multiply(new BigDecimal("0.001")).toString(), targetPath);
            paths[i] = targetPath;
        }
        return paths;
    }

    public void separateAudioChannel(String url, Map<String, String> channelOut) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("-i");
        command.add(url);
        channelOut.forEach((k, v) -> {
            command.add("-map_channel");
            command.add((String)k);
            command.add((String)v);
        });
        this.exec(command.toArray(new String[0]));
    }

    public void extractCover(File source, File target) {
        this.extractCover(source.getAbsolutePath(), target, null);
    }

    public void extractCover(String source, File target, String offset) {
        MultimediaObject object = this.getMediaObject(source);
        if (object == null) {
            log.error("\u539f\u5bf9\u8c61\u4e0d\u5408\u6cd5\uff1a{}", (Object)source);
        }
        try {
            VideoAttributes video = new VideoAttributes();
            video.setCodec("png");
            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setOutputFormat("image2");
            attrs.setOffset(Float.valueOf(0.01f));
            attrs.setDuration(Float.valueOf(0.01f));
            if (StringUtils.isNotBlank((CharSequence)offset)) {
                attrs.setOffset(Float.valueOf(offset));
            }
            attrs.setVideoAttributes(video);
            Encoder encoder = new Encoder();
            encoder.encode(object, target, attrs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public File concatAudio(List<File> files, String target) {
        try {
            File file = new File(target);
            ArrayList multimediaObjects = new ArrayList();
            files.forEach(s -> multimediaObjects.add(new MultimediaObject(s)));
            Encoder encoder = new Encoder();
            AudioAttributes audioAttributes = new AudioAttributes();
            VideoAttributes videoAttributes = new VideoAttributes();
            FilterGraph customFilter = new FilterGraph();
            FilterChain filterChain = new FilterChain();
            String s2 = MediaUtil.buildString(files.size());
            filterChain.addFilter(new Filter(s2));
            customFilter.addChain(filterChain);
            videoAttributes.setComplexFiltergraph(customFilter);
            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setVideoAttributes(videoAttributes);
            attrs.setAudioAttributes(audioAttributes);
            encoder.encode(multimediaObjects, file, attrs);
            return file;
        }
        catch (Exception ex) {
            log.error("concatAudio ex", (Throwable)ex);
            return null;
        }
    }

    public File concatVideo2(List<String> files, String target) {
        try {
            File file = new File(target);
            ArrayList multimediaObjects = new ArrayList();
            files.forEach(s -> multimediaObjects.add(this.getMediaObject((String)s)));
            Encoder encoder = new Encoder();
            AudioAttributes audioAttributes = new AudioAttributes();
            VideoAttributes videoAttributes = new VideoAttributes();
            FilterGraph customFilter = new FilterGraph();
            FilterChain filterChain = new FilterChain();
            String s2 = MediaUtil.buildStringVideo(files.size());
            filterChain.addFilter(new Filter(s2));
            customFilter.addChain(filterChain);
            videoAttributes.setComplexFiltergraph(customFilter);
            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setVideoAttributes(videoAttributes);
            attrs.setAudioAttributes(audioAttributes);
            encoder.encode(multimediaObjects, file, attrs);
            return file;
        }
        catch (Exception ex) {
            log.error("concatVideo2 ex", (Throwable)ex);
            return null;
        }
    }

    private static String buildStringVideo(Integer num) {
        String build = "";
        for (int i = 0; i < num; ++i) {
            build = build + "[" + i + ":0][" + i + ":1]";
        }
        return build + "concat=n=" + num + ":v=1:a=1";
    }

    private static String buildString(Integer num) {
        String build = "";
        for (int i = 0; i < num; ++i) {
            build = build + "[" + i + ":0]";
        }
        return build + "concat=n=" + num + ":v=0:a=1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatVideo(List<String> urls, String targetPath) throws Exception {
        boolean mkdirs = new File(targetPath).getParentFile().mkdirs();
        log.info("\u62fc\u63a5\u89c6\u9891 params:[urls:{},  target:{}] \u76ee\u6807\u76ee\u5f55\uff1a{}", new Object[]{urls, targetPath, mkdirs ? "\u521b\u5efa\u6210\u529f" : "\u65e0\u9700\u521b\u5efa"});
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("MediaUtil_concatVideo_", new FileAttribute[0]);
            ArrayList<String> tsList = new ArrayList<String>();
            for (int i = 0; i < urls.size(); ++i) {
                File tempTs = new File(tempDir.toFile(), i + ".ts");
                this.exec("-i", urls.get(i), "-vcodec", "copy", "-acodec", "copy", tempTs.getAbsolutePath());
                tsList.add(tempTs.getAbsolutePath());
            }
            this.exec("-i", "concat:" + StringUtils.join(tsList, (String)"|"), "-vcodec", "copy", "-acodec", "copy", targetPath);
        }
        catch (Throwable throwable) {
            FileSystemUtils.deleteRecursively(tempDir);
            throw throwable;
        }
        FileSystemUtils.deleteRecursively((Path)tempDir);
    }

    public void compressVideo(String i, String s, String bv, String r, String fs, String targetPath) {
        boolean mkdirs = new File(targetPath).getParentFile().mkdirs();
        log.info("\u538b\u7f29\u89c6\u9891 params:[i:{},  target:{}] \u76ee\u6807\u76ee\u5f55\uff1a{}", new Object[]{i, targetPath, mkdirs ? "\u521b\u5efa\u6210\u529f" : "\u65e0\u9700\u521b\u5efa"});
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-i");
        commands.add(i);
        if (s != null && s.length() > 0) {
            commands.add("-s");
            commands.add(s);
        }
        if (bv != null && bv.length() > 0) {
            commands.add("-b:v");
            commands.add(bv);
        }
        if (r != null && r.length() > 0) {
            commands.add("-r");
            commands.add(r);
        }
        if (fs != null && fs.length() > 0) {
            commands.add("-fs");
            commands.add(fs);
        }
        commands.add(targetPath);
        this.exec(commands);
    }

    public long getMediaDuration(String i) {
        log.info("\u83b7\u53d6\u5a92\u4f53\u65f6\u957f\u4fe1\u606f\uff1a{}", (Object)i);
        try {
            MultimediaInfo mediaInfo = this.getMediaInfo(i);
            return mediaInfo.getDuration();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u83b7\u53d6\u5a92\u4f53\u65f6\u957f\u4fe1\u606f\uff1a" + i);
        }
    }

    public MultimediaInfo getMediaInfo(String i) {
        log.info("\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\uff1a{}", (Object)i);
        try {
            if (StringUtils.isNotBlank((CharSequence)i)) {
                if (i.toLowerCase().startsWith("http")) {
                    return new MultimediaObject(new URL(i)).getInfo();
                }
                return new MultimediaObject(new File(i)).getInfo();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\u51fa\u9519\uff1a" + i);
    }

    public MultimediaObject getMediaObject(String i) {
        log.info("\u83b7\u53d6\u5a92\u4f53\u5bf9\u8c61\uff1a{}", (Object)i);
        try {
            if (StringUtils.isNotBlank((CharSequence)i)) {
                if (i.toLowerCase().startsWith("http")) {
                    return new MultimediaObject(new URL(i));
                }
                return new MultimediaObject(new File(i));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u5a92\u4f53\u5bf9\u8c61\u51fa\u9519\uff1a" + i);
    }

    public static VideoSize getRealVideoSize(MultimediaInfo multimediaInfo) {
        VideoInfo video = multimediaInfo.getVideo();
        Map metadata = video.getMetadata();
        String rotate = (String)metadata.get("rotate");
        if (StringUtils.isNotBlank((CharSequence)rotate) && ("90".equals(rotate) || "270".equals(rotate))) {
            VideoSize size = video.getSize();
            return new VideoSize(size.getHeight().intValue(), size.getWidth().intValue());
        }
        return video.getSize();
    }
}

