/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.media.util;

import cn.acyou.leo.framework.media.util.ImageInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static void compressImage(URL url, File targetPath) throws Exception {
        targetPath.getParentFile().mkdirs();
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(5000);
        InputStream is = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(targetPath);
        ImageUtil.compressImage(is, os);
    }

    public static void compressImage(File sourceFile, File targetPath) throws Exception {
        targetPath.getParentFile().mkdirs();
        FileInputStream is = new FileInputStream(sourceFile);
        FileOutputStream os = new FileOutputStream(targetPath);
        ImageUtil.compressImage(is, os);
    }

    public static void compressImage(InputStream is, OutputStream os) throws Exception {
        BufferedImage img = ImageIO.read(is);
        int width = ((Image)img).getWidth(null);
        int height = ((Image)img).getHeight(null);
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, width, height, Color.LIGHT_GRAY, null);
        g.dispose();
        ImageIO.write((RenderedImage)bi, "jpg", os);
        is.close();
        os.close();
    }

    public static ImageInfo getImageInfo(String source) throws Exception {
        BufferedImage image;
        ImageInfo imageInfo = new ImageInfo();
        if (source.startsWith("http")) {
            URL url = new URL(source);
            URLConnection c = url.openConnection();
            imageInfo.setSize(c.getContentLength());
            image = ImageIO.read(c.getInputStream());
        } else {
            File file = new File(source);
            imageInfo.setSize(file.length());
            image = ImageIO.read(new FileInputStream(file));
        }
        imageInfo.setHeight(image.getHeight());
        imageInfo.setWidth(image.getWidth());
        String type = "";
        if (source.lastIndexOf(".") > 0) {
            type = source.substring(source.lastIndexOf(".") + 1);
        }
        imageInfo.setType(type);
        return imageInfo;
    }
}

