/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.media.encoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.info.AudioInfo;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.info.VideoInfo;
import ws.schild.jave.info.VideoSize;
import ws.schild.jave.utils.RBufferedReader;

public abstract class ExecProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ExecProcess.class);
    private long inputDuration = 0L;
    private MultimediaInfo info = null;
    private boolean callInfo = false;
    private Long lastFrame;
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)x(\\d+)", 2);
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("([\\d.]+)\\s+(?:fps|tbr)", 2);
    private static final Pattern BIT_RATE_PATTERN = Pattern.compile("(\\d+)\\s+kb/s", 2);
    private static final Pattern SAMPLING_RATE_PATTERN = Pattern.compile("(\\d+)\\s+Hz", 2);
    private static final Pattern CHANNELS_PATTERN = Pattern.compile("(mono|stereo|quad)", 2);
    private static final Pattern PROGRESS_INFO_PATTERN = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\\S+)\\s*", 2);
    private static final Pattern p1 = Pattern.compile("^\\s*Input #0, (\\w+).+$\\s*", 2);
    private static final Pattern p21 = Pattern.compile("^\\s*Duration:.*$", 2);
    private static final Pattern p22 = Pattern.compile("^\\s*Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d).*$", 2);
    private static final Pattern p3 = Pattern.compile("^\\s*Stream #\\S+: ((?:Audio)|(?:Video)|(?:Data)): (.*)\\s*$", 2);
    private static final Pattern p4 = Pattern.compile("^\\s*Metadata:", 2);
    private static final Pattern p5 = Pattern.compile("^\\s*(\\w+)\\s*:\\s*(\\S+)\\s*$", 2);

    public void handlerOutPut(String input, InputStream errorStream) {
        this.parseMultimediaInfo(input, new RBufferedReader((Reader)new InputStreamReader(errorStream)));
    }

    private void parseMultimediaInfo(String source, RBufferedReader reader) {
        try {
            String line;
            int step = 0;
            while ((line = reader.readLine()) != null) {
                switch (step) {
                    case 0: {
                        String token = source + ": ";
                        if (line.startsWith(token)) {
                            String message = line.substring(token.length());
                            throw new RuntimeException(message);
                        }
                        Matcher m = p1.matcher(line);
                        if (!m.matches()) break;
                        String format = m.group(1);
                        this.info = new MultimediaInfo();
                        this.info.setFormat(format);
                        ++step;
                        break;
                    }
                    case 1: {
                        Matcher m1 = p21.matcher(line);
                        Matcher m2 = p22.matcher(line);
                        if (m1.matches()) {
                            if (m2.matches()) {
                                long hours = Integer.parseInt(m2.group(1));
                                long minutes = Integer.parseInt(m2.group(2));
                                long seconds = Integer.parseInt(m2.group(3));
                                long dec = Integer.parseInt(m2.group(4));
                                long duration = dec * 10L + seconds * 1000L + minutes * 60L * 1000L + hours * 60L * 60L * 1000L;
                                this.info.setDuration(duration);
                                this.inputDuration = duration;
                                ++step;
                                break;
                            }
                            ++step;
                            break;
                        }
                        Matcher m4 = p4.matcher(line);
                        if (!m4.matches()) break;
                        line = reader.readLine();
                        while (line != null && !p21.matcher(line).matches()) {
                            Matcher m5 = p5.matcher(line);
                            if (m5.matches()) {
                                this.info.getMetadata().put(m5.group(1), m5.group(2));
                            }
                            line = reader.readLine();
                        }
                        reader.reinsertLine(line);
                        break;
                    }
                    case 2: {
                        boolean parsed;
                        Matcher m = p3.matcher(line);
                        if (!m.matches()) break;
                        String type = m.group(1);
                        String specs = m.group(2);
                        if ("Video".equalsIgnoreCase(type)) {
                            VideoInfo video = new VideoInfo();
                            StringTokenizer st = new StringTokenizer(specs, ",");
                            int i = 0;
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken().trim();
                                if (i == 0) {
                                    video.setDecoder(token);
                                } else {
                                    parsed = false;
                                    Matcher m2 = SIZE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int width = Integer.parseInt(m2.group(1));
                                        int height = Integer.parseInt(m2.group(2));
                                        video.setSize(new VideoSize(width, height));
                                        parsed = true;
                                    }
                                    m2 = FRAME_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        try {
                                            float frameRate = Float.parseFloat(m2.group(1));
                                            video.setFrameRate(frameRate);
                                        }
                                        catch (NumberFormatException e) {
                                            LOG.info("Invalid frame rate value: " + m2.group(1), (Throwable)e);
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        video.setBitRate(bitRate * 1000);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            line = reader.readLine();
                            Matcher m4 = p4.matcher(line);
                            if (m4.matches()) {
                                line = reader.readLine();
                                while (line != null && p5.matcher(line).matches()) {
                                    Matcher m5 = p5.matcher(line);
                                    if (m5.matches()) {
                                        video.getMetadata().put(m5.group(1), m5.group(2));
                                    }
                                    line = reader.readLine();
                                }
                                reader.reinsertLine(line);
                            } else {
                                reader.reinsertLine(line);
                            }
                            this.info.setVideo(video);
                            break;
                        }
                        if (!"Audio".equalsIgnoreCase(type)) break;
                        AudioInfo audio = new AudioInfo();
                        StringTokenizer st = new StringTokenizer(specs, ",");
                        int i = 0;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            if (i == 0) {
                                audio.setDecoder(token);
                            } else {
                                parsed = false;
                                Matcher m2 = SAMPLING_RATE_PATTERN.matcher(token);
                                if (!parsed && m2.find()) {
                                    int samplingRate = Integer.parseInt(m2.group(1));
                                    audio.setSamplingRate(samplingRate);
                                    parsed = true;
                                }
                                m2 = CHANNELS_PATTERN.matcher(token);
                                if (!parsed && m2.find()) {
                                    String ms = m2.group(1);
                                    if ("mono".equalsIgnoreCase(ms)) {
                                        audio.setChannels(1);
                                    } else if ("stereo".equalsIgnoreCase(ms)) {
                                        audio.setChannels(2);
                                    } else if ("quad".equalsIgnoreCase(ms)) {
                                        audio.setChannels(4);
                                    }
                                    parsed = true;
                                }
                                m2 = BIT_RATE_PATTERN.matcher(token);
                                if (!parsed && m2.find()) {
                                    int bitRate = Integer.parseInt(m2.group(1));
                                    audio.setBitRate(bitRate * 1000);
                                    parsed = true;
                                }
                            }
                            ++i;
                        }
                        line = reader.readLine();
                        Matcher m4 = p4.matcher(line);
                        if (m4.matches()) {
                            line = reader.readLine();
                            while (line != null && p5.matcher(line).matches()) {
                                Matcher m5 = p5.matcher(line);
                                if (m5.matches()) {
                                    audio.getMetadata().put(m5.group(1), m5.group(2));
                                }
                                line = reader.readLine();
                            }
                            reader.reinsertLine(line);
                        } else {
                            reader.reinsertLine(line);
                        }
                        this.info.setAudio(audio);
                        break;
                    }
                }
                if (!line.startsWith("frame=") && !line.startsWith("size=")) continue;
                if (!this.callInfo) {
                    this.mediaInfo(this.info);
                    this.callInfo = true;
                }
                try {
                    int perm;
                    String time;
                    HashMap<String, String> table;
                    if ((line = line.trim()).length() <= 0 || (table = this.parseProgressInfoLine(line)) == null) continue;
                    String frame = table.get("frame");
                    if (frame != null) {
                        this.lastFrame = Long.valueOf(frame);
                    }
                    if ((time = table.get("time")) == null) continue;
                    String[] dParts = time.split(":");
                    Double seconds = Double.parseDouble(dParts[dParts.length - 1]);
                    if (dParts.length > 1) {
                        seconds = seconds + Double.parseDouble(dParts[dParts.length - 2]) * 60.0;
                        if (dParts.length > 2) {
                            seconds = seconds + Double.parseDouble(dParts[dParts.length - 3]) * 60.0 * 60.0;
                        }
                    }
                    if ((perm = (int)Math.round(seconds * 1000.0 * 1000.0 / (double)this.inputDuration)) >= 1000) continue;
                    this.progress(perm);
                }
                catch (Exception ex) {
                    LOG.warn("Error in progress parsing for line: {}", (Object)line);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.lastFrame != null) {
            this.frame(this.lastFrame);
        }
        if (this.info == null) {
            throw new RuntimeException();
        }
    }

    public void mediaInfo(MultimediaInfo multimediaInfo) {
    }

    public void frame(Long frame) {
    }

    public void progress(long perm) {
    }

    private HashMap<String, String> parseProgressInfoLine(String line) {
        HashMap<String, String> table = null;
        Matcher m = PROGRESS_INFO_PATTERN.matcher(line);
        while (m.find()) {
            if (table == null) {
                table = new HashMap<String, String>();
            }
            String key = m.group(1);
            String value = m.group(2);
            table.put(key, value);
        }
        return table;
    }
}

