/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.media.encoder;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    Util() {
    }

    public static String proportion(int x, int y) {
        if (x == 0 || y == 0) {
            return "9:16";
        }
        int i = Util.commonDivisor(x, y);
        return x / i + ":" + y / i;
    }

    private static int commonDivisor(int M, int N) {
        M = Math.abs(M);
        if ((N = Math.abs(N)) == 0) {
            return M;
        }
        return Util.commonDivisor(N, M % N);
    }

    public static long getContentLength(String i) {
        try {
            if (StringUtils.isNotBlank((CharSequence)i)) {
                if (i.toLowerCase().startsWith("http")) {
                    return Util.getContentLength(new URL(i));
                }
                return Util.getContentLength(new File(i));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL url) {
        if (null == url) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static long getContentLength(File file) {
        if (null == file) {
            return -1L;
        }
        try {
            return file.length();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.2f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.2f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }
}

