/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.framework.push.umeng;

import cn.acyou.leo.framework.ClientEnum;
import cn.acyou.leo.framework.push.prop.UmengProperties;
import cn.acyou.leo.framework.push.umeng.AndroidNotification;
import cn.acyou.leo.framework.push.umeng.CustomizedcastBo;
import cn.acyou.leo.framework.push.umeng.CustomizedcastDTO;
import cn.acyou.leo.framework.push.umeng.PushClient;
import cn.acyou.leo.framework.push.umeng.android.AndroidCustomizedcast;
import cn.acyou.leo.framework.push.umeng.ios.IOSCustomizedcast;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushUtils {
    private static final Logger log = LoggerFactory.getLogger(PushUtils.class);
    private static final PushClient client = new PushClient();
    private UmengProperties umengProperties;

    public PushUtils(UmengProperties umengProperties) {
        this.umengProperties = umengProperties;
        log.info("\u53cb\u76df\u63a8\u9001 \u914d\u7f6e\u5b8c\u6210\uff1a{}", (Object)umengProperties);
    }

    public void sendCustomizedcast(CustomizedcastDTO param) {
        log.info("\u53cb\u76df\u63a8\u9001\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        ClientEnum deviceType = param.getDeviceType();
        CustomizedcastBo customizedcastBo = new CustomizedcastBo();
        customizedcastBo.setTicker(param.getTicker());
        customizedcastBo.setTitle(param.getTitle());
        customizedcastBo.setText(param.getText());
        customizedcastBo.setCustomField(param.getCustomField());
        customizedcastBo.setTest(this.umengProperties.isTest());
        customizedcastBo.setAliasType("userId");
        customizedcastBo.setAlias(String.valueOf(param.getUserId()));
        switch (deviceType) {
            case ANDROID: {
                customizedcastBo.setAppkey(this.umengProperties.getAndroid().getAppkey());
                customizedcastBo.setAppMasterSecret(this.umengProperties.getAndroid().getAppMasterSecret());
                PushUtils.sendAndroidCustomizedcast(customizedcastBo);
                break;
            }
            case IOS: {
                customizedcastBo.setAppkey(this.umengProperties.getIos().getAppkey());
                customizedcastBo.setAppMasterSecret(this.umengProperties.getIos().getAppMasterSecret());
                PushUtils.sendIOSCustomizedcast(customizedcastBo);
                break;
            }
        }
    }

    public static void sendIOSCustomizedcast(CustomizedcastBo vo) {
        try {
            IOSCustomizedcast customizedcast = new IOSCustomizedcast(vo.getAppkey(), vo.getAppMasterSecret());
            customizedcast.setAlias(vo.getAlias(), vo.getAliasType());
            customizedcast.setAlert(vo.getTitle(), "", vo.getText());
            customizedcast.setBadge(0);
            customizedcast.setSound("default");
            if (vo.getCustomField() != null && !vo.getCustomField().isEmpty()) {
                for (Map.Entry<String, String> entry : vo.getCustomField().entrySet()) {
                    customizedcast.setCustomizedField(entry.getKey(), entry.getValue());
                }
            }
            if (vo.isTest()) {
                customizedcast.setTestMode();
            } else {
                customizedcast.setProductionMode();
            }
            client.send(customizedcast);
            log.info("IOS \u63a8\u9001\u4fe1\u606f\u7ed9IOS\u7528\u6237\u5b8c\u6210 userId:{}", (Object)vo.getUserId());
        }
        catch (Exception e) {
            log.error("IOS \u63a8\u9001\u4fe1\u606f\u7ed9IOS\u7528\u6237\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    public static void sendAndroidCustomizedcast(CustomizedcastBo vo) {
        try {
            AndroidCustomizedcast customizedcast = new AndroidCustomizedcast(vo.getAppkey(), vo.getAppMasterSecret());
            customizedcast.setAlias(vo.getAlias(), vo.getAliasType());
            customizedcast.setTicker(vo.getTicker());
            customizedcast.setTitle(vo.getTitle());
            customizedcast.setText(vo.getText());
            customizedcast.goAppAfterOpen();
            customizedcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
            if (vo.getCustomField() != null && !vo.getCustomField().isEmpty()) {
                JSONObject custom = new JSONObject();
                for (Map.Entry<String, String> entry : vo.getCustomField().entrySet()) {
                    custom.put(entry.getKey(), (Object)entry.getValue());
                }
                customizedcast.setCustomField(custom);
            }
            if (vo.isTest()) {
                customizedcast.setTestMode();
            } else {
                customizedcast.setProductionMode();
            }
            client.send(customizedcast);
            log.info("Android \u63a8\u9001\u4fe1\u606f\u7ed9Android\u7528\u6237\u5b8c\u6210 userId:{}", (Object)vo.getUserId());
        }
        catch (Exception e) {
            log.error("Android \u63a8\u9001\u4fe1\u606f\u7ed9Android\u7528\u6237\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }
}

