/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.gateway.config;

import cn.acyou.leo.gateway.exception.GatewayExceptionHandler;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.SentinelGatewayFilter;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.GatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.exception.SentinelGatewayBlockExceptionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration
public class GatewayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GatewayConfiguration.class);
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;

    public GatewayConfiguration(ObjectProvider<List<ViewResolver>> viewResolversProvider, ServerCodecConfigurer serverCodecConfigurer) {
        this.viewResolvers = (List)viewResolversProvider.getIfAvailable(Collections::emptyList);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    @Bean
    @Order(value=-2147483648)
    public SentinelGatewayBlockExceptionHandler sentinelGatewayBlockExceptionHandler() {
        return new SentinelGatewayBlockExceptionHandler(this.viewResolvers, this.serverCodecConfigurer);
    }

    @Bean
    @Order(value=-2147483648)
    public GlobalFilter sentinelGatewayFilter() {
        return new SentinelGatewayFilter();
    }

    @Primary
    @Bean
    @Order(value=-2147483648)
    public ErrorWebExceptionHandler errorWebExceptionHandler(ObjectProvider<List<ViewResolver>> viewResolversProvider, ServerCodecConfigurer serverCodecConfigurer) {
        GatewayExceptionHandler gatewayExceptionHandler = new GatewayExceptionHandler();
        gatewayExceptionHandler.setViewResolvers((List)viewResolversProvider.getIfAvailable(Collections::emptyList));
        gatewayExceptionHandler.setMessageWriters(serverCodecConfigurer.getWriters());
        gatewayExceptionHandler.setMessageReaders(serverCodecConfigurer.getReaders());
        return gatewayExceptionHandler;
    }

    @PostConstruct
    public void doInit() {
        this.initGatewayRules();
        GatewayCallbackManager.setBlockHandler((BlockRequestHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initCustomizedApis() {
        HashSet<ApiDefinition> definitions = new HashSet<ApiDefinition>();
        ApiDefinition apiProduct = new ApiDefinition("order_detail_api").setPredicateItems((Set)new /* Unavailable Anonymous Inner Class!! */);
        ApiDefinition anotherApi = new ApiDefinition("another_api").setPredicateItems((Set)new /* Unavailable Anonymous Inner Class!! */);
        definitions.add(apiProduct);
        definitions.add(anotherApi);
        GatewayApiDefinitionManager.loadApiDefinitions(definitions);
    }

    private void initGatewayRules() {
        HashSet<GatewayFlowRule> rules = new HashSet<GatewayFlowRule>();
        rules.add(new GatewayFlowRule("order-service").setCount(10.0).setIntervalSec(1L));
        rules.add(new GatewayFlowRule("product-service").setResourceMode(0).setCount(1.0).setIntervalSec(1L).setBurst(1).setControlBehavior(2).setMaxQueueingTimeoutMs(600).setParamItem(new GatewayParamFlowItem().setParseStrategy(0)));
        GatewayRuleManager.loadRules(rules);
    }
}

