/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.gateway.exception;

import cn.acyou.leo.gateway.exception.AbstractExceptionHandler;
import cn.acyou.leo.gateway.exception.GatewayExceptionHandler;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayExceptionHandler
extends AbstractExceptionHandler
implements ErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GatewayExceptionHandler.class);
    private static final String TRACE_ID = "traceId";
    private static final String INSTANCE_NOT_FOUND = "Unable to find instance for ";
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();
    private List<HttpMessageWriter<?>> messageWriters = Collections.emptyList();
    private List<ViewResolver> viewResolvers = Collections.emptyList();
    private ThreadLocal<Map<String, Object>> exceptionHandlerResult = new ThreadLocal();

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        Assert.notNull(messageReaders, (String)"'messageReaders' must not be null");
        this.messageReaders = messageReaders;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public void setMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
        Assert.notNull(messageWriters, (String)"'messageWriters' must not be null");
        this.messageWriters = messageWriters;
    }

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ex.printStackTrace();
        String errorMessage = super.formatMessage(ex);
        if (errorMessage.startsWith(INSTANCE_NOT_FOUND)) {
            errorMessage = String.format("\u670d\u52a1[%s]\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u542f\u52a8\uff01", errorMessage.substring(errorMessage.lastIndexOf(INSTANCE_NOT_FOUND) + INSTANCE_NOT_FOUND.length()));
        }
        Map errorMap = super.buildErrorMap(errorMessage);
        ServerHttpRequest request = exchange.getRequest();
        String traceId = request.getHeaders().getFirst(TRACE_ID);
        log.error("GatewayExceptionHandler request info [traceId={}] result error=[{}]", (Object)traceId, (Object)JSONObject.toJSONString((Object)errorMap));
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        this.exceptionHandlerResult.set(errorMap);
        ServerRequest newRequest = ServerRequest.create((ServerWebExchange)exchange, (List)this.messageReaders);
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> this.renderErrorResponse(arg_0)).route(newRequest).switchIfEmpty(Mono.error((Throwable)ex)).flatMap(handler -> handler.handle(newRequest)).flatMap(response -> this.write(exchange, response));
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        Map result = (Map)this.exceptionHandlerResult.get();
        return ServerResponse.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)result));
    }

    private Mono<? extends Void> write(ServerWebExchange exchange, ServerResponse response) {
        exchange.getResponse().getHeaders().setContentType(response.headers().getContentType());
        return response.writeTo(exchange, (ServerResponse.Context)new ResponseContext(this, null));
    }

    static /* synthetic */ List access$100(GatewayExceptionHandler x0) {
        return x0.messageWriters;
    }

    static /* synthetic */ List access$200(GatewayExceptionHandler x0) {
        return x0.viewResolvers;
    }
}

