/*
 * Decompiled with CFR 0.152.
 */
package cn.acyou.leo.gateway.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class RequestLogFilter
implements GlobalFilter,
Ordered {
    private static final Log log = LogFactory.getLog(RequestLogFilter.class);
    private static final String REQUEST_TIME_BEGIN = "requestTimeBegin";

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        exchange.getAttributes().put(REQUEST_TIME_BEGIN, System.currentTimeMillis());
        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            Long startTime = (Long)exchange.getAttribute(REQUEST_TIME_BEGIN);
            if (startTime != null) {
                log.info((Object)(exchange.getRequest().getURI().getRawPath() + ": " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }));
    }

    public int getOrder() {
        return 0;
    }
}

