/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.advntr;

import java.awt.Color;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class AdvntrMessageBuilder {
    private ComponentLike linePrefix = Component.text();
    private Audience audience;
    private final TextComponent.Builder component = Component.text();

    public AdvntrMessageBuilder text(String text) {
        this.component.append((Component)Component.text((String)text));
        return this;
    }

    public AdvntrMessageBuilder text(String text, Color color) {
        this.component.append(Component.text((String)text).color(TextColor.color((int)color.getRGB())));
        return this;
    }

    public AdvntrMessageBuilder mini(String mini) {
        this.component.append(MiniMessage.miniMessage().deserialize((Object)mini));
        return this;
    }

    public AdvntrMessageBuilder hover(HoverEventSource<?> source) {
        this.component.hoverEvent(source);
        return this;
    }

    public AdvntrMessageBuilder click(ClickEvent event) {
        this.component.clickEvent(event);
        return this;
    }

    public AdvntrMessageBuilder append(ComponentLike componentLike) {
        this.component.append(componentLike);
        return this;
    }

    public AdvntrMessageBuilder line() {
        this.component.append((Component)Component.newline());
        this.component.append(this.linePrefix);
        return this;
    }

    public AdvntrMessageBuilder emptyLine() {
        this.component.append((Component)Component.newline());
        return this;
    }

    public AdvntrMessageBuilder gradient(String text, Color ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (Color color : colors) {
            mini.append(":").append("#%02x%02x%02x".formatted(color.getRed(), color.getGreen(), color.getBlue()));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public AdvntrMessageBuilder gradient(String text, int ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (int color : colors) {
            mini.append(":").append("#%06x".formatted(color));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public TextComponent build() {
        return (TextComponent)this.component.build();
    }

    public void send() {
        if (this.audience == null) {
            throw new NullPointerException("No audience passed to this builder");
        }
        this.audience.sendMessage((Component)this.build());
    }

    public void send(Audience audience) {
        audience.sendMessage((Component)this.build());
    }

    public ComponentLike getLinePrefix() {
        return this.linePrefix;
    }

    public AdvntrMessageBuilder linePrefix(ComponentLike prefix) {
        this.linePrefix = prefix;
        return this;
    }

    public Audience getAudience() {
        return this.audience;
    }

    public AdvntrMessageBuilder audience(Audience audience) {
        this.audience = audience;
        return this;
    }
}

