/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.controller;

import com.alibaba.nacos.address.component.AddressServerGeneratorManager;
import com.alibaba.nacos.address.component.AddressServerManager;
import com.alibaba.nacos.address.misc.Loggers;
import com.alibaba.nacos.address.util.AddressServerParamCheckUtil;
import com.alibaba.nacos.api.naming.pojo.AbstractHealthChecker;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nacos/v1/as/nodes"})
public class AddressServerClusterController {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AddressServerManager addressServerManager;
    @Autowired
    private AddressServerGeneratorManager addressServerGeneratorManager;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity postCluster(@RequestParam(required=false) String product, @RequestParam(required=false) String cluster, @RequestParam(name="ips") String ips) {
        ResponseEntity responseEntity;
        String productName = this.addressServerGeneratorManager.generateProductName(product);
        String clusterName = this.addressServerManager.getDefaultClusterNameIfEmpty(cluster);
        String rawProductName = this.addressServerManager.getRawProductName(product);
        String rawClusterName = this.addressServerManager.getRawClusterName(cluster);
        Loggers.addressLogger.info("put cluster node,the cluster name is " + cluster + "; the product name=" + product + "; the ip list=" + ips);
        try {
            String serviceName = this.addressServerGeneratorManager.generateNacosServiceName(productName);
            Cluster clusterObj = new Cluster();
            clusterObj.setName(clusterName);
            clusterObj.setHealthChecker((AbstractHealthChecker)new AbstractHealthChecker.None());
            this.serviceManager.createServiceIfAbsent("public", serviceName, false, clusterObj);
            String[] ipArray = this.addressServerManager.splitIps(ips);
            String checkResult = AddressServerParamCheckUtil.checkIps(ipArray);
            if ("ok".equals(checkResult)) {
                List<Instance> instanceList = this.addressServerGeneratorManager.generateInstancesByIps(serviceName, rawProductName, clusterName, ipArray);
                for (Instance instance : instanceList) {
                    this.serviceManager.registerInstance("public", serviceName, instance);
                }
                responseEntity = ResponseEntity.ok((Object)("product=" + rawProductName + ",cluster=" + rawClusterName + "; put success with size=" + instanceList.size()));
            } else {
                responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)checkResult);
            }
        }
        catch (Exception e) {
            responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
        return responseEntity;
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ResponseEntity deleteCluster(@RequestParam(required=false) String product, @RequestParam(required=false) String cluster, @RequestParam String ips) {
        String productName = this.addressServerGeneratorManager.generateProductName(product);
        String clusterName = this.addressServerManager.getDefaultClusterNameIfEmpty(cluster);
        String rawProductName = this.addressServerManager.getRawProductName(product);
        String rawClusterName = this.addressServerManager.getRawClusterName(cluster);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("product=" + rawProductName + ", cluster=" + rawClusterName + " delete success."));
        try {
            String serviceName = this.addressServerGeneratorManager.generateNacosServiceName(productName);
            Service service = this.serviceManager.getService("public", serviceName);
            if (service == null) {
                responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + rawProductName + " not found."));
            } else if (StringUtils.isBlank((CharSequence)ips)) {
                responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"ips must not be empty.");
            } else {
                String[] ipArray = this.addressServerManager.splitIps(ips);
                String checkResult = AddressServerParamCheckUtil.checkIps(ipArray);
                if ("ok".equals(checkResult)) {
                    List<Instance> instanceList = this.addressServerGeneratorManager.generateInstancesByIps(serviceName, rawProductName, clusterName, ipArray);
                    this.serviceManager.removeInstance("public", serviceName, false, instanceList.toArray(new Instance[instanceList.size()]));
                } else {
                    responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)checkResult);
                }
            }
        }
        catch (Exception e) {
            responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getCause());
        }
        return responseEntity;
    }
}

