/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.controller;

import com.alibaba.nacos.address.component.AddressServerGeneratorManager;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServerListController {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AddressServerGeneratorManager addressServerBuilderManager;

    @RequestMapping(value={"/{product}/{cluster}"}, method={RequestMethod.GET})
    public ResponseEntity getCluster(@PathVariable String product, @PathVariable String cluster) {
        String productName = this.addressServerBuilderManager.generateProductName(product);
        String serviceName = this.addressServerBuilderManager.generateNacosServiceName(productName);
        Service service = this.serviceManager.getService("public", serviceName);
        if (service == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + product + " not found."));
        }
        if (!service.getClusterMap().containsKey(cluster)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("product=" + product + ",cluster=" + cluster + " not found."));
        }
        Cluster clusterObj = (Cluster)service.getClusterMap().get(cluster);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.addressServerBuilderManager.generateResponseIps(clusterObj.allIPs(false)));
    }
}

