/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressServerParamCheckUtil {
    public static final String CHECK_OK = "ok";
    public static final String ILLEGAL_IP_PREFIX = "illegal ip: ";
    private static final String IP_REGEX = "(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})(\\.(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})){3}";
    private static final Pattern IP_PATTERN = Pattern.compile("(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})(\\.(2(5[0-5]{1}|[0-4]\\d{1})|[0-1]?\\d{1,2})){3}");

    public static String checkIps(String ... ips) {
        if (ips == null || ips.length == 0) {
            return CHECK_OK;
        }
        StringBuilder illegalResponse = new StringBuilder();
        for (String ip : ips) {
            Matcher matcher = IP_PATTERN.matcher(ip);
            if (matcher.matches()) continue;
            illegalResponse.append(ip + ",");
        }
        if (illegalResponse.length() == 0) {
            return CHECK_OK;
        }
        return ILLEGAL_IP_PREFIX + illegalResponse.substring(0, illegalResponse.length() - 1);
    }
}

