package cn.ahzoo.utils.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum CommonResultCode {

    SUCCESS(200, "操作成功"),
    FAILED(400, "操作失败"),

    UNAUTHORIZED(403, "权限验证失败"),
    NOT_FOUND(404, "访问地址不存在"),
    SERVER_ERROR(500, "系统出错"),
    BIZ_ERROR(501, "业务异常"),
    ACCESS_VIOLATION(502, "非法访问"),
    ;

    private final int code;
    private final String message;

}
