package cn.ahzoo.utils.model;

import cn.ahzoo.utils.constant.ResultStateConstant;
import cn.ahzoo.utils.enums.CommonResultCode;

public record Result<T>(String state, int code, String message, T data) {

    public static <T> Result<T> success() {
        return new Result<>(ResultStateConstant.SUCCESS, CommonResultCode.SUCCESS.getCode(),
                CommonResultCode.SUCCESS.getMessage(), null);
    }

    public static <T> Result<T> success(T data) {
        return new Result<>(ResultStateConstant.SUCCESS, CommonResultCode.SUCCESS.getCode(),
                CommonResultCode.SUCCESS.getMessage(), data);
    }

    public static <T> Result<T> success(String message, T data) {
        return new Result<>(ResultStateConstant.SUCCESS, CommonResultCode.SUCCESS.getCode(),
                message, data);
    }


    public static <T> Result<T> failed() {
        return new Result<>(ResultStateConstant.ERROR, CommonResultCode.FAILED.getCode(),
                CommonResultCode.FAILED.getMessage(), null);
    }

    public static <T> Result<T> failed(int code, String message) {
        return new Result<>(ResultStateConstant.ERROR, code,
                message, null);
    }

    public static <T> Result<T> failed(String state, int code, String message) {
        return new Result<>(state, code,
                message, null);
    }

    public static <T> Result<T> failed(int code, String message, T data) {
        return new Result<>(ResultStateConstant.ERROR, code,
                message, data);
    }

    public static <T> Result<T> failed(String state, int code, String message, T data) {
        return new Result<>(state, code,
                message, data);
    }
}
