package cn.ahzoo.utils.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class DataUtil {

    public static int getDayOfToday(){
        LocalDate currentDate = LocalDate.now();
        return currentDate.getDayOfMonth();
    }

    public static int getDayOfYesterday(){
        LocalDate yesterday = LocalDate.now().minusDays(1);
        return yesterday.getDayOfMonth();
    }

    public Date getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        return calendar.getTime();
    }

    public String getYesterdayStr(String dateformat) {
        Date yesterday = getYesterday();
        SimpleDateFormat sdf = new SimpleDateFormat(dateformat);
        return sdf.format(yesterday);
    }

}
