/*
 * Decompiled with CFR 0.152.
 */
package cn.ahzoo.utils.model;

import cn.ahzoo.utils.enums.CommonResultCode;

public record Result<T>(String state, int code, String message, T data) {
    public static <T> Result<T> success() {
        return new Result<Object>("success", CommonResultCode.SUCCESS.getCode(), CommonResultCode.SUCCESS.getMessage(), null);
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>("success", CommonResultCode.SUCCESS.getCode(), CommonResultCode.SUCCESS.getMessage(), data);
    }

    public static <T> Result<T> success(String message, T data) {
        return new Result<T>("success", CommonResultCode.SUCCESS.getCode(), message, data);
    }

    public static <T> Result<T> failed() {
        return new Result<Object>("error", CommonResultCode.FAILED.getCode(), CommonResultCode.FAILED.getMessage(), null);
    }

    public static <T> Result<T> failed(int code, String message) {
        return new Result<Object>("error", code, message, null);
    }

    public static <T> Result<T> failed(String state, int code, String message) {
        return new Result<Object>(state, code, message, null);
    }

    public static <T> Result<T> failed(int code, String message, T data) {
        return new Result<T>("error", code, message, data);
    }

    public static <T> Result<T> failed(String state, int code, String message, T data) {
        return new Result<T>(state, code, message, data);
    }
}

