package cn.ahzoo.utils.model;


import cn.ahzoo.utils.constant.ResultStateConstant;
import cn.ahzoo.utils.enums.CommonResultCode;

/**
 * @description 统一的List返回结果
 * @author 十玖八柒（Ahzoo）
 * @version 1.0
 *
 * @param state   请求状态
 * @param code    请求状态码
 * @param message 提示消息
 * @param page    分页对象
 * @param data    返回数据
 * @param <T>
 */
public record ResultList<T>(String state, int code, String message, ResultPage page, T data) {

    public static <T> ResultList<T> success() {
        return new ResultList<>(ResultStateConstant.SUCCESS, CommonResultCode.SUCCESS.getCode(),
                CommonResultCode.SUCCESS.getMessage(), ResultPage.emptyPage(), null);
    }

    public static <T> ResultList<T> success(String message, ResultPage page, T data) {
        return new ResultList<>(ResultStateConstant.SUCCESS, CommonResultCode.SUCCESS.getCode(),
                message, page, data);
    }

    public static <T> ResultList<T> success(ResultPage page, T data) {
        return new ResultList<>(ResultStateConstant.SUCCESS,
                CommonResultCode.SUCCESS.getCode(), CommonResultCode.SUCCESS.getMessage(),
                page, data);
    }

    public static <T> ResultList<T> failed(int code, String message, ResultPage page, T data) {
        return new ResultList<>(ResultStateConstant.ERROR, code, message, page, data);
    }

}
