package cn.allbs.im.wx;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 枚举 MsgTypeEnum
 * </p>
 *
 * @author ChenQi
 * @since 2022/8/16 17:07
 */
@Getter
@RequiredArgsConstructor
public enum MsgTypeEnum {

    /**
     * 文本消息
     */
    TEXT("text", "文本消息"),

    IMAGE("image", "图片消息"),

    VOICE("voice", "语音消息"),

    VIDEO("video", "视频消息"),

    MUSIC("music", "音乐消息"),

    NEWS("news", "图文消息（点击跳转到外链）"),

    MP_NEWS("mpnews", "图文消息（点击跳转到图文消息页面）"),

    MP_NEWS_ARTICLE("mpnewsarticle", "发送图文消息（点击跳转到图文消息页面）"),

    MSG_MENU("msgmenu", "菜单消息");

    /**
     * 消息类型
     */
    private final String msgType;

    /**
     * 消息类型翻译
     */
    private final String msgTypeDetail;
}
