package cn.allbs.im.wx;

import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 类 WxMsgPushConfiguration
 * </p>
 *
 * @author ChenQi
 * @since 2022/8/16 17:27
 */
@Configuration
@EnableConfigurationProperties({WxChatProperties.class})
@AllArgsConstructor
public class WxMsgPushConfiguration {

    private final WxChatProperties wxChatProperties;

    @Bean
    @ConditionalOnMissingBean(WxMsgPushTemplate.class)
    public WxMsgPushTemplate influxTemplate() {
        WxMsgPushTemplate wxMsgPushTemplate = new WxMsgPushTemplate(wxChatProperties);
        return wxMsgPushTemplate;
    }
}
