package cn.allbs.im.wx;

import cn.allbs.im.wx.msg.MsgTextInfo;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;

/**
 * 类 WxMsgPushTemplate
 * </p>
 *
 * @author ChenQi
 * @since 2022/8/16 17:29
 */
@Slf4j
public class WxMsgPushTemplate {

    private final WxChatProperties wxChatProperties;

    public WxMsgPushTemplate(WxChatProperties wxChatProperties) {
        this.wxChatProperties = wxChatProperties;
    }

    /**
     * 微信消息推送
     *
     * @param msgTextInfo 文本消息内容
     */
    public void textPush(MsgTextInfo msgTextInfo) {
        try {
            HashMap<String, Object> tokenMap = new HashMap<>(2);
            tokenMap.put("corpid", wxChatProperties.getCorpid());
            tokenMap.put("corpsecret", wxChatProperties.getCorpsecret());
            // 获取token
            String result = HttpUtil.get(wxChatProperties.getTokenUri(), tokenMap);
            JSONObject jsonObject = JSONUtil.parseObj(result);
            // 发送消息
            JSONObject body = new JSONObject();
            body.set("touser", msgTextInfo.getToUser());
            body.set("msgtype", "text");
            body.set("agentid", msgTextInfo.getAgentid());
            body.set("text", msgTextInfo.getContent());
            String send = HttpUtil.post(wxChatProperties.getSendUri() + jsonObject.get("access_token"), body.toString());
            log.info("消息发送结果" + send);
        } catch (Exception e) {
            log.info("发送文本消息错误" + e.getLocalizedMessage());
        }

    }
}
