/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.auto.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public abstract class AbstractDefaultProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            this.fatalError(e);
            return false;
        }
    }

    protected abstract boolean processImpl(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected boolean isClass(Element e) {
        ElementKind kind = e.getKind();
        return kind == ElementKind.CLASS;
    }

    protected boolean isClassOrInterface(Element e) {
        ElementKind kind = e.getKind();
        return kind == ElementKind.CLASS || kind == ElementKind.INTERFACE;
    }

    protected AnnotationMirror getAnnotation(Elements elementUtils, Element e, String annotationFullName) {
        List<? extends AnnotationMirror> annotationList = elementUtils.getAllAnnotationMirrors(e);
        for (AnnotationMirror annotationMirror : annotationList) {
            if (this.isAnnotation(annotationFullName, annotationMirror)) {
                return annotationMirror;
            }
            Element element = annotationMirror.getAnnotationType().asElement();
            if (element.toString().startsWith("java.lang")) continue;
            return this.getAnnotation(elementUtils, element, annotationFullName);
        }
        return null;
    }

    protected boolean isAnnotation(Elements elementUtils, Element e, String annotationFullName) {
        List<? extends AnnotationMirror> annotationList = elementUtils.getAllAnnotationMirrors(e);
        for (AnnotationMirror annotationMirror : annotationList) {
            if (this.isAnnotation(annotationFullName, annotationMirror)) {
                return true;
            }
            Element element = annotationMirror.getAnnotationType().asElement();
            if (element.toString().startsWith("java.lang") || !this.isAnnotation(elementUtils, element, annotationFullName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnnotation(String annotationFullName, AnnotationMirror annotation) {
        return annotationFullName.equals(annotation.getAnnotationType().toString());
    }

    protected String getQualifiedName(Element element) {
        if (element instanceof QualifiedNameable) {
            return ((QualifiedNameable)element).getQualifiedName().toString();
        }
        return element.toString();
    }

    protected void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    protected void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    protected void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    protected void fatalError(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        this.fatalError(writer.toString());
    }

    protected void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

