/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.auto.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiSetMap<K, V> {
    private final transient Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    private Set<V> createSet() {
        return new HashSet();
    }

    public boolean put(K key, V value) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            set = this.createSet();
            if (set.add(value)) {
                this.map.put(key, set);
                return true;
            }
            throw new AssertionError((Object)"New set violated the set spec");
        }
        return set.add(value);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsVal(V value) {
        Collection<Set<V>> values = this.map.values();
        return values.stream().anyMatch(vs -> vs.contains(value));
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean putAll(K key, Set<V> set) {
        if (set == null) {
            return false;
        }
        Set vSet = this.map.computeIfAbsent(key, k -> this.createSet());
        vSet.addAll(set);
        return true;
    }

    public boolean putAll(MultiSetMap<K, V> data) {
        if (data == null || data.isEmpty()) {
            return false;
        }
        for (K k : data.keySet()) {
            this.putAll(k, data.get(k));
        }
        return true;
    }

    public Set<V> get(K key) {
        return this.map.get(key);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }
}

