/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.auto.factories;

import cn.allbs.auto.annotation.AutoIgnore;
import cn.allbs.auto.config.AbstractDefaultProcessor;
import cn.allbs.auto.config.BootAutoType;
import cn.allbs.auto.config.MultiSetMap;
import cn.allbs.auto.factories.FactoriesFiles;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"debug"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public class AutoFactoriesProcessor
extends AbstractDefaultProcessor {
    private static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    private static final String DEVTOOLS_RESOURCE_LOCATION = "META-INF/spring-devtools.properties";
    private MultiSetMap<String, String> factories = new MultiSetMap();
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateFactoriesFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return false;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log(annotations.toString());
        Set<? extends Element> elementSet = roundEnv.getRootElements();
        this.log("All Element set: " + elementSet.toString());
        Set typeElementSet = elementSet.stream().filter(this::isClassOrInterface).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).collect(Collectors.toSet());
        if (typeElementSet.isEmpty()) {
            this.log("Annotations elementSet is isEmpty");
            return;
        }
        for (TypeElement typeElement : typeElementSet) {
            if (this.isAnnotation(this.elementUtils, typeElement, AutoIgnore.class.getName())) {
                this.log("Found @AutoIgnore annotation, ignore Element: " + typeElement.toString());
                continue;
            }
            for (BootAutoType autoType : BootAutoType.values()) {
                String annotation = autoType.getAnnotation();
                if (!this.isAnnotation(this.elementUtils, typeElement, annotation)) continue;
                this.log("Found @" + annotation + " Element: " + typeElement.toString());
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e spring.factories factoryName\uff1a" + factoryName);
                this.factories.put(autoType.getConfigureKey(), factoryName);
            }
        }
    }

    private void generateFactoriesFiles() {
        if (this.factories.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            MultiSetMap<String, String> allFactories = new MultiSetMap<String, String>();
            try {
                FileObject existingFactoriesFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION);
                this.log("Looking for existing spring.factories file at " + existingFactoriesFile.toUri());
                MultiSetMap<String, String> existingFactories = FactoriesFiles.readFactoriesFile(existingFactoriesFile, this.elementUtils);
                this.log("Existing spring.factories entries: " + existingFactories);
                allFactories.putAll(existingFactories);
            }
            catch (IOException e) {
                this.log("spring.factories resource file did not already exist.");
            }
            allFactories.putAll(this.factories);
            this.log("New spring.factories file contents: " + allFactories);
            FileObject factoriesFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION, new Element[0]);
            try (OutputStream out = factoriesFile.openOutputStream();){
                FactoriesFiles.writeFactoriesFile(allFactories, out);
            }
            String classesPath = factoriesFile.toUri().toString().split("classes")[0];
            Path projectPath = Paths.get(new URI(classesPath)).getParent();
            String projectName = projectPath.getFileName().toString();
            FileObject devToolsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", DEVTOOLS_RESOURCE_LOCATION, new Element[0]);
            try (OutputStream out = devToolsFile.openOutputStream();){
                FactoriesFiles.writeDevToolsFile(projectName, out);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.fatalError(e);
        }
    }
}

