/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.auto.handler;

import cn.allbs.auto.config.AbstractDefaultProcessor;
import cn.allbs.auto.config.MultiSetMap;
import cn.allbs.auto.handler.ServicesFiles;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@SupportedOptions(value={"debug"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public class AutoServiceProcessor
extends AbstractDefaultProcessor {
    private static final String AUTO_SERVICE_NAME = AutoService.class.getName();
    private MultiSetMap<String, String> providers = new MultiSetMap();
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(AUTO_SERVICE_NAME);
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return false;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement autoService = this.elementUtils.getTypeElement(AUTO_SERVICE_NAME);
        Set<? extends Element> elementSet = roundEnv.getElementsAnnotatedWith(autoService);
        Set typeElementSet = elementSet.stream().filter(this::isClass).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).collect(Collectors.toSet());
        if (typeElementSet.isEmpty()) {
            this.log("Annotations elementSet is isEmpty");
            return;
        }
        this.log(annotations.toString());
        this.log(typeElementSet.toString());
        for (TypeElement typeElement : typeElementSet) {
            AnnotationMirror annotationMirror = this.getAnnotation(this.elementUtils, typeElement, AUTO_SERVICE_NAME);
            if (annotationMirror == null) continue;
            Set<TypeMirror> typeMirrors = this.getValueFieldOfClasses(annotationMirror);
            if (typeMirrors.isEmpty()) {
                this.error("No service interfaces provided for element!", typeElement, annotationMirror);
                continue;
            }
            String providerImplementerName = this.getQualifiedName(typeElement);
            for (TypeMirror typeMirror : typeMirrors) {
                String providerInterfaceName = this.getType(typeMirror);
                this.log("provider interface: " + providerInterfaceName);
                this.log("provider implementer: " + providerImplementerName);
                if (this.checkImplementer(typeElement, typeMirror)) {
                    this.providers.put(providerInterfaceName, this.getQualifiedName(typeElement));
                    continue;
                }
                String message = "ServiceProviders must implement their service provider interface. " + providerImplementerName + " does not implement " + providerInterfaceName;
                this.error(message, typeElement, annotationMirror);
            }
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = "META-INF/services/" + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeSet<String> allServices = new TreeSet<String>();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = ServicesFiles.readServiceFile(existingFile, this.elementUtils);
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                try (OutputStream out = fileObject.openOutputStream();){
                    ServicesFiles.writeServiceFile(allServices, out);
                }
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private boolean checkImplementer(Element providerImplementer, TypeMirror providerType) {
        Types types = this.processingEnv.getTypeUtils();
        return types.isSubtype(providerImplementer.asType(), providerType);
    }

    private Set<TypeMirror> getValueFieldOfClasses(AnnotationMirror annotationMirror) {
        return this.getAnnotationValue(annotationMirror, "value").accept(new SimpleAnnotationValueVisitor8<Set<TypeMirror>, Void>(){

            @Override
            public Set<TypeMirror> visitType(TypeMirror typeMirror, Void v) {
                return Collections.singleton(typeMirror);
            }

            @Override
            public Set<TypeMirror> visitArray(List<? extends AnnotationValue> values, Void v) {
                return values.stream().flatMap(value -> value.accept(this, null).stream()).collect(Collectors.toSet());
            }
        }, null);
    }

    public AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String elementName) {
        Objects.requireNonNull(annotationMirror);
        Objects.requireNonNull(elementName);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(elementName)) continue;
            return entry.getValue();
        }
        String annotationName = annotationMirror.getAnnotationType().toString();
        throw new IllegalArgumentException(String.format("@%s does not define an element %s()", annotationName, elementName));
    }

    public String getType(TypeMirror type) {
        if (type == null) {
            return null;
        }
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            Element enclosingElement = declaredType.asElement().getEnclosingElement();
            if (enclosingElement != null && enclosingElement instanceof TypeElement) {
                return this.getQualifiedName(enclosingElement) + "$" + declaredType.asElement().getSimpleName().toString();
            }
            return this.getQualifiedName(declaredType.asElement());
        }
        return type.toString();
    }
}

