package cn.allbs.captcha.generator;

import cn.allbs.captcha.enums.AlphaEnum;
import cn.hutool.core.util.ArrayUtil;

/**
 * 验证码生成器
 *
 * @author ChenQi
 */
public abstract class AbstractCaptchaGenerator implements CaptchaGenerator {

    /**
     * 字符选择范围
     */
    protected final char[] baseChars;

    /**
     * 字符长度
     */
    protected final int len;

    public AbstractCaptchaGenerator(char[] baseChars, int len) {
        this.baseChars = baseChars;
        this.len = len;
    }

    public AbstractCaptchaGenerator(int len) {
        this.baseChars = ArrayUtil.addAll(AlphaEnum.LOWER.getAlphas(), AlphaEnum.NUMBERS.getAlphas(), AlphaEnum.UPPER.getAlphas());
        this.len = len;
    }
}
