package cn.allbs.captcha.utils;

import cn.allbs.captcha.enums.ColorEnum;
import cn.hutool.core.util.RandomUtil;
import lombok.experimental.UtilityClass;

import java.awt.*;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

/**
 * 干扰线工具类
 *
 * @author ChenQi
 */
@UtilityClass
public class InterferingUtil {

    /**
     * 随机画干扰圆
     *
     * @param num 数量
     * @param g   Graphics2D
     */
    public void drawOval(int num, Graphics2D g, int width, int height) {
        drawOval(num, null, g, width, height);
    }

    /**
     * 随机画干扰圆
     *
     * @param num   数量
     * @param color 颜色
     * @param g     Graphics2D
     */
    public void drawOval(int num, Color color, Graphics2D g, int width, int height) {
        for (int i = 0; i < num; i++) {
            g.setColor(color == null ? ColorEnum.color() : color);
            int w = 5 + RandomUtil.randomInt(10);
            g.drawOval(RandomUtil.randomInt(width - 25), RandomUtil.randomInt(height - 15), w, w);
        }
    }

    /**
     * 随机画贝塞尔曲线
     *
     * @param num 数量
     * @param g   Graphics2D
     */
    public void drawBesselLine(int num, Graphics2D g, int width, int height) {
        drawBesselLine(num, null, g, width, height);
    }

    /**
     * 随机画贝塞尔曲线
     *
     * @param num   数量
     * @param color 颜色
     * @param g     Graphics2D
     */
    public void drawBesselLine(int num, Color color, Graphics2D g, int width, int height) {
        for (int i = 0; i < num; i++) {
            g.setColor(color == null ? ColorEnum.color() : color);
            int x1 = 5, y1 = RandomUtil.randomInt(5, height / 2);
            int x2 = width - 5, y2 = RandomUtil.randomInt(height / 2, height - 5);
            int ctrlx = RandomUtil.randomInt(width / 4, width / 4 * 3), ctrly = RandomUtil.randomInt(5, height - 5);
            if (RandomUtil.randomInt(2) == 0) {
                int ty = y1;
                y1 = y2;
                y2 = ty;
            }
            // 二阶贝塞尔曲线
            if (RandomUtil.randomInt(2) == 0) {
                QuadCurve2D shape = new QuadCurve2D.Double();
                shape.setCurve(x1, y1, ctrlx, ctrly, x2, y2);
                g.draw(shape);
            } else {
                // 三阶贝塞尔曲线
                int ctrlx1 = RandomUtil.randomInt(width / 4, width / 4 * 3), ctrly1 = RandomUtil.randomInt(5, height - 5);
                CubicCurve2D shape = new CubicCurve2D.Double(x1, y1, ctrlx, ctrly, ctrlx1, ctrly1, x2, y2);
                g.draw(shape);
            }
        }
    }
}
