package cn.allbs.captcha.captcha;

import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.enums.ColorEnum;
import cn.allbs.captcha.generator.NumberCaptchaGenerator;
import cn.allbs.captcha.utils.GifEncoder;
import cn.allbs.captcha.utils.InterferingUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

/**
 * 仅有数字的验证码
 *
 * @author ChenQi
 */
public class NumberCaptcha extends AbstractCaptcha {
    public NumberCaptcha(int width, int height, int len) {
        super(width, height, new NumberCaptchaGenerator(len), 15, len);
    }

    public NumberCaptcha(CaptchaDetails captchaDetails) {
        super(captchaDetails, new NumberCaptchaGenerator(captchaDetails.len()));
    }

    @Override
    protected Image createImage(char[] code) {
        final BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        final Graphics2D g2d = ImgUtil.createGraphics(image, ObjectUtil.defaultIfNull(this.background, Color.WHITE));
        // 填充背景
        g2d.setColor(background);
        g2d.fillRect(0, 0, width, height);
        // 抗锯齿
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        // 画干扰圆
        InterferingUtil.drawOval(2, g2d, width, height);
        // 画字符串
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        // 每一个字符所占的宽度
        int fW = width / this.len;
        // 字符的左右边距
        int fSp = (fW - (int) fontMetrics.getStringBounds("8", g2d).getWidth()) / 2;
        for (int i = 0; i < code.length; i++) {
            g2d.setColor(ColorEnum.color());
            // 字符的纵坐标
            int fY = height
                    - ((height - (int) fontMetrics.getStringBounds(String.valueOf(code[i]), g2d).getHeight()) >> 1);
            g2d.drawString(String.valueOf(code[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();

        return image;
    }

    @Override
    protected void createImageGif(char[] code) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        // 随机生成每个文字的颜色
        Color fontColor[] = new Color[len];
        for (int i = 0; i < len; i++) {
            fontColor[i] = ColorEnum.color();
        }
        // 随机生成贝塞尔曲线参数
        int x1 = 5, y1 = num(5, height / 2);
        int x2 = width - 5, y2 = num(height / 2, height - 5);
        int ctrlx = num(width / 4, width / 4 * 3), ctrly = num(5, height - 5);
        if (num(2) == 0) {
            int ty = y1;
            y1 = y2;
            y2 = ty;
        }
        int ctrlx1 = num(width / 4, width / 4 * 3), ctrly1 = num(5, height - 5);
        int[][] besselXY = new int[][]{{x1, y1}, {ctrlx, ctrly}, {ctrlx1, ctrly1}, {x2, y2}};
        // 开始画gif每一帧
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.setQuality(180);
        gifEncoder.setDelay(100);
        gifEncoder.setRepeat(0);
        gifEncoder.start(out);
        for (int i = 0; i < len; i++) {
            BufferedImage frame = graphicsImage(fontColor, code, i, besselXY);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }
}
