package cn.allbs.captcha.enums;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.RandomUtil;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.awt.*;
import java.io.IOException;

/**
 * 字体类型
 *
 * @author ChenQi
 */
@Getter
@RequiredArgsConstructor
public enum FontEnum {

    /**
     * 字体actionj
     */
    FONT_1("actionj.ttf"),

    /**
     * epilog
     */
    FONT_2("epilog.ttf"),

    /**
     * fresnel
     */
    FONT_3("fresnel.ttf"),

    /**
     * headache
     */
    FONT_4("headache.ttf"),

    /**
     * lexo
     */
    FONT_5("lexo.ttf"),

    /**
     * prefix
     */
    FONT_6("prefix.ttf"),

    /**
     * progbot
     */
    FONT_7("progbot.ttf"),

    /**
     * ransom
     */
    FONT_8("ransom.ttf"),

    /**
     * robot
     */
    FONT_9("robot.ttf"),

    /**
     * scandal
     */
    FONT_10("scandal.ttf");

    /**
     * 字体名称
     */
    private final String font;

    /**
     * 获取字体
     *
     * @param font  字体序号
     * @param style 样式
     * @param size  大小
     * @return Font
     */
    public static Font rFont(int font, int style, float size) {
        Font fontRes = null;
        try {
            fontRes = Font.createFont(Font.TRUETYPE_FONT, ResourceUtil.getStreamSafe(FontEnum.values()[font].font))
                    .deriveFont(style, size);
        } catch (FontFormatException | IOException | IndexOutOfBoundsException e) {
            return new Font("Arial", Font.BOLD, (int) size);
        }
        return fontRes;
    }

    /**
     * 获取字体
     *
     * @param font 字体序号
     * @param size 字体大小
     * @return Font
     */
    public static Font rFont(int font, float size) {
        return rFont(font, Font.BOLD, size);
    }

    /**
     * 获取字体
     *
     * @param size 字体大小
     * @return Font
     */
    public static Font rFont(float size) {
        // 获取随机字体
        FontEnum[] fontEnums = FontEnum.values();
        int font = RandomUtil.randomInt(fontEnums.length);
        return rFont(font, size);
    }

    /**
     * 获取随机字体
     *
     * @return Font
     */
    public static Font rFont() {
        return rFont(32f);
    }
}
