package cn.allbs.captcha.generator;

import cn.allbs.captcha.enums.AlphaEnum;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

/**
 * 仅因为字符验证码
 *
 * @author ChenQi
 */
public class CharCaptchaGenerator extends AbstractCaptchaGenerator {

    public CharCaptchaGenerator(int len) {
        super(ArrayUtil.addAll(AlphaEnum.UPPER.getAlphas(), AlphaEnum.LOWER.getAlphas()), len);
    }

    public CharCaptchaGenerator(char[] baseChars, int len) {
        super(baseChars, len);
    }

    @Override
    public char[] generator() {
        char[] codes = new char[this.len];
        for (int i = 0; i < this.len; i++) {
            codes[i] = this.baseChars[RandomUtil.randomInt(this.baseChars.length)];
        }
        return codes;
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank(generatorCode, checkedCode)) {
            return StrUtil.equalsIgnoreCase(generatorCode, checkedCode);
        }
        return false;
    }
}
