/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.core;

import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.enums.ImageEnum;
import java.awt.Color;
import java.awt.Font;

public class CaptchaInfo
implements CaptchaDetails {
    private final int len;
    private final int width;
    private final int height;
    private final Font font;
    private final Color color;
    private final int type;
    private final int interfereCount;
    private final int imageType;

    CaptchaInfo(int len, int width, int height, Font font, Color color, int type, int interfereCount, int imageType) {
        this.len = len;
        this.width = width;
        this.height = height;
        this.font = font;
        this.color = color;
        this.type = type;
        this.interfereCount = interfereCount;
        this.imageType = imageType;
    }

    @Override
    public int len() {
        return this.len;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public Font font() {
        return this.font;
    }

    @Override
    public Color color() {
        return this.color;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public int interfereCount() {
        return this.interfereCount;
    }

    @Override
    public int imageType() {
        return this.imageType;
    }

    public static CaptchaInfoBuild builder() {
        return new CaptchaInfoBuild();
    }

    public String toString() {
        return "CaptchaInfo(len=" + this.len + ", width=" + this.width + ", height=" + this.height + ", font=" + this.font + ", color=" + this.color + ", type=" + this.type + ", interfereCount=" + this.interfereCount + ", imageType=" + this.imageType + ")";
    }

    public static final class CaptchaInfoBuild {
        private int len = 4;
        private int width = 130;
        private int height = 48;
        private Font font = new Font("Arial", 1, 32);
        private Color color = new Color(255, 255, 255);
        private int type;
        private int interfereCount = 15;
        private int imageType = ImageEnum.GIF.getType();

        public CaptchaInfoBuild size(int len, int width, int height) {
            this.len = len;
            this.width = width;
            this.height = height;
            return this;
        }

        public CaptchaInfoBuild font(Font font) {
            this.font = font;
            return this;
        }

        public CaptchaInfoBuild color(Color color) {
            this.color = color;
            return this;
        }

        public CaptchaInfoBuild type(int type) {
            this.type = type;
            return this;
        }

        public CaptchaInfoBuild interfereCount(int interfereCount) {
            this.interfereCount = interfereCount;
            return this;
        }

        public CaptchaInfoBuild imageType(int imageType) {
            this.imageType = imageType;
            return this;
        }

        public CaptchaDetails build() {
            return new CaptchaInfo(this.len, this.width, this.height, this.font, this.color, this.type, this.interfereCount, this.imageType);
        }
    }
}

