/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.utils;

import cn.allbs.captcha.enums.ColorEnum;
import cn.hutool.core.util.RandomUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public final class InterferingUtil {
    public static void drawOval(int num, Graphics2D g, int width, int height) {
        InterferingUtil.drawOval(num, null, g, width, height);
    }

    public static void drawOval(int num, Color color, Graphics2D g, int width, int height) {
        for (int i = 0; i < num; ++i) {
            g.setColor(color == null ? ColorEnum.color() : color);
            int w = 5 + RandomUtil.randomInt((int)10);
            g.drawOval(RandomUtil.randomInt((int)(width - 25)), RandomUtil.randomInt((int)(height - 15)), w, w);
        }
    }

    public static void drawBesselLine(int num, Graphics2D g, int width, int height) {
        InterferingUtil.drawBesselLine(num, null, g, width, height);
    }

    public static void drawBesselLine(int num, Color color, Graphics2D g, int width, int height) {
        for (int i = 0; i < num; ++i) {
            g.setColor(color == null ? ColorEnum.color() : color);
            int x1 = 5;
            int y1 = RandomUtil.randomInt((int)5, (int)(height / 2));
            int x2 = width - 5;
            int y2 = RandomUtil.randomInt((int)(height / 2), (int)(height - 5));
            int ctrlx = RandomUtil.randomInt((int)(width / 4), (int)(width / 4 * 3));
            int ctrly = RandomUtil.randomInt((int)5, (int)(height - 5));
            if (RandomUtil.randomInt((int)2) == 0) {
                int ty = y1;
                y1 = y2;
                y2 = ty;
            }
            if (RandomUtil.randomInt((int)2) == 0) {
                QuadCurve2D.Double shape = new QuadCurve2D.Double();
                ((QuadCurve2D)shape).setCurve(x1, y1, ctrlx, ctrly, x2, y2);
                g.draw(shape);
                continue;
            }
            int ctrlx1 = RandomUtil.randomInt((int)(width / 4), (int)(width / 4 * 3));
            int ctrly1 = RandomUtil.randomInt((int)5, (int)(height - 5));
            CubicCurve2D.Double shape = new CubicCurve2D.Double(x1, y1, ctrlx, ctrly, ctrlx1, ctrly1, x2, y2);
            g.draw(shape);
        }
    }

    private InterferingUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

